/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.data;

import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class DataRecordKey {
    private final long tag;
    private final Instant timestamp;

    public DataRecordKey(long tag, @Nonnull Instant timestamp) {
        this.tag = tag;
        this.timestamp = timestamp;
    }

    public long getTag() {
        return this.tag;
    }

    @Nonnull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.timestamp);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataRecordKey) {
            DataRecordKey that = (DataRecordKey)obj;
            return this.tag == that.tag && this.timestamp.equals(that.timestamp);
        }
        return false;
    }

    public String toString() {
        return String.format("%s(%s,%s)", this.getClass().getSimpleName(), this.tag, this.timestamp);
    }
}

