/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLException;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.hsqldb.Database;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCConnection;
import org.marid.logging.LogSupport;

public class JDBCSessionConnection
extends JDBCConnection
implements LogSupport {
    public JDBCSessionConnection(@Nonnull Database database, @Nonnull String schema) throws SQLException {
        super((SessionInterface)database.getSessionManager().newSysSession());
        this.setSchema(schema);
    }

    public synchronized void close() throws SQLException {
        try {
            this.sessionProxy.close();
        }
        catch (Throwable x) {
            this.log(Level.SEVERE, "Unable to close session id={0}", x, new Object[]{this.sessionProxy.getId()});
        }
        finally {
            this.sessionProxy = null;
        }
    }
}

