/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.jdbc.JDBCSessionConnection;
import org.hsqldb.jdbc.JDBCSessionDataSource;
import org.hsqldb.jdbc.JDBCSessionPool;
import org.hsqldb.server.Server;
import org.marid.db.dao.NumericWriter;
import org.marid.db.impl.HsqldbDaqNumericWriter;
import org.marid.db.impl.HsqldbProperties;
import org.marid.logging.LogSupport;

public final class HsqldbDatabase
implements Closeable,
LogSupport {
    private final Server server;
    private final File directory;
    private final URI sqlDirectoryUri;
    private final long shutdownTimeout;
    private final int connectionPoolSize;
    private final Map<String, Integer> databaseNameToIndex = new TreeMap<String, Integer>();
    private PrintWriter outWriter;
    private PrintWriter errWriter;

    public HsqldbDatabase(HsqldbProperties properties) {
        this.directory = properties.getDirectory();
        this.sqlDirectoryUri = properties.getSqlDirectoryUri();
        this.shutdownTimeout = TimeUnit.SECONDS.toMillis(properties.getShutdownTimeoutSeconds());
        this.connectionPoolSize = properties.getConnectionPoolSize();
        this.server = new Server();
        this.server.setNoSystemExit(true);
        this.server.setRestartOnShutdown(false);
        this.server.setDaemon(false);
        this.setDatabase("numerics");
    }

    private void setDatabase(String name) {
        int index = this.databaseNameToIndex.size();
        this.server.setDatabaseName(index, name);
        this.server.setDatabasePath(index, new File(this.directory, name).getAbsolutePath());
        this.databaseNameToIndex.put(name, index);
    }

    @PostConstruct
    public void init() throws IOException {
        this.outWriter = new PrintWriter(new File(this.directory, "output.log"));
        this.errWriter = new PrintWriter(new File(this.directory, "errors.log"));
        this.server.start();
        for (String db : this.databaseNameToIndex.keySet()) {
            try {
                this.initDatabase(db);
            }
            catch (IOException | SQLException x) {
                this.log(WARNING, "Unable to init DB {0}", x, new Object[]{db});
            }
        }
    }

    @PreDestroy
    public void destroy() throws IOException {
        this.close();
    }

    private void initDatabase(String name) throws SQLException, IOException {
        block57: {
            int index = this.databaseNameToIndex.get(name);
            Database database = DatabaseManager.getDatabase((int)index);
            try (JDBCSessionConnection c = new JDBCSessionConnection(database, "PUBLIC");){
                boolean tableExists;
                c.setAutoCommit(true);
                try (ResultSet rs = c.getMetaData().getTables(null, null, name.toUpperCase(), new String[]{"TABLE"});){
                    tableExists = rs.next();
                }
                if (tableExists) {
                    this.log(INFO, "Table {0} already exists in DB {1}", new Object[]{name.toUpperCase(), name});
                    return;
                }
                var8_8 = null;
                try (Statement s = c.createStatement();){
                    File sqlFile = new File(this.sqlDirectoryUri.resolve(name + ".sql"));
                    if (sqlFile.length() <= 0L) break block57;
                    Scanner scanner = new Scanner(sqlFile);
                    Throwable throwable = null;
                    block41: while (true) {
                        try {
                            while (scanner.hasNextLine()) {
                                String sql = scanner.nextLine().trim();
                                if (sql.startsWith("--") || sql.isEmpty()) continue;
                                try {
                                    this.log(INFO, "Executing {0}", new Object[]{sql});
                                    s.execute(sql);
                                    continue block41;
                                }
                                catch (SQLException x) {
                                    this.log(WARNING, "Unable to execute '{0}'", x, new Object[]{sql});
                                }
                            }
                            break block57;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    finally {
                        if (scanner != null) {
                            if (throwable != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                scanner.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    var8_8 = throwable;
                    throw throwable;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void close() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DataSource getDataSource(String name) {
        int dbIndex = this.databaseNameToIndex.get(name);
        Database database = DatabaseManager.getDatabase((int)dbIndex);
        return this.connectionPoolSize == 0 ? new JDBCSessionDataSource(database, name.toUpperCase()) : new JDBCSessionPool(this.connectionPoolSize, database, name.toUpperCase());
    }

    public NumericWriter numericWriter() {
        return new HsqldbDaqNumericWriter(this.getDataSource("numerics"), "NUMERICS");
    }
}

