/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.generator.swing;

import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import org.marid.db.generator.swing.SwingNumericDaqGeneratorModel;

public class SliderTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final DefaultBoundedRangeModel model = new DefaultBoundedRangeModel();
    private final JSlider slider = new JSlider(this.model);
    private ChangeListener changeListener;

    public SliderTableCellEditor() {
        this.slider.setRequestFocusEnabled(false);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.setPaintLabels(true);
        this.slider.setFont(new Font("Dialog", 0, 8));
        this.slider.setFocusable(false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        SwingNumericDaqGeneratorModel model = (SwingNumericDaqGeneratorModel)table.getModel();
        SwingNumericDaqGeneratorModel.TagInfo tagInfo = model.get(row);
        this.slider.setMinimum(tagInfo.minValue);
        this.slider.setMaximum(tagInfo.maxValue);
        this.slider.setMajorTickSpacing(Math.max((tagInfo.maxValue - tagInfo.minValue) / 10, 1));
        this.slider.setMinorTickSpacing(Math.max((tagInfo.maxValue - tagInfo.minValue) / 100, 1));
        this.slider.setValue(((Number)value).intValue());
        if (this.changeListener != null) {
            this.slider.removeChangeListener(this.changeListener);
        }
        this.changeListener = e -> {
            tagInfo.value = this.slider.getValue();
            model.fireTableCellUpdated(row, 3);
        };
        this.slider.addChangeListener(this.changeListener);
        return this.slider;
    }

    @Override
    public Object getCellEditorValue() {
        return this.slider.getValue();
    }

    @Override
    public boolean stopCellEditing() {
        if (this.changeListener != null) {
            this.slider.removeChangeListener(this.changeListener);
        }
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        if (this.changeListener != null) {
            this.slider.removeChangeListener(this.changeListener);
        }
        super.cancelCellEditing();
    }
}

