/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.generator.swing;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.marid.db.generator.swing.SwingNumericDaqGeneratorModel;

public class SliderTableCellRenderer
implements TableCellRenderer {
    private final DefaultBoundedRangeModel model = new DefaultBoundedRangeModel();
    private final JSlider slider = new JSlider(this.model);

    public SliderTableCellRenderer() {
        this.slider.setRequestFocusEnabled(false);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.setPaintLabels(true);
        this.slider.setFont(new Font("Dialog", 0, 8));
        this.slider.setFocusable(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        SwingNumericDaqGeneratorModel model = (SwingNumericDaqGeneratorModel)table.getModel();
        SwingNumericDaqGeneratorModel.TagInfo tagInfo = model.get(row);
        this.slider.setMinimum(tagInfo.minValue);
        this.slider.setMaximum(tagInfo.maxValue);
        this.slider.setMajorTickSpacing(Math.max((tagInfo.maxValue - tagInfo.minValue) / 10, 1));
        this.slider.setMinorTickSpacing(Math.max((tagInfo.maxValue - tagInfo.minValue) / 100, 1));
        this.slider.setValue(((Number)value).intValue());
        return this.slider;
    }
}

