/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.generator.swing;

import java.awt.EventQueue;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import org.marid.db.dao.NumericWriter;
import org.marid.db.generator.swing.SwingNumericDaqGeneratorFrame;
import org.marid.logging.LogSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;

public class SwingNumericDaqGenerator
implements LogSupport {
    private final NumericWriter numericWriter;

    public SwingNumericDaqGenerator(NumericWriter numericWriter) {
        this.numericWriter = numericWriter;
    }

    @Autowired
    private void init(ConfigurableApplicationContext context) throws UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(new NimbusLookAndFeel());
        EventQueue.invokeLater(() -> {
            SwingNumericDaqGeneratorFrame frame = new SwingNumericDaqGeneratorFrame(this.numericWriter);
            context.addApplicationListener(event -> {
                ContextClosedEvent e;
                if (event instanceof ContextClosedEvent && (e = (ContextClosedEvent)event).getApplicationContext() == context) {
                    frame.dispose();
                }
            });
            frame.setVisible(true);
        });
    }
}

