/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.generator.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.marid.db.dao.NumericWriter;
import org.marid.db.data.DataRecord;
import org.marid.db.generator.swing.SliderTableCellEditor;
import org.marid.db.generator.swing.SliderTableCellRenderer;
import org.marid.db.generator.swing.SwingNumericDaqGeneratorModel;
import org.marid.l10n.L10n;
import org.marid.logging.LogSupport;
import org.marid.xml.XmlBind;

class SwingNumericDaqGeneratorFrame
extends JFrame
implements LogSupport {
    private final SwingNumericDaqGeneratorModel model = new SwingNumericDaqGeneratorModel();
    private final JTable table = new JTable(this.model);
    private final JSpinner periodSpinner = new JSpinner(new SpinnerNumberModel(1000, 100, 60000, 100));
    private final Map<String, Action> actionMap = new HashMap<String, Action>();
    private final Timer timer;

    SwingNumericDaqGeneratorFrame(NumericWriter numericWriter) {
        super(L10n.s((String)"Swing numeric DAQ generator", (Object[])new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(new JMenuBar());
        this.setPreferredSize(new Dimension(800, 600));
        this.add(new JScrollPane(this.table, 20, 31));
        this.add((Component)this.toolBar(), "North");
        this.pack();
        this.setLocationRelativeTo(null);
        this.initColumns();
        this.timer = new Timer((Integer)this.periodSpinner.getValue(), e -> {
            ArrayList<DataRecord> records = new ArrayList<DataRecord>();
            this.model.visitTagInfos(tagInfo -> records.add(new DataRecord(tagInfo.tag, Instant.now(), (Serializable)Double.valueOf(tagInfo.value))));
            records.forEach(record -> this.log(INFO, "Generated {0}", new Object[]{record}));
            numericWriter.merge(records, true);
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SwingNumericDaqGeneratorFrame.this.timer.stop();
            }
        });
        this.periodSpinner.addChangeListener(e -> this.timer.setDelay((Integer)this.periodSpinner.getValue()));
    }

    private void initColumns() {
        this.table.setRowHeight(48);
        this.table.setShowGrid(true);
        this.table.setGridColor(SystemColor.control);
        int[] widths = new int[]{100, 50, 50, 50, 300};
        for (int i = 0; i < widths.length; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setMinWidth(widths[i] / 2);
            column.setMaxWidth(widths[i] * 5);
            column.setPreferredWidth(widths[i]);
        }
        TableColumn lastColumn = this.table.getColumnModel().getColumn(4);
        lastColumn.setCellEditor(new SliderTableCellEditor());
        lastColumn.setCellRenderer(new SliderTableCellRenderer());
    }

    private JToolBar toolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.add(toolBar, "Add tag", "awicons/vista-artistic/24/add-icon.png", e -> {
            long maxTag = this.model.maxTag();
            SwingNumericDaqGeneratorModel.TagInfo tagInfo = new SwingNumericDaqGeneratorModel.TagInfo();
            tagInfo.tag = maxTag + 1L;
            this.model.add(tagInfo);
        });
        toolBar.addSeparator();
        this.add(toolBar, "Load", "oxygen-icons.org/oxygen/24/Actions-document-open-icon.png", e -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileNameExtensionFilter("XML", "xml"));
            chooser.setMultiSelectionEnabled(false);
            switch (chooser.showOpenDialog(this)) {
                case 0: {
                    File file = chooser.getSelectedFile();
                    this.model.load((SwingNumericDaqGeneratorModel)XmlBind.load(SwingNumericDaqGeneratorModel.class, (Object)file, Unmarshaller::unmarshal));
                }
            }
        });
        this.add(toolBar, "Save", "oxygen-icons.org/oxygen/24/Actions-document-save-icon.png", e -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileNameExtensionFilter("XML", "xml"));
            switch (chooser.showOpenDialog(this)) {
                case 0: {
                    if (!chooser.getSelectedFile().getName().endsWith(".xml")) {
                        File file = chooser.getSelectedFile();
                        chooser.setSelectedFile(new File(file.getParentFile(), file.getName() + ".xml"));
                    }
                    XmlBind.save((Object)this.model, (Object)chooser.getSelectedFile(), Marshaller::marshal);
                }
            }
        });
        toolBar.addSeparator();
        this.add(toolBar, "Run", "oxygen-icons.org/oxygen/24/Actions-media-playback-start-icon.png", e -> {
            this.actionMap.get("Run").setEnabled(false);
            this.actionMap.get("Stop").setEnabled(true);
            this.timer.start();
        });
        this.add(toolBar, "Stop", "oxygen-icons.org/oxygen/24/Actions-media-playback-stop-icon.png", e -> {
            this.actionMap.get("Run").setEnabled(true);
            this.actionMap.get("Stop").setEnabled(false);
            this.timer.stop();
        }).getAction().setEnabled(false);
        toolBar.addSeparator();
        toolBar.add(this.periodSpinner);
        Stream.of(toolBar.getComponents()).forEach(c -> c.setFocusable(false));
        return toolBar;
    }

    private JButton add(JToolBar toolBar, String label, String path, final ActionListener listener) {
        String text = L10n.s((String)label, (Object[])new Object[0]);
        AbstractAction action = new AbstractAction(text, SwingNumericDaqGeneratorFrame.icon("http://icons.iconarchive.com/icons/" + path)){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.actionPerformed(e);
            }
        };
        this.actionMap.put(label, action);
        action.putValue("ShortDescription", text);
        return toolBar.add(action);
    }

    private static ImageIcon icon(String url) {
        try {
            return new ImageIcon(new URL(url));
        }
        catch (Exception x) {
            return null;
        }
    }
}

