/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.generator.swing;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import javax.swing.table.AbstractTableModel;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.marid.l10n.L10n;

@XmlRootElement(name="model")
@XmlSeeAlso(value={TagInfo.class})
class SwingNumericDaqGeneratorModel
extends AbstractTableModel {
    @XmlElement(name="tag")
    private final ArrayList<TagInfo> list = new ArrayList();

    SwingNumericDaqGeneratorModel() {
    }

    public void load(SwingNumericDaqGeneratorModel model) {
        this.list.clear();
        this.list.addAll(model.list);
        this.fireTableDataChanged();
    }

    public TagInfo get(int index) {
        return this.list.get(index);
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    public void visitTagInfos(Consumer<TagInfo> consumer) {
        this.list.forEach(consumer);
    }

    public long maxTag() {
        return this.list.stream().mapToLong(t -> t.tag).max().orElse(0L);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.class;
            }
        }
        return Integer.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TagInfo tagInfo = this.list.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return tagInfo.tag;
            }
            case 1: {
                return tagInfo.minValue;
            }
            case 2: {
                return tagInfo.maxValue;
            }
            case 3: {
                return tagInfo.value;
            }
            case 4: {
                return tagInfo.value;
            }
        }
        throw new IllegalArgumentException(Integer.toString(columnIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return L10n.s((String)"Tag", (Object[])new Object[0]);
            }
            case 1: {
                return L10n.s((String)"Min", (Object[])new Object[0]);
            }
            case 2: {
                return L10n.s((String)"Max", (Object[])new Object[0]);
            }
            case 3: {
                return L10n.s((String)"Value", (Object[])new Object[0]);
            }
            case 4: {
                return L10n.s((String)"Control", (Object[])new Object[0]);
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        TagInfo tagInfo = this.list.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                tagInfo.tag = ((Number)aValue).longValue();
                break;
            }
            case 1: {
                tagInfo.minValue = ((Number)aValue).intValue();
                break;
            }
            case 2: {
                tagInfo.maxValue = ((Number)aValue).intValue();
                break;
            }
            case 4: {
                tagInfo.value = ((Number)aValue).intValue();
            }
        }
    }

    public void add(TagInfo tagInfo) {
        this.list.add(tagInfo);
        this.fireTableRowsInserted(this.list.size() - 1, this.list.size() - 1);
    }

    public void sort() {
        this.list.sort(Comparator.comparingLong(i -> i.tag));
        this.fireTableDataChanged();
    }

    @XmlRootElement(name="tag")
    public static class TagInfo {
        @XmlAttribute(name="tag")
        long tag = 1L;
        @XmlAttribute(name="min")
        int minValue = 0;
        @XmlAttribute(name="max")
        int maxValue = 100;
        @XmlAttribute(name="val")
        int value = 0;
    }
}

