/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.hsqldb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.jdbc.JDBCSessionDataSource;
import org.hsqldb.server.Server;
import org.marid.db.hsqldb.HsqldbProperties;
import org.marid.logging.LogSupport;

public final class HsqldbDatabase
implements Closeable,
LogSupport {
    private final Server server;
    private final File directory;
    private final long shutdownTimeout;
    private final Map<String, URL> databaseNameToIndex = new LinkedHashMap<String, URL>();
    private PrintWriter outWriter;
    private PrintWriter errWriter;

    public HsqldbDatabase(HsqldbProperties properties) throws MalformedURLException {
        this.log(INFO, "{0}", new Object[]{properties});
        this.directory = properties.getDirectory();
        this.shutdownTimeout = TimeUnit.SECONDS.toMillis(properties.getShutdownTimeoutSeconds());
        this.server = new Server();
        this.server.setNoSystemExit(true);
        this.server.setRestartOnShutdown(false);
        this.server.setPort(properties.getPort());
        this.server.setSilent(properties.isSilent());
        if (properties.getDatabases() == null) {
            this.setDatabase("NUMERICS", this.getClass().getResource("default.sql"));
        } else {
            for (String database : properties.getDatabases().stringPropertyNames()) {
                String urlText = properties.getDatabases().getProperty(database);
                if (!urlText.contains("://")) {
                    this.setDatabase(database, this.getClass().getClassLoader().getResource(urlText));
                    continue;
                }
                this.setDatabase(database, new URL(urlText));
            }
        }
    }

    private void setDatabase(String name, URL url) {
        int index = this.databaseNameToIndex.size();
        this.server.setDatabaseName(index, name);
        this.server.setDatabasePath(index, new File(this.directory, name).getAbsolutePath());
        this.databaseNameToIndex.put(name, url);
    }

    @PostConstruct
    public void init() throws IOException {
        this.outWriter = new PrintWriter(new File(this.directory, "output.log"));
        this.errWriter = new PrintWriter(new File(this.directory, "errors.log"));
        this.server.start();
        for (Map.Entry<String, URL> e : this.databaseNameToIndex.entrySet()) {
            try {
                this.initDatabase(e.getKey(), e.getValue());
            }
            catch (IOException | SQLException x) {
                this.log(WARNING, "Unable to init DB {0}", x, new Object[]{e.getKey()});
            }
        }
    }

    @PreDestroy
    public void destroy() throws IOException {
        this.close();
    }

    private void initDatabase(String name, URL url) throws SQLException, IOException {
        block57: {
            try (Connection c = this.dataSource(name).getConnection();){
                boolean tableExists;
                c.setAutoCommit(true);
                try (ResultSet rs = c.getMetaData().getTables(null, null, name, new String[]{"TABLE"});){
                    tableExists = rs.next();
                }
                if (tableExists) {
                    this.log(INFO, "Table {0} already exists", new Object[]{name});
                    return;
                }
                var7_7 = null;
                try (Statement s = c.createStatement();){
                    Scanner scanner = new Scanner(url.openStream());
                    Throwable throwable = null;
                    block41: while (true) {
                        try {
                            while (scanner.hasNextLine()) {
                                String sql = scanner.nextLine().trim();
                                if (sql.startsWith("--") || sql.isEmpty()) continue;
                                try {
                                    this.log(INFO, "Executing {0}", new Object[]{sql});
                                    s.execute(sql);
                                    continue block41;
                                }
                                catch (SQLException x) {
                                    this.log(WARNING, "Unable to execute '{0}'", x, new Object[]{sql});
                                }
                            }
                            break block57;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    finally {
                        if (scanner != null) {
                            if (throwable != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                scanner.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    var7_7 = throwable;
                    throw throwable;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void close() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DataSource dataSource(String name) {
        int dbIndex = this.databaseNameToIndex.keySet().stream().collect(Collectors.toList()).indexOf(name);
        Database database = DatabaseManager.getDatabase((int)dbIndex);
        return new JDBCSessionDataSource(database, "PUBLIC");
    }
}

