/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLException;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.hsqldb.Database;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCConnection;
import org.marid.logging.Log;
import org.marid.runtime.annotation.MaridBean;
import org.marid.runtime.annotation.MaridBeanProducer;

@MaridBean
public class JDBCSessionConnection
extends JDBCConnection {
    @MaridBeanProducer(name="HSQLDB JDBC Session Connection", icon="D_DISK_ALERT")
    public JDBCSessionConnection(@Nonnull Database database, @Nonnull String schema) throws SQLException {
        super((SessionInterface)database.getSessionManager().newSysSession());
        this.setSchema(schema);
    }

    public synchronized void close() throws SQLException {
        try {
            this.sessionProxy.close();
        }
        catch (Throwable x) {
            Log.log((Level)Level.SEVERE, (String)"Unable to close session id={0}", (Throwable)x, (Object[])new Object[]{this.sessionProxy.getId()});
        }
        finally {
            this.sessionProxy = null;
        }
    }
}

