/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.hsqldb;

import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.marid.db.dao.NumericWriter;
import org.marid.db.hsqldb.HsqldbDaqAbstractWriter;
import org.marid.runtime.annotation.MaridBean;
import org.marid.runtime.annotation.MaridBeanProducer;

@MaridBean(group="DAQ")
public class HsqldbDaqNumericWriter
extends HsqldbDaqAbstractWriter<Double>
implements NumericWriter {
    @MaridBeanProducer(name="HSQLDB DAQ Numeric Writer", icon="D_WINDOW_RESTORE")
    public HsqldbDaqNumericWriter(DataSource dataSource, String table) {
        super(dataSource, table);
    }

    @Override
    protected void setValue(PreparedStatement statement, int index, Double value) throws SQLException {
        statement.setDouble(index, value);
    }

    @Override
    protected Double getValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getDouble(index);
    }

    @Override
    protected byte[] toByteArray(@Nonnull Double value) {
        return ByteBuffer.allocate(8).putDouble(0, value).array();
    }

    @Override
    protected String getSqlTypeName() {
        return "double";
    }
}

