/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.generator;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.marid.concurrent.MaridTimerTask;
import org.marid.db.dao.NumericWriter;
import org.marid.db.data.DataRecord;
import org.marid.logging.Log;
import org.marid.runtime.annotation.MaridBean;
import org.marid.runtime.annotation.MaridBeanProducer;

@MaridBean(group="DAQ Generators", name="Random Numeric DAQ Generator", icon="D_RADIO", description="Generates random sequences of numbers")
public class RandomNumericDaqGenerator {
    private final NumericWriter numericWriter;
    private final long tag;
    private final double min;
    private final double max;
    private final long periodMillis;
    private final Timer timer = new Timer();

    @MaridBeanProducer(name="Random Numeric DAQ Generator Producer", icon="D_RADIO")
    public RandomNumericDaqGenerator(NumericWriter numericWriter, long tag, double min, double max, long periodSeconds) {
        this.numericWriter = numericWriter;
        this.tag = tag;
        this.min = min;
        this.max = max;
        this.periodMillis = TimeUnit.SECONDS.toMillis(periodSeconds);
    }

    @PostConstruct
    public void start() {
        this.timer.schedule((TimerTask)new MaridTimerTask(task -> {
            double v;
            long t = System.currentTimeMillis();
            Set result = this.numericWriter.merge(Collections.singletonList(new DataRecord(this.tag, t, (Serializable)Double.valueOf(v = ThreadLocalRandom.current().nextDouble(this.min, this.max)))), true);
            if (!result.isEmpty()) {
                Log.log((Level)Level.INFO, (String)"Generated {0} {1} {2}", (Object[])new Object[]{this.tag, t, v});
            }
        }), this.periodMillis, this.periodMillis);
    }

    @PreDestroy
    public void stop() {
        this.timer.cancel();
    }
}

