/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.hsqldb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.jdbc.JDBCSessionDataSource;
import org.hsqldb.server.Server;
import org.marid.db.hsqldb.HsqldbProperties;
import org.marid.logging.Log;

public final class HsqldbDatabase
implements Closeable {
    private final Server server;
    private final File directory;
    private final long shutdownTimeout;
    private final Map<String, URL> databaseNameToIndex = new LinkedHashMap<String, URL>();
    private PrintWriter outWriter;
    private PrintWriter errWriter;

    public HsqldbDatabase(HsqldbProperties properties) throws MalformedURLException {
        Log.log((Level)Level.INFO, (String)"{0}", (Object[])new Object[]{properties});
        this.directory = properties.getDirectory();
        this.shutdownTimeout = TimeUnit.SECONDS.toMillis(properties.getShutdownTimeoutSeconds());
        this.server = new Server();
        this.server.setNoSystemExit(true);
        this.server.setRestartOnShutdown(false);
        this.server.setPort(properties.getPort());
        this.server.setSilent(properties.isSilent());
        if (properties.getDatabases() == null) {
            this.setDatabase("NUMERICS", this.getClass().getResource("default.sql"));
        } else {
            for (String database : properties.getDatabases().stringPropertyNames()) {
                String urlText = properties.getDatabases().getProperty(database);
                if (!urlText.contains("://")) {
                    this.setDatabase(database, this.getClass().getClassLoader().getResource(urlText));
                    continue;
                }
                this.setDatabase(database, new URL(urlText));
            }
        }
    }

    private void setDatabase(String name, URL url) {
        int index = this.databaseNameToIndex.size();
        this.server.setDatabaseName(index, name);
        this.server.setDatabasePath(index, new File(this.directory, name).getAbsolutePath());
        this.databaseNameToIndex.put(name, url);
    }

    public void init() throws IOException {
        this.outWriter = new PrintWriter(new File(this.directory, "output.log"));
        this.errWriter = new PrintWriter(new File(this.directory, "errors.log"));
        this.server.start();
        for (Map.Entry<String, URL> e : this.databaseNameToIndex.entrySet()) {
            try {
                this.initDatabase(e.getKey(), e.getValue());
            }
            catch (IOException | SQLException x) {
                Log.log((Level)Level.WARNING, (String)"Unable to init DB {0}", (Throwable)x, (Object[])new Object[]{e.getKey()});
            }
        }
    }

    private void initDatabase(String name, URL url) throws SQLException, IOException {
        block30: {
            try (Connection c = this.dataSource(name).getConnection();){
                boolean tableExists;
                c.setAutoCommit(true);
                try (ResultSet rs = c.getMetaData().getTables(null, null, name, new String[]{"TABLE"});){
                    tableExists = rs.next();
                }
                if (tableExists) {
                    Log.log((Level)Level.INFO, (String)"Table {0} already exists", (Object[])new Object[]{name});
                    return;
                }
                var7_6 = null;
                try (Statement s = c.createStatement();){
                    Scanner scanner = new Scanner(url.openStream());
                    Throwable throwable = null;
                    block23: while (true) {
                        try {
                            while (scanner.hasNextLine()) {
                                String sql = scanner.nextLine().trim();
                                if (sql.startsWith("--") || sql.isEmpty()) continue;
                                try {
                                    Log.log((Level)Level.INFO, (String)"Executing {0}", (Object[])new Object[]{sql});
                                    s.execute(sql);
                                    continue block23;
                                }
                                catch (SQLException x) {
                                    Log.log((Level)Level.WARNING, (String)"Unable to execute '{0}'", (Throwable)x, (Object[])new Object[]{sql});
                                }
                            }
                            break block30;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    finally {
                        HsqldbDatabase.$closeResource(throwable, scanner);
                    }
                }
                catch (Throwable throwable) {
                    var7_6 = throwable;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        out = this.outWriter;
        var2_2 = null;
        try {
            err = this.errWriter;
            var4_5 = null;
            this.server.shutdown();
            startTime = System.currentTimeMillis();
lbl9:
            // 2 sources

            while (true) {
                if (System.currentTimeMillis() - startTime >= this.shutdownTimeout) throw new InterruptedIOException("Server shutdown timeout exceeded");
                if (this.server.getState() == 16) {
                    if (err == null) return;
                }
                ** GOTO lbl24
                break;
            }
            {
                catch (Throwable var5_7) {
                    var4_5 = var5_7;
                    throw var5_7;
                }
                catch (Throwable var7_8) {
                    if (err == null) throw var7_8;
                    HsqldbDatabase.$closeResource(var4_5, err);
                    throw var7_8;
                }
                HsqldbDatabase.$closeResource(var4_5, err);
                return;
lbl24:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [5 : 73->122)] { 
lbl-1000:
                // 1 sources

                {
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                    ** continue;
                }
            }
        }
lbl27:
        // 2 sources

        catch (Throwable var3_4) {
            var2_2 = var3_4;
            throw var3_4;
        }
        finally {
            if (out != null) {
                HsqldbDatabase.$closeResource(var2_2, out);
            }
        }
    }

    public DataSource dataSource(String name) {
        int dbIndex = new ArrayList<String>(this.databaseNameToIndex.keySet()).indexOf(name);
        Database database = DatabaseManager.getDatabase((int)dbIndex);
        return new JDBCSessionDataSource(database, "PUBLIC");
    }

    static {
        System.setProperty("hsqldb.reconfig_logging", "false");
    }
}

