/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.hsqldb;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.marid.db.dao.DaqWriter;
import org.marid.db.data.DataRecord;
import org.marid.db.data.DataRecordKey;
import org.marid.db.hsqldb.HsqldbDaqAbstractReader;

abstract class HsqldbDaqAbstractWriter<T extends Serializable>
extends HsqldbDaqAbstractReader<T>
implements DaqWriter<T> {
    public HsqldbDaqAbstractWriter(DataSource dataSource, String table) {
        super(dataSource, table);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long delete(long from, long to) {
        String sql = "delete from " + this.table + " where TS >= ? and TS < ?";
        try (Connection c = this.dataSource.getConnection();){
            long l;
            block14: {
                PreparedStatement s = c.prepareStatement(sql);
                try {
                    c.setAutoCommit(true);
                    s.setTimestamp(1, new Timestamp(from));
                    s.setTimestamp(2, new Timestamp(to));
                    l = s.executeUpdate();
                    if (s == null) break block14;
                }
                catch (Throwable throwable) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                s.close();
            }
            return l;
        }
        catch (SQLException x) {
            throw new IllegalStateException(x);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long delete(long[] tags, long from, long to) {
        String sql = "delete from " + this.table + " where TAG in (unnest(?)) and TS >= ? and TS < ?";
        try (Connection c = this.dataSource.getConnection();){
            long l;
            block14: {
                PreparedStatement s = c.prepareStatement(sql);
                try {
                    c.setAutoCommit(true);
                    s.setObject(1, tags);
                    s.setTimestamp(2, new Timestamp(from));
                    s.setTimestamp(3, new Timestamp(to));
                    l = s.executeUpdate();
                    if (s == null) break block14;
                }
                catch (Throwable throwable) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                s.close();
            }
            return l;
        }
        catch (SQLException x) {
            throw new IllegalStateException(x);
        }
    }

    void merge(Connection c, List<DataRecord<T>> dataRecords, String sql, Set<DataRecordKey> result) throws SQLException {
        try (PreparedStatement s = c.prepareStatement(sql);){
            for (DataRecord<T> dataRecord : dataRecords) {
                s.setLong(1, dataRecord.getTag());
                s.setTimestamp(2, new Timestamp(dataRecord.getTimestamp()));
                this.setValue(s, 3, dataRecord.getValue());
                s.addBatch();
            }
            int[] updates = s.executeBatch();
            for (int i = 0; i < updates.length; ++i) {
                if (updates[i] <= 0) continue;
                result.add(dataRecords.get(i).getKey());
            }
        }
    }

    public Set<DataRecordKey> merge(List<DataRecord<T>> dataRecords, boolean insertOnly) {
        LinkedHashSet<DataRecordKey> linkedHashSet;
        block12: {
            Connection c = this.dataSource.getConnection();
            try {
                LinkedHashSet<DataRecordKey> result = new LinkedHashSet<DataRecordKey>();
                c.setAutoCommit(false);
                try {
                    if (insertOnly) {
                        String sql = "merge into " + this.table + " using (values(cast(? as varchar(256)), cast(? as timestamp), cast(? as " + this.getSqlTypeName() + "))) as VALS(TAG, TS, VAL) on " + this.table + ".TAG = VALS.TAG and " + this.table + ".TS = VALS.TS when matched then update set " + this.table + ".VAL = VALS.VAL when not matched then insert values VALS.TAG, VALS.TS, VALS.VAL";
                        this.merge(c, dataRecords, sql, result);
                    } else {
                        String sqlu = "merge into " + this.table + " using (values(cast(? as varchar(256)), cast(? as timestamp), cast(? as " + this.getSqlTypeName() + "))) as VALS(TAG, TS, VAL) on " + this.table + ".TAG = VALS.TAG and " + this.table + ".TS = VALS.TS and " + this.table + ".VAL != VALS.VAL when matched then update set " + this.table + ".VAL = VALS.VAL";
                        this.merge(c, dataRecords, sqlu, result);
                        String sqli = "merge into " + this.table + " using (values(cast(? as varchar(256)), cast(? as timestamp), cast(? as " + this.getSqlTypeName() + "))) as VALS(TAG, TS, VAL) on " + this.table + ".TAG = VALS.TAG and " + this.table + ".TS = VALS.TS when not matched then insert values VALS.TAG, VALS.TS, VALS.VAL";
                        this.merge(c, dataRecords, sqli, result);
                    }
                    c.commit();
                }
                catch (Exception x) {
                    c.rollback();
                    throw x;
                }
                linkedHashSet = result;
                if (c == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException x) {
                    throw new IllegalStateException(x);
                }
            }
            c.close();
        }
        return linkedHashSet;
    }
}

