/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.hsqldb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.jdbc.JDBCSessionDataSource;
import org.hsqldb.server.Server;
import org.marid.db.hsqldb.HsqldbProperties;
import org.marid.logging.Log;

public final class HsqldbDatabase
implements Closeable {
    private final Server server;
    private final File directory;
    private final long shutdownTimeout;
    private final Map<String, URL> databaseNameToIndex = new LinkedHashMap<String, URL>();
    private PrintWriter outWriter;
    private PrintWriter errWriter;

    public HsqldbDatabase(HsqldbProperties properties) throws MalformedURLException {
        Log.log((Level)Level.INFO, (String)"{0}", (Object[])new Object[]{properties});
        this.directory = properties.getDirectory();
        this.shutdownTimeout = TimeUnit.SECONDS.toMillis(properties.getShutdownTimeoutSeconds());
        this.server = new Server();
        this.server.setNoSystemExit(true);
        this.server.setRestartOnShutdown(false);
        this.server.setPort(properties.getPort());
        this.server.setSilent(properties.isSilent());
        if (properties.getDatabases() == null) {
            this.setDatabase("NUMERICS", this.getClass().getResource("default.sql"));
        } else {
            for (String database : properties.getDatabases().stringPropertyNames()) {
                String urlText = properties.getDatabases().getProperty(database);
                if (!urlText.contains("://")) {
                    this.setDatabase(database, this.getClass().getClassLoader().getResource(urlText));
                    continue;
                }
                this.setDatabase(database, new URL(urlText));
            }
        }
    }

    private void setDatabase(String name, URL url) {
        int index = this.databaseNameToIndex.size();
        this.server.setDatabaseName(index, name);
        this.server.setDatabasePath(index, new File(this.directory, name).getAbsolutePath());
        this.databaseNameToIndex.put(name, url);
    }

    public void init() throws IOException {
        this.outWriter = new PrintWriter(new File(this.directory, "output.log"));
        this.errWriter = new PrintWriter(new File(this.directory, "errors.log"));
        this.server.start();
        for (Map.Entry<String, URL> e : this.databaseNameToIndex.entrySet()) {
            try {
                this.initDatabase(e.getKey(), e.getValue());
            }
            catch (IOException | SQLException x) {
                Log.log((Level)Level.WARNING, (String)"Unable to init DB {0}", (Throwable)x, (Object[])new Object[]{e.getKey()});
            }
        }
    }

    private void initDatabase(String name, URL url) throws SQLException, IOException {
        block30: {
            try (Connection c = this.dataSource(name).getConnection();){
                boolean tableExists;
                c.setAutoCommit(true);
                try (ResultSet rs = c.getMetaData().getTables(null, null, name, new String[]{"TABLE"});){
                    tableExists = rs.next();
                }
                if (tableExists) {
                    Log.log((Level)Level.INFO, (String)"Table {0} already exists", (Object[])new Object[]{name});
                    return;
                }
                try (Statement s = c.createStatement();){
                    Scanner scanner = new Scanner(url.openStream());
                    block23: while (true) {
                        while (scanner.hasNextLine()) {
                            String sql = scanner.nextLine().trim();
                            if (sql.startsWith("--") || sql.isEmpty()) continue;
                            try {
                                Log.log((Level)Level.INFO, (String)"Executing {0}", (Object[])new Object[]{sql});
                                s.execute(sql);
                                continue block23;
                            }
                            catch (SQLException x) {
                                Log.log((Level)Level.WARNING, (String)"Unable to execute '{0}'", (Throwable)x, (Object[])new Object[]{sql});
                            }
                        }
                        break block30;
                        {
                            continue block23;
                            break;
                        }
                        break;
                    }
                    finally {
                        scanner.close();
                    }
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        try (PrintWriter out = this.outWriter;
             PrintWriter err = this.errWriter;){
            this.server.shutdown();
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < this.shutdownTimeout) {
                if (this.server.getState() == 16) {
                    return;
                }
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
            }
            throw new InterruptedIOException("Server shutdown timeout exceeded");
        }
    }

    public DataSource dataSource(String name) {
        int dbIndex = new ArrayList<String>(this.databaseNameToIndex.keySet()).indexOf(name);
        Database database = DatabaseManager.getDatabase((int)dbIndex);
        return new JDBCSessionDataSource(database, "PUBLIC");
    }

    static {
        System.setProperty("hsqldb.reconfig_logging", "false");
    }
}

