/*-
 * #%L
 * marid-db
 * %%
 * Copyright (C) 2012 - 2019 MARID software development group
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.marid.db.hsqldb;

import java.io.File;
import java.util.Properties;

/**
 * @author Dmitry Ovchinnikov.
 */
public final class HsqldbProperties {

  private File directory = new File("daqDatabase");
  private long shutdownTimeoutSeconds = 60L;
  private Properties databases;
  private int port = 9001;
  private boolean silent = true;

  public File getDirectory() {
    return directory;
  }

  public void setDirectory(File directory) {
    this.directory = directory;
  }

  public long getShutdownTimeoutSeconds() {
    return shutdownTimeoutSeconds;
  }

  public void setShutdownTimeoutSeconds(long shutdownTimeoutSeconds) {
    this.shutdownTimeoutSeconds = shutdownTimeoutSeconds;
  }

  public Properties getDatabases() {
    return databases;
  }

  public void setDatabases(Properties databases) {
    this.databases = databases;
  }

  public int getPort() {
    return port;
  }

  public void setPort(int port) {
    this.port = port;
  }

  public boolean isSilent() {
    return silent;
  }

  public void setSilent(boolean silent) {
    this.silent = silent;
  }
}
