/*
 * Decompiled with CFR 0.152.
 */
package org.marid.db.hsqldb;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.LongStream;
import javax.sql.DataSource;
import org.hsqldb.jdbc.JDBCPool;
import org.jetbrains.annotations.NotNull;
import org.marid.db.dao.DaqReader;
import org.marid.db.data.DataRecord;
import org.marid.misc.SecuritySupplier;

public abstract class HsqldbDaqAbstractReader<T extends Serializable>
implements DaqReader<T> {
    final DataSource dataSource;
    final String table;

    protected HsqldbDaqAbstractReader(DataSource dataSource, String table) {
        this.dataSource = dataSource;
        this.table = table;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long[] tags(long from, long to) {
        String sql = "select distinct TAG from " + this.table + " where TS >= ? and TS < ?";
        try (Connection c = this.dataSource.getConnection();){
            long[] lArray;
            block22: {
                PreparedStatement s = c.prepareStatement(sql);
                try {
                    s.setTimestamp(1, new Timestamp(from));
                    s.setTimestamp(2, new Timestamp(to));
                    LongStream.Builder builder = LongStream.builder();
                    try (ResultSet rs = s.executeQuery();){
                        while (rs.next()) {
                            builder.add(rs.getLong(1));
                        }
                    }
                    lArray = builder.build().toArray();
                    if (s == null) break block22;
                }
                catch (Throwable throwable) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                s.close();
            }
            return lArray;
        }
        catch (SQLException x) {
            throw new IllegalStateException(x);
        }
    }

    /*
     * Exception decompiling
     */
    public long tagCount(long from, long to) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public DataRecord<T> fetchRecord(long tag, long instant) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<DataRecord<T>> fetchRecords(long[] tags, long from, long to) {
        String sql = "select * from " + this.table + " where TAG in (unnest(?)) and TS >= ? and TS < ?";
        try (Connection c = this.dataSource.getConnection();){
            ArrayList<DataRecord<T>> arrayList;
            block22: {
                PreparedStatement s = c.prepareStatement(sql);
                try {
                    ArrayList<DataRecord<T>> result = new ArrayList<DataRecord<T>>();
                    s.setObject(1, LongStream.of(tags).boxed().toArray(Long[]::new));
                    s.setTimestamp(2, new Timestamp(from));
                    s.setTimestamp(3, new Timestamp(to));
                    try (ResultSet rs = s.executeQuery();){
                        while (rs.next()) {
                            long tag = rs.getLong(1);
                            long ts = rs.getTimestamp(2).getTime();
                            T value = this.getValue(rs, 3);
                            result.add(new DataRecord(tag, ts, value));
                        }
                    }
                    arrayList = result;
                    if (s == null) break block22;
                }
                catch (Throwable throwable) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                s.close();
            }
            return arrayList;
        }
        catch (SQLException x) {
            throw new IllegalStateException(x);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<Long, String> hash(long from, long to, boolean includeData, String algorithm) {
        String sql = "select * from " + this.table + " where TS >= ? and TS < ? order by TAG, TS";
        try (Connection c = this.dataSource.getConnection();){
            TreeMap<Long, String> treeMap;
            block22: {
                PreparedStatement s = c.prepareStatement(sql);
                try {
                    TreeMap<Long, MessageDigest> digestMap = new TreeMap<Long, MessageDigest>();
                    s.setTimestamp(1, new Timestamp(from));
                    s.setTimestamp(2, new Timestamp(to));
                    try (ResultSet rs = s.executeQuery();){
                        while (rs.next()) {
                            Long tag = rs.getLong(1);
                            Timestamp ts = rs.getTimestamp(2);
                            MessageDigest digest = digestMap.computeIfAbsent(tag, t -> (MessageDigest)SecuritySupplier.of(() -> MessageDigest.getInstance(algorithm)).get());
                            digest.update(ByteBuffer.allocate(8).putLong(0, ts.getTime()));
                            if (!includeData) continue;
                            digest.update(this.toByteArray(this.getValue(rs, 3)));
                        }
                    }
                    TreeMap<Long, String> result = new TreeMap<Long, String>();
                    digestMap.forEach((k, v) -> result.put((Long)k, Base64.getEncoder().encodeToString(v.digest())));
                    treeMap = result;
                    if (s == null) break block22;
                }
                catch (Throwable throwable) {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                s.close();
            }
            return treeMap;
        }
        catch (SQLException x) {
            throw new IllegalStateException(x);
        }
    }

    /*
     * Exception decompiling
     */
    public long getRecordCount() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void setValue(PreparedStatement var1, int var2, T var3) throws SQLException;

    protected abstract T getValue(ResultSet var1, int var2) throws SQLException;

    protected abstract byte[] toByteArray(@NotNull T var1);

    protected abstract String getSqlTypeName();

    public void close() throws Exception {
        if (this.dataSource instanceof JDBCPool) {
            ((JDBCPool)this.dataSource).close(0);
        }
    }
}

