/*
 * Decompiled with CFR 0.152.
 */
package org.marid.hmi;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import org.marid.hmi.HmiPane;
import org.marid.jfx.FxMaridIcon;
import org.marid.logging.Log;
import org.marid.misc.Casts;
import org.marid.runtime.MaridBaseApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class HmiApplication
extends Application {
    private final GenericXmlApplicationContext context = new MaridBaseApplicationContext();

    public void init() throws Exception {
        MapPropertySource cmdProps = new MapPropertySource("cmd", (Map)Casts.cast((Object)this.getParameters().getNamed()));
        this.context.getBeanFactory().registerSingleton("application", (Object)this);
        this.context.getEnvironment().getPropertySources().addFirst((PropertySource)cmdProps);
    }

    public void start(Stage primaryStage) throws Exception {
        HmiPane pane = new HmiPane();
        this.context.refresh();
        this.context.start();
        primaryStage.setScene(new Scene((Parent)pane, 800.0, 600.0));
        primaryStage.setAlwaysOnTop(true);
        primaryStage.getIcons().addAll((Collection)IntStream.of(16, 24, 32).mapToObj(s -> FxMaridIcon.maridIcon((int)s, (Color)Color.GREEN)).collect(Collectors.toList()));
        primaryStage.setOnCloseRequest(event -> Platform.exit());
        primaryStage.setIconified(true);
        primaryStage.show();
        Map stageMap = this.context.getBeansOfType(Stage.class, true, true);
        pane.addStages(stageMap);
        stageMap.forEach((name, stage) -> {
            if (stage.getIcons().isEmpty()) {
                stage.getIcons().addAll((Collection)primaryStage.getIcons());
            }
        });
    }

    public void stop() throws Exception {
        try {
            this.context.close();
        }
        catch (Exception x) {
            Log.log((Level)Level.SEVERE, (String)"Unable to close context", (Throwable)x, (Object[])new Object[0]);
        }
    }
}

