/*
 * Decompiled with CFR 0.152.
 */
package org.marid.hmi;

import java.util.IdentityHashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.stage.Stage;
import org.marid.jfx.LocalizedStrings;

public class HmiStagesList
extends TableView<Map.Entry<String, Stage>> {
    private final Map<Stage, BooleanProperty> visibleProps = new IdentityHashMap<Stage, BooleanProperty>();

    public HmiStagesList() {
        this.setColumnResizePolicy(CONSTRAINED_RESIZE_POLICY);
        this.setEditable(true);
        TableColumn column = new TableColumn();
        column.textProperty().bind((ObservableValue)LocalizedStrings.ls((String)"Bean", (Object[])new Object[0]));
        column.setCellValueFactory(param -> new SimpleStringProperty((String)((Map.Entry)param.getValue()).getKey()));
        column.setPrefWidth(150.0);
        column.setMaxWidth(300.0);
        this.getColumns().add((Object)column);
        column = new TableColumn();
        column.textProperty().bind((ObservableValue)LocalizedStrings.ls((String)"Title", (Object[])new Object[0]));
        column.setCellValueFactory(param -> ((Stage)((Map.Entry)param.getValue()).getValue()).titleProperty());
        column.setPrefWidth(250.0);
        column.setMaxWidth(550.0);
        this.getColumns().add((Object)column);
        column = new TableColumn();
        column.textProperty().bind((ObservableValue)LocalizedStrings.ls((String)"Visible", (Object[])new Object[0]));
        column.setCellValueFactory(param -> this.visibleProps.computeIfAbsent((Stage)((Map.Entry)param.getValue()).getValue(), stage -> {
            SimpleBooleanProperty property = new SimpleBooleanProperty(stage.isShowing());
            ChangeListener listener = (observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    stage.show();
                } else {
                    stage.hide();
                }
            };
            property.addListener(listener);
            stage.showingProperty().addListener((arg_0, arg_1, arg_2) -> HmiStagesList.lambda$null$3((BooleanProperty)property, listener, arg_0, arg_1, arg_2));
            return property;
        }));
        column.setCellFactory(param -> new CheckBoxTableCell());
        column.setPrefWidth(100.0);
        column.setMaxWidth(150.0);
        this.getColumns().add((Object)column);
    }

    private static /* synthetic */ void lambda$null$3(BooleanProperty property, ChangeListener listener, ObservableValue observable, Boolean oldValue, Boolean newValue) {
        property.removeListener(listener);
        property.setValue(newValue);
        property.addListener(listener);
    }
}

