/*
 * Decompiled with CFR 0.152.
 */
package org.marid.spring.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class AbstractData<T extends AbstractData<T>>
implements Externalizable,
Cloneable {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T clone() {
        Throwable throwable;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            throwable = null;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(this);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException x) {
            throw new IllegalStateException(x);
        }
        try {
            throwable = null;
            try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
                AbstractData abstractData = (AbstractData)ois.readObject();
                return (T)abstractData;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException | ClassNotFoundException x) {
            throw new IllegalStateException(x);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        TreeMap<String, Serializable> map = new TreeMap<String, Serializable>();
        for (Field field : this.getClass().getFields()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            try {
                map.put(field.getName(), this.toSerializable(field.get(this)));
            }
            catch (ReflectiveOperationException x) {
                throw new IllegalStateException(x);
            }
        }
        out.writeObject(map);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        TreeMap map = (TreeMap)in.readObject();
        for (Map.Entry e : map.entrySet()) {
            try {
                Field field = this.getClass().getField(e.getKey().toString());
                if (Property.class.isAssignableFrom(field.getType())) {
                    Method setValue = WritableValue.class.getMethod("setValue", Object.class);
                    setValue.invoke(field.get(this), e.getValue());
                    continue;
                }
                if (ObservableList.class.isAssignableFrom(field.getType())) {
                    Method addAll = List.class.getMethod("addAll", Collection.class);
                    addAll.invoke(field.get(this), e.getValue());
                    continue;
                }
                if (!ObservableMap.class.isAssignableFrom(field.getType())) continue;
                Method putAll = Map.class.getMethod("putAll", Map.class);
                putAll.invoke(field.get(this), e.getValue());
            }
            catch (NoSuchFieldException x) {
                throw new InvalidClassException(x.getMessage());
            }
            catch (ReflectiveOperationException x) {
                throw new IllegalStateException(x);
            }
        }
    }

    private Serializable toSerializable(Object o) {
        if (o == null || o instanceof Serializable) {
            return (Serializable)o;
        }
        if (o instanceof ObservableList) {
            ObservableList list = (ObservableList)o;
            return list.stream().map(this::toSerializable).collect(Collectors.toCollection(ArrayList::new));
        }
        if (o instanceof ObservableMap) {
            ObservableMap m = (ObservableMap)o;
            return m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toSerializable(e.getValue()), (u, v) -> v, LinkedHashMap::new));
        }
        if (o instanceof Property) {
            return this.toSerializable(((Property)o).getValue());
        }
        throw new IllegalArgumentException("Not serializable value " + o);
    }
}

