/*
 * Decompiled with CFR 0.152.
 */
package org.marid.spring.xml;

import java.lang.reflect.Executable;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.marid.spring.xml.BeanArg;
import org.marid.spring.xml.BeanProp;
import org.marid.spring.xml.DCollection;
import org.marid.spring.xml.DElement;
import org.marid.spring.xml.Meta;

@XmlRootElement(name="bean")
@XmlSeeAlso(value={BeanProp.class, DCollection.class, Meta.class})
@XmlAccessorType(value=XmlAccessType.NONE)
public final class BeanData
extends DElement<BeanData> {
    public final StringProperty type = new SimpleStringProperty((Object)this, "class");
    public final StringProperty name = new SimpleStringProperty((Object)this, "name");
    public final StringProperty initMethod = new SimpleStringProperty((Object)this, "init-method");
    public final StringProperty destroyMethod = new SimpleStringProperty((Object)this, "destroy-method");
    public final StringProperty factoryBean = new SimpleStringProperty((Object)this, "factory-bean");
    public final StringProperty factoryMethod = new SimpleStringProperty((Object)this, "factory-method");
    public final StringProperty lazyInit = new SimpleStringProperty((Object)this, "lazy-init", "default");
    public final ObservableList<BeanArg> beanArgs = FXCollections.observableArrayList(BeanArg::observables);
    public final ObservableList<BeanProp> properties = FXCollections.observableArrayList(BeanProp::observables);
    public final ObservableList<String> initTriggers = FXCollections.observableArrayList();
    public final ObservableList<String> destroyTriggers = FXCollections.observableArrayList();
    public final transient ObservableList<Executable> constructors = FXCollections.observableArrayList();

    @XmlAttribute(name="class")
    public String getType() {
        return this.type.isEmpty().get() ? null : (String)this.type.get();
    }

    public void setType(String type) {
        this.type.set((Object)type);
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name.isEmpty().get() ? null : (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    @XmlAttribute(name="init-method")
    public String getInitMethod() {
        return this.initMethod.isEmpty().get() ? null : (String)this.initMethod.get();
    }

    public void setInitMethod(String initMethod) {
        this.initMethod.set((Object)initMethod);
    }

    @XmlAttribute(name="destroy-method")
    public String getDestroyMethod() {
        return this.destroyMethod.isEmpty().get() ? null : (String)this.destroyMethod.get();
    }

    public void setDestroyMethod(String destroyMethod) {
        this.destroyMethod.set((Object)destroyMethod);
    }

    @XmlAttribute(name="factory-bean")
    public String getFactoryBean() {
        return this.factoryBean.isEmpty().get() ? null : (String)this.factoryBean.get();
    }

    public void setFactoryBean(String factoryBean) {
        this.factoryBean.set((Object)factoryBean);
    }

    @XmlAttribute(name="factory-method")
    public String getFactoryMethod() {
        return this.factoryMethod.isEmpty().get() ? null : (String)this.factoryMethod.get();
    }

    public void setFactoryMethod(String factoryMethod) {
        this.factoryMethod.set((Object)factoryMethod);
    }

    @XmlAttribute(name="lazy-init")
    public String getLazyInit() {
        return this.lazyInit.isEqualTo("default").get() ? null : (String)this.lazyInit.get();
    }

    public void setLazyInit(String lazyInit) {
        this.lazyInit.set((Object)(lazyInit == null ? "default" : lazyInit));
    }

    @XmlElement(name="constructor-arg")
    public BeanArg[] getBeanArgs() {
        return (BeanArg[])this.beanArgs.stream().filter(a -> !a.isEmpty()).toArray(BeanArg[]::new);
    }

    public void setBeanArgs(BeanArg[] beanArgs) {
        this.beanArgs.setAll((Object[])beanArgs);
    }

    @XmlElement(name="property")
    public BeanProp[] getBeanProps() {
        return (BeanProp[])this.properties.stream().filter(p -> !p.isEmpty()).toArray(BeanProp[]::new);
    }

    public void setBeanProps(BeanProp[] beanProps) {
        this.properties.setAll((Object[])beanProps);
    }

    @XmlAnyElement(lax=true)
    public Meta[] getMeta() {
        return (Meta[])Stream.concat(IntStream.range(0, this.initTriggers.size()).mapToObj(i -> new Meta("init" + i, (String)this.initTriggers.get(i))), IntStream.range(0, this.destroyTriggers.size()).mapToObj(i -> new Meta("destroy" + i, (String)this.destroyTriggers.get(i)))).toArray(Meta[]::new);
    }

    public void setMeta(Meta[] metas) {
        for (Meta meta : metas) {
            if (meta.key.startsWith("init")) {
                this.initTriggers.add((Object)meta.value);
                continue;
            }
            if (!meta.key.startsWith("destroy")) continue;
            this.destroyTriggers.add((Object)meta.value);
        }
    }

    public boolean isFactoryBean() {
        return this.factoryBean.isNotEmpty().get() || this.factoryMethod.isNotEmpty().get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.type.isEmpty().get() && this.factoryMethod.isEmpty().get() || this.name.isEmpty().get();
    }

    public Optional<BeanProp> property(String name) {
        return this.properties.stream().filter(p -> p.name.isEqualTo(name).get()).findAny();
    }

    public Optional<BeanArg> arg(String name) {
        return this.beanArgs.stream().filter(a -> a.name.isEqualTo(name).get()).findAny();
    }

    @Override
    public Observable[] observables() {
        return new Observable[]{this.type, this.name, this.initMethod, this.destroyMethod, this.factoryBean, this.factoryMethod, this.lazyInit, this.beanArgs, this.properties, this.initTriggers, this.destroyTriggers};
    }

    public String toString() {
        return (String)this.name.get();
    }
}

