/*
 * Decompiled with CFR 0.152.
 */
package org.marid.spring.xml;

import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.marid.spring.xml.AbstractData;
import org.marid.spring.xml.BeanData;

@XmlRootElement(name="beans")
@XmlSeeAlso(value={BeanData.class})
@XmlAccessorType(value=XmlAccessType.NONE)
public final class BeanFile
extends AbstractData<BeanFile> {
    public final ObservableList<BeanData> beans = FXCollections.observableArrayList(BeanData::observables);

    public Stream<BeanData> allBeans() {
        Stream.Builder builder = Stream.builder();
        this.beans.forEach(builder::add);
        return builder.build();
    }

    @XmlElement(name="bean")
    public BeanData[] getBeans() {
        return (BeanData[])this.beans.stream().filter(b -> !b.isEmpty()).toArray(BeanData[]::new);
    }

    public void setBeans(BeanData[] beans) {
        this.beans.addAll((Object[])beans);
    }
}

