/*
 * Decompiled with CFR 0.152.
 */
package org.marid.spring.xml;

import javafx.beans.Observable;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.marid.spring.xml.DArray;
import org.marid.spring.xml.DElement;
import org.marid.spring.xml.DList;
import org.marid.spring.xml.DProps;
import org.marid.spring.xml.DRef;
import org.marid.spring.xml.DValue;

@XmlSeeAlso(value={DList.class, DArray.class, DValue.class, DProps.class, DRef.class})
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class DCollection<T extends DCollection<T>>
extends DElement<T> {
    public final StringProperty valueType = new SimpleStringProperty((Object)this, "value-type");
    public final ObservableList<DElement<?>> elements = FXCollections.observableArrayList(DElement::observables);

    @XmlAttribute(name="value-type")
    public String getValueType() {
        return this.valueType.isEmpty().get() ? null : (String)this.valueType.get();
    }

    public void setValueType(String valueType) {
        this.valueType.set((Object)valueType);
    }

    @XmlAnyElement(lax=true)
    public DElement<?>[] getElements() {
        return (DElement[])this.elements.stream().filter(e -> !e.isEmpty()).toArray(DElement[]::new);
    }

    public void setElements(DElement<?>[] elements) {
        this.elements.addAll((Object[])elements);
    }

    public String toString() {
        String className = this.getClass().getSimpleName().substring(1);
        return className + "(" + this.elements.size() + ")";
    }

    @Override
    public Observable[] observables() {
        return new Observable[]{this.valueType, this.elements};
    }
}

