/*
 * Decompiled with CFR 0.152.
 */
package org.marid.spring.xml;

import java.lang.reflect.Executable;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.marid.jfx.beans.FxList;
import org.marid.jfx.beans.FxObservable;
import org.marid.jfx.beans.FxString;
import org.marid.spring.xml.AbstractData;
import org.marid.spring.xml.BeanArg;
import org.marid.spring.xml.BeanProp;
import org.marid.spring.xml.DCollection;
import org.marid.spring.xml.DElement;
import org.marid.spring.xml.Meta;

@XmlRootElement(name="bean")
@XmlSeeAlso(value={BeanProp.class, DCollection.class, Meta.class})
@XmlAccessorType(value=XmlAccessType.NONE)
public final class BeanData
extends DElement<BeanData> {
    public final FxString type = new FxString(null, "class");
    public final FxString name = new FxString(null, "name");
    public final FxString initMethod = new FxString(null, "init-method");
    public final FxString destroyMethod = new FxString(null, "destroy-method");
    public final FxString factoryBean = new FxString(null, "factory-bean");
    public final FxString factoryMethod = new FxString(null, "factory-method");
    public final FxString lazyInit = new FxString(null, "lazy-init", "default");
    public final FxList<BeanArg> beanArgs = new FxList(BeanArg::observables);
    public final FxList<BeanProp> properties = new FxList(BeanProp::observables);
    public final FxList<String> initTriggers = new FxList();
    public final FxList<String> destroyTriggers = new FxList();
    public final transient FxList<Executable> constructors = new FxList();

    @XmlAttribute(name="class")
    public String getType() {
        return this.type.get() == null || ((String)this.type.get()).isEmpty() ? null : (String)this.type.get();
    }

    public void setType(String type) {
        this.type.set((Object)type);
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name.get() == null || ((String)this.name.get()).isEmpty() ? null : (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    @XmlAttribute(name="init-method")
    public String getInitMethod() {
        return this.initMethod.get() == null || ((String)this.initMethod.get()).isEmpty() ? null : (String)this.initMethod.get();
    }

    public void setInitMethod(String initMethod) {
        this.initMethod.set((Object)initMethod);
    }

    @XmlAttribute(name="destroy-method")
    public String getDestroyMethod() {
        return this.destroyMethod.get() == null || ((String)this.destroyMethod.get()).isEmpty() ? null : (String)this.destroyMethod.get();
    }

    public void setDestroyMethod(String destroyMethod) {
        this.destroyMethod.set((Object)destroyMethod);
    }

    @XmlAttribute(name="factory-bean")
    public String getFactoryBean() {
        return this.factoryBean.get() == null || ((String)this.factoryBean.get()).isEmpty() ? null : (String)this.factoryBean.get();
    }

    public void setFactoryBean(String factoryBean) {
        this.factoryBean.set((Object)factoryBean);
    }

    @XmlAttribute(name="factory-method")
    public String getFactoryMethod() {
        return this.factoryMethod.get() == null || ((String)this.factoryMethod.get()).isEmpty() ? null : (String)this.factoryMethod.get();
    }

    public void setFactoryMethod(String factoryMethod) {
        this.factoryMethod.set((Object)factoryMethod);
    }

    @XmlAttribute(name="lazy-init")
    public String getLazyInit() {
        return "default".equals(this.lazyInit.get()) ? null : (String)this.lazyInit.get();
    }

    public void setLazyInit(String lazyInit) {
        this.lazyInit.set((Object)(lazyInit == null ? "default" : lazyInit));
    }

    @XmlElement(name="constructor-arg")
    public BeanArg[] getBeanArgs() {
        return (BeanArg[])this.beanArgs.stream().filter(a -> !a.isEmpty()).toArray(BeanArg[]::new);
    }

    public void setBeanArgs(BeanArg[] beanArgs) {
        this.beanArgs.setAll((Object[])beanArgs);
    }

    @XmlElement(name="property")
    public BeanProp[] getBeanProps() {
        return (BeanProp[])this.properties.stream().filter(p -> !p.isEmpty()).toArray(BeanProp[]::new);
    }

    public void setBeanProps(BeanProp[] beanProps) {
        this.properties.setAll((Object[])beanProps);
    }

    @XmlAnyElement(lax=true)
    public Meta[] getMeta() {
        return (Meta[])Stream.concat(IntStream.range(0, this.initTriggers.size()).mapToObj(i -> new Meta("init" + i, (String)this.initTriggers.get(i))), IntStream.range(0, this.destroyTriggers.size()).mapToObj(i -> new Meta("destroy" + i, (String)this.destroyTriggers.get(i)))).toArray(Meta[]::new);
    }

    public void setMeta(Meta[] metas) {
        for (Meta meta : metas) {
            if (meta.key.startsWith("init")) {
                this.initTriggers.add((Object)meta.value);
                continue;
            }
            if (!meta.key.startsWith("destroy")) continue;
            this.destroyTriggers.add((Object)meta.value);
        }
    }

    public boolean isFactoryBean() {
        return this.factoryBean.get() != null && !((String)this.factoryBean.get()).isEmpty() || this.factoryMethod.get() != null && !((String)this.factoryMethod.get()).isEmpty();
    }

    @Override
    public boolean isEmpty() {
        if (this.name.get() == null || ((String)this.name.get()).isEmpty()) {
            return true;
        }
        return !(this.type.get() != null && !((String)this.type.get()).isEmpty() || this.factoryMethod.get() != null && !((String)this.factoryMethod.get()).isEmpty());
    }

    public Optional<BeanProp> property(String name) {
        return this.properties.stream().filter(p -> name.equals(p.getName())).findAny();
    }

    public Optional<BeanArg> arg(String name) {
        return this.beanArgs.stream().filter(a -> name.equals(a.getName())).findAny();
    }

    @Override
    public FxObservable[] observables() {
        return new FxObservable[]{this.type, this.name, this.initMethod, this.destroyMethod, this.factoryBean, this.factoryMethod, this.lazyInit, this.beanArgs, this.properties, this.initTriggers, this.destroyTriggers, this.constructors};
    }

    @Override
    public Stream<FxObservable> observableStream() {
        return Stream.of(this.observables());
    }

    @Override
    public Stream<? extends AbstractData<?>> stream() {
        return Stream.concat(this.beanArgs.stream(), this.properties.stream());
    }

    public String toString() {
        return (String)this.name.get();
    }
}

