/*
 * Decompiled with CFR 0.152.
 */
package org.marid.spring.xml;

import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.marid.jfx.beans.FxList;
import org.marid.jfx.beans.FxObservable;
import org.marid.spring.xml.AbstractData;
import org.marid.spring.xml.BeanData;

@XmlRootElement(name="beans")
@XmlSeeAlso(value={BeanData.class})
@XmlAccessorType(value=XmlAccessType.NONE)
public final class BeanFile
extends AbstractData<BeanFile> {
    public final FxList<String> path = new FxList();
    public final FxList<BeanData> beans = new FxList(BeanData::observables);

    public Stream<BeanData> allBeans() {
        Stream.Builder builder = Stream.builder();
        this.beans.forEach(builder::add);
        return builder.build();
    }

    @XmlElement(name="bean")
    public BeanData[] getBeans() {
        return (BeanData[])this.beans.stream().filter(b -> !b.isEmpty()).toArray(BeanData[]::new);
    }

    public void setBeans(BeanData[] beans) {
        this.beans.addAll((Object[])beans);
    }

    public Path path(Path base) {
        return this.path.stream().reduce(base, Path::resolve, (a1, a2) -> a2);
    }

    public String getFilePath() {
        return this.path.stream().collect(Collectors.joining("/"));
    }

    public static Comparator<BeanFile> asc() {
        return (f1, f2) -> {
            int min = Math.min(f1.path.size(), f2.path.size());
            for (int i = 0; i < min; ++i) {
                String p2;
                String p1 = (String)f1.path.get(i);
                int c = p1.compareTo(p2 = (String)f2.path.get(i));
                if (c == 0) continue;
                return c;
            }
            return Integer.compare(f1.path.size(), f2.path.size());
        };
    }

    public static BeanFile beanFile(Path basePath, Path path) {
        BeanFile file = new BeanFile();
        for (Path p : basePath.relativize(path)) {
            file.path.add((Object)p.toString());
        }
        return file;
    }

    @Override
    public FxObservable[] observables() {
        return new FxObservable[]{this.path, this.beans};
    }

    @Override
    public Stream<FxObservable> observableStream() {
        return Stream.of(this.observables());
    }

    @Override
    public Stream<? extends AbstractData<?>> stream() {
        return this.beans.stream();
    }

    public String toString() {
        return String.format("BeanFile(%s,%d)", this.getFilePath(), this.beans.size());
    }
}

