/*
 * Decompiled with CFR 0.152.
 */
package org.marid.ide.common;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.marid.ide.common.LocalRepositoryServerCondition;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Conditional(value={LocalRepositoryServerCondition.class})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/marid/ide/common/LocalRepositoryServer;", "Ljava/lang/AutoCloseable;", "()V", "address", "Ljava/net/InetSocketAddress;", "getAddress", "()Ljava/net/InetSocketAddress;", "executor", "Ljava/util/concurrent/ForkJoinPool;", "m2RepoDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getM2RepoDir", "()Ljava/nio/file/Path;", "port", "", "getPort", "()I", "server", "Lcom/sun/net/httpserver/HttpServer;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "close", "", "start", "marid-ide-fx"})
public final class LocalRepositoryServer
implements AutoCloseable {
    private final HttpServer server = HttpServer.create(new InetSocketAddress(0), 10);
    private final ForkJoinPool executor = new ForkJoinPool(8);
    private final Path m2RepoDir = Path.of(System.getProperty("user.home"), ".m2", "repository");
    @NotNull
    private final InetSocketAddress address;
    @NotNull
    private final URL url;

    public final Path getM2RepoDir() {
        return this.m2RepoDir;
    }

    public final int getPort() {
        HttpServer httpServer = this.server;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpServer, (String)"server");
        InetSocketAddress inetSocketAddress = httpServer.getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetSocketAddress, (String)"server.address");
        return inetSocketAddress.getPort();
    }

    @NotNull
    public final InetSocketAddress getAddress() {
        return this.address;
    }

    @NotNull
    public final URL getUrl() {
        return this.url;
    }

    @PostConstruct
    public final void start() {
        this.server.start();
    }

    @Override
    public void close() {
        this.server.stop(0);
        this.executor.shutdown();
        if (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
            throw (Throwable)new CancellationException();
        }
    }

    public LocalRepositoryServer() {
        HttpServer httpServer = this.server;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpServer, (String)"server");
        httpServer.setExecutor(this.executor);
        this.server.createContext("/", new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public final void handle(HttpExchange e) {
                block16: {
                    try {
                        void $this$fold$iv;
                        boolean bl;
                        HttpExchange httpExchange = e;
                        Intrinsics.checkExpressionValueIsNotNull((Object)httpExchange, (String)"e");
                        URI uRI = httpExchange.getRequestURI();
                        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"e.requestURI");
                        String string = uRI.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.requestURI.path");
                        String string2 = string;
                        int n = 1;
                        int n2 = 0;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        String path = string4;
                        if (StringsKt.endsWith$default((String)path, (String)"/maven-metadata.xml", (boolean)false, (int)2, null)) {
                            int index = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
                            String string5 = path;
                            n2 = 0;
                            StringBuilder stringBuilder = new StringBuilder();
                            bl = false;
                            String string6 = string5;
                            if (string6 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string7 = string6.substring(n2, index);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            String string8 = string7;
                            path = stringBuilder.append(string8).append("/maven-metadata-local.xml").toString();
                        }
                        Iterable iterable = StringsKt.split$default((CharSequence)path, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
                        Path initial$iv = this.getM2RepoDir();
                        boolean $i$f$fold = false;
                        Path accumulator$iv = initial$iv;
                        for (Object element$iv : $this$fold$iv) {
                            void p2;
                            String string9 = (String)element$iv;
                            Path p1 = accumulator$iv;
                            boolean bl2 = false;
                            accumulator$iv = p1.resolve((String)p2);
                        }
                        Path file = accumulator$iv;
                        if (Files.isRegularFile(file, new LinkOption[0])) {
                            String string10;
                            Path path2 = file;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                            String ext = StringUtils.getFilenameExtension((String)((Object)path2.getFileName()).toString());
                            if (Intrinsics.areEqual((Object)ext, (Object)"pom") || Intrinsics.areEqual((Object)ext, (Object)"xml")) {
                                string10 = "text/xml";
                            } else if (Intrinsics.areEqual((Object)ext, (Object)"jar")) {
                                string10 = "application/java-archive";
                            } else {
                                throw (Throwable)new IllegalStateException("Unknown extension: " + ext);
                            }
                            String contentType = string10;
                            e.getResponseHeaders().add("Content-Type", contentType);
                            e.sendResponseHeaders(200, Files.size(file));
                            Closeable closeable = e.getResponseBody();
                            bl = false;
                            Throwable throwable = null;
                            try {
                                OutputStream it = (OutputStream)closeable;
                                boolean bl3 = false;
                                long l = Files.copy(file, it);
                                break block16;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        e.sendResponseHeaders(404, 0L);
                    }
                    catch (Throwable x) {
                        e.sendResponseHeaders(500, -1L);
                        x.printStackTrace();
                    }
                }
            }
        });
        this.address = new InetSocketAddress(InetAddress.getLocalHost(), this.getPort());
        this.url = new URL("http", "localhost", this.getPort(), "/");
    }
}

