/*
 * Decompiled with CFR 0.152.
 */
package org.marid.ide.main;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Service;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.util.Callback;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.marid.fx.extensions.LogExtensionsKt;
import org.marid.fx.extensions.ObservableExtensionsKt;
import org.marid.fx.i18n.I18nExtensionsKt;
import org.marid.ide.main.IdeServices;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0010J\u0014\u0010!\u001a\u00020\"2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0012\u0010#\u001a\u00020\t2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030$J\u0012\u0010%\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001f\u0010\u000e\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fj\u0002`\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0014\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fj\u0002`\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u001c\u0010\u0016\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fj\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/marid/ide/main/IdeServices;", "", "()V", "lastMessage", "Ljavafx/beans/property/SimpleStringProperty;", "getLastMessage", "()Ljavafx/beans/property/SimpleStringProperty;", "messageHandler", "Ljavafx/beans/value/ChangeListener;", "", "progress", "Ljavafx/beans/binding/DoubleBinding;", "getProgress", "()Ljavafx/beans/binding/DoubleBinding;", "runningServices", "Ljavafx/collections/ObservableList;", "Ljavafx/concurrent/Service;", "Lorg/marid/ide/main/ServiceList;", "getRunningServices", "()Ljavafx/collections/ObservableList;", "services", "getServices", "servicesList", "servicesText", "Ljavafx/beans/binding/StringExpression;", "getServicesText", "()Ljavafx/beans/binding/StringExpression;", "stateEventHandler", "Ljavafx/event/EventHandler;", "Ljavafx/concurrent/WorkerStateEvent;", "add", "", "service", "calcProgress", "", "id", "Ljavafx/concurrent/Worker;", "remove", "marid-ide-fx"})
public final class IdeServices {
    private final ObservableList<Service<?>> servicesList;
    @NotNull
    private final StringExpression servicesText;
    @NotNull
    private final SimpleStringProperty lastMessage;
    @NotNull
    private final DoubleBinding progress;
    private final EventHandler<WorkerStateEvent> stateEventHandler;
    private final ChangeListener<String> messageHandler;

    @NotNull
    public final ObservableList<Service<?>> getServices() {
        return ObservableExtensionsKt.getUnmodified(this.servicesList);
    }

    @NotNull
    public final ObservableList<Service<?>> getRunningServices() {
        FilteredList filteredList = this.servicesList.filtered((Predicate)runningServices.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)filteredList, (String)"servicesList.filtered { it.isRunning }");
        return ObservableExtensionsKt.getUnmodified((ObservableList)((ObservableList)filteredList));
    }

    @NotNull
    public final StringExpression getServicesText() {
        return this.servicesText;
    }

    @NotNull
    public final SimpleStringProperty getLastMessage() {
        return this.lastMessage;
    }

    @NotNull
    public final DoubleBinding getProgress() {
        return this.progress;
    }

    @NotNull
    public final String id(@NotNull Worker<?> service) {
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        String string = Base64.getMimeEncoder().withoutPadding().encodeToString(BigInteger.valueOf(System.identityHashCode(service)).toByteArray());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.getMimeEncoder().\u2026))\n    .toByteArray()\n  )");
        return string;
    }

    public final boolean add(@NotNull Service<?> service) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        if (service.getState() == Worker.State.READY) {
            this.servicesList.add(service);
            service.addEventFilter(WorkerStateEvent.ANY, this.stateEventHandler);
            service.messageProperty().addListener(this.messageHandler);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean remove(@NotNull Service<?> service) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(service, (String)"service");
        if (service.isRunning()) {
            EventHandler<WorkerStateEvent> eh2 = new EventHandler<WorkerStateEvent>(this, service){
                final /* synthetic */ IdeServices this$0;
                final /* synthetic */ Service $service;

                public void handle(@Nullable WorkerStateEvent event) {
                    IdeServices.access$getServicesList$p(this.this$0).remove((Object)this.$service);
                    this.$service.messageProperty().removeListener(IdeServices.access$getMessageHandler$p(this.this$0));
                    this.$service.removeEventHandler(WorkerStateEvent.ANY, IdeServices.access$getStateEventHandler$p(this.this$0));
                    this.$service.removeEventHandler(WorkerStateEvent.WORKER_STATE_CANCELLED, (EventHandler)this);
                    this.$service.removeEventHandler(WorkerStateEvent.WORKER_STATE_FAILED, (EventHandler)this);
                    this.$service.removeEventHandler(WorkerStateEvent.WORKER_STATE_SUCCEEDED, (EventHandler)this);
                }
                {
                    this.this$0 = $outer;
                    this.$service = $captured_local_variable$1;
                }
            };
            service.addEventHandler(WorkerStateEvent.WORKER_STATE_CANCELLED, (EventHandler)eh2);
            service.addEventHandler(WorkerStateEvent.WORKER_STATE_FAILED, (EventHandler)eh2);
            service.addEventHandler(WorkerStateEvent.WORKER_STATE_SUCCEEDED, (EventHandler)eh2);
            service.cancel();
            Thread.yield();
            bl = !service.isRunning();
        } else {
            bl = this.servicesList.remove(service);
        }
        return bl;
    }

    private final double calcProgress(Service<?> service) {
        double total = service.getTotalWork();
        double work = service.getWorkDone();
        double progress2 = service.getProgress();
        return work != -1.0 && total >= 0.0 ? work / total : (progress2 != -1.0 ? progress2 : -1.0);
    }

    public IdeServices() {
        ObservableList observableList = FXCollections.observableArrayList((Callback)servicesList.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"observableArrayList { it.observables }");
        this.servicesList = observableList;
        this.servicesText = ObservableExtensionsKt.bindFormat((String)"[%d / %d]", (Object[])new Object[]{ObservableExtensionsKt.getBindSize(this.getRunningServices()), ObservableExtensionsKt.getBindSize(this.getServices())});
        this.lastMessage = new SimpleStringProperty((Object)this, "lastMessage", "Marid");
        DoubleBinding doubleBinding = Bindings.createDoubleBinding((Callable)new Callable<Double>(this){
            final /* synthetic */ IdeServices this$0;

            /*
             * WARNING - void declaration
             */
            public final Double call() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)this.this$0.getRunningServices();
                IdeServices ideServices = this.this$0;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    Service service = (Service)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Double d = IdeServices.access$calcProgress(ideServices, (Service)p1);
                    collection.add(d);
                }
                iterable = (List)destination$iv$iv;
                boolean bl = false;
                boolean bl2 = false;
                Iterable $this$run = iterable;
                boolean bl3 = false;
                return $this$run.contains(-1.0) ? -1.0 : CollectionsKt.averageOfDouble((Iterable)$this$run);
            }
            {
                this.this$0 = ideServices;
            }
        }, (Observable[])new Observable[]{(Observable)this.getRunningServices()});
        Intrinsics.checkExpressionValueIsNotNull((Object)doubleBinding, (String)"Bindings.createDoubleBin\u2026  }\n  }, runningServices)");
        this.progress = doubleBinding;
        this.stateEventHandler = (EventHandler)new EventHandler<WorkerStateEvent>(this){
            final /* synthetic */ IdeServices this$0;

            public final void handle(WorkerStateEvent it) {
                WorkerStateEvent workerStateEvent = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)workerStateEvent, (String)"it");
                Level level = Intrinsics.areEqual((Object)workerStateEvent.getEventType(), (Object)WorkerStateEvent.WORKER_STATE_FAILED) ? Level.SEVERE : Level.INFO;
                Worker worker = it.getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)worker, (String)"it.source");
                String id = this.this$0.id(worker);
                IdeServices $this$logger$iv = this.this$0;
                boolean $i$f$getLogger = false;
                Logger logger = Logger.getLogger($this$logger$iv.getClass().getName());
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(javaClass.name)");
                Level level2 = level;
                Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"level");
                Worker worker2 = it.getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)worker2, (String)"it.source");
                LogExtensionsKt.LOG((Logger)logger, (Level)level2, (String)"{0}: {1}", (Throwable)worker2.getException(), (Object[])new Object[]{id, it.getEventType().getName()});
                SimpleStringProperty simpleStringProperty = this.this$0.getLastMessage();
                StringBuilder stringBuilder = new StringBuilder().append(id).append(": ");
                String string = it.getEventType().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.eventType.name");
                simpleStringProperty.set(stringBuilder.append(I18nExtensionsKt.i18n((String)string, (Object[])new Object[0])).toString());
            }
            {
                this.this$0 = ideServices;
            }
        };
        this.messageHandler = (ChangeListener)new ChangeListener<String>(this){
            final /* synthetic */ IdeServices this$0;

            public final void changed(ObservableValue<? extends String> $noName_0, String $noName_1, String n) {
                this.this$0.getLastMessage().set(n);
            }
            {
                this.this$0 = ideServices;
            }
        };
    }

    public static final /* synthetic */ ObservableList access$getServicesList$p(IdeServices $this) {
        return $this.servicesList;
    }

    public static final /* synthetic */ ChangeListener access$getMessageHandler$p(IdeServices $this) {
        return $this.messageHandler;
    }

    public static final /* synthetic */ EventHandler access$getStateEventHandler$p(IdeServices $this) {
        return $this.stateEventHandler;
    }

    public static final /* synthetic */ double access$calcProgress(IdeServices $this, Service service) {
        return $this.calcProgress(service);
    }
}

