/*
 * Decompiled with CFR 0.152.
 */
package org.marid.ide.project;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.marid.fx.extensions.LogExtensionsKt;
import org.marid.fx.extensions.OtherExtensionsKt;
import org.marid.fx.i18n.I18nExtensionsKt;
import org.marid.ide.project.Projects;
import org.marid.ide.project.model.FxDependencies;
import org.marid.ide.project.model.FxRepositories;
import org.marid.ide.project.model.FxRepository;
import org.marid.ide.project.model.FxWinery;
import org.marid.io.Xmls;
import org.springframework.util.FileSystemUtils;
import org.w3c.dom.Element;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001VB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010G\u001a\u00020HJ\u0013\u0010I\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020HH\u0002J\u0006\u0010O\u001a\u00020HJ%\u0010P\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002HQ0S\u00a2\u0006\u0002\u0010TJ%\u0010U\u001a\u0002HQ\"\u0004\b\u0000\u0010Q2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002HQ0S\u00a2\u0006\u0002\u0010TR\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0019\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0019\u0010\u0017\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0019\u0010\u0019\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010%\u001a\n \n*\u0004\u0018\u00010&0&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0019\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*\u00a2\u0006\n\n\u0002\u0010.\u001a\u0004\b,\u0010-R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0019\u0010;\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\fR\u0019\u0010=\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\fR\u0019\u0010?\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\fR\u0011\u0010A\u001a\u00020B\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u0019\u0010E\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\f\u00a8\u0006W"}, d2={"Lorg/marid/ide/project/Project;", "", "projects", "Lorg/marid/ide/project/Projects;", "(Lorg/marid/ide/project/Projects;)V", "id", "", "(Lorg/marid/ide/project/Projects;Ljava/lang/String;)V", "cacheDepsDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getCacheDepsDirectory", "()Ljava/nio/file/Path;", "cacheDirectory", "getCacheDirectory", "classesDirectory", "getClassesDirectory", "dependencies", "Lorg/marid/ide/project/model/FxDependencies;", "getDependencies", "()Lorg/marid/ide/project/model/FxDependencies;", "dependenciesFile", "getDependenciesFile", "depsDirectory", "getDepsDirectory", "directory", "getDirectory", "getId", "()Ljava/lang/String;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "locked", "Ljavafx/beans/property/ReadOnlyBooleanProperty;", "getLocked", "()Ljavafx/beans/property/ReadOnlyBooleanProperty;", "lockedProperty", "Ljavafx/beans/property/ReadOnlyBooleanWrapper;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "observables", "", "Ljavafx/beans/Observable;", "getObservables", "()[Ljavafx/beans/Observable;", "[Ljavafx/beans/Observable;", "progress", "Ljavafx/beans/property/ReadOnlyDoubleProperty;", "getProgress", "()Ljavafx/beans/property/ReadOnlyDoubleProperty;", "progressProperty", "Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "getProjects", "()Lorg/marid/ide/project/Projects;", "repositories", "Lorg/marid/ide/project/model/FxRepositories;", "getRepositories", "()Lorg/marid/ide/project/model/FxRepositories;", "repositoriesFile", "getRepositoriesFile", "resourcesDirectory", "getResourcesDirectory", "runtimeDirectory", "getRuntimeDirectory", "winery", "Lorg/marid/ide/project/model/FxWinery;", "getWinery", "()Lorg/marid/ide/project/model/FxWinery;", "wineryFile", "getWineryFile", "delete", "", "equals", "", "other", "hashCode", "", "load", "save", "withRead", "R", "callback", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withWrite", "Friend", "marid-ide-fx"})
public final class Project {
    @NotNull
    private final FxWinery winery;
    @NotNull
    private final FxRepositories repositories;
    @NotNull
    private final FxDependencies dependencies;
    @NotNull
    private final Observable[] observables;
    private final Path directory;
    private final Path wineryFile;
    private final Path repositoriesFile;
    private final Path dependenciesFile;
    private final Path resourcesDirectory;
    private final Path classesDirectory;
    private final Path depsDirectory;
    private final Path runtimeDirectory;
    private final Path cacheDirectory;
    private final Path cacheDepsDirectory;
    private final Logger logger;
    private final ReadOnlyBooleanWrapper lockedProperty;
    private final ReadOnlyDoubleWrapper progressProperty;
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Projects projects;
    @NotNull
    private final String id;

    @NotNull
    public final FxWinery getWinery() {
        return this.winery;
    }

    @NotNull
    public final FxRepositories getRepositories() {
        return this.repositories;
    }

    @NotNull
    public final FxDependencies getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public final Observable[] getObservables() {
        return this.observables;
    }

    public final Path getDirectory() {
        return this.directory;
    }

    public final Path getWineryFile() {
        return this.wineryFile;
    }

    public final Path getRepositoriesFile() {
        return this.repositoriesFile;
    }

    public final Path getDependenciesFile() {
        return this.dependenciesFile;
    }

    public final Path getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    public final Path getClassesDirectory() {
        return this.classesDirectory;
    }

    public final Path getDepsDirectory() {
        return this.depsDirectory;
    }

    public final Path getRuntimeDirectory() {
        return this.runtimeDirectory;
    }

    public final Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    public final Path getCacheDepsDirectory() {
        return this.cacheDepsDirectory;
    }

    public final Logger getLogger() {
        return this.logger;
    }

    private final void load() {
        if (Files.isRegularFile(this.wineryFile, new LinkOption[0])) {
            Xmls.read((Path)this.wineryFile, (Function)new Function<Element, Unit>(this){
                final /* synthetic */ Project this$0;

                public final void apply(Element it) {
                    this.this$0.getWinery().readFrom(it);
                }
                {
                    this.this$0 = project;
                }
            });
        }
        if (Files.isRegularFile(this.repositoriesFile, new LinkOption[0])) {
            Path path = this.repositoriesFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"repositoriesFile");
            this.repositories.load(path);
        }
        if (Files.isRegularFile(this.dependenciesFile, new LinkOption[0])) {
            Path path = this.dependenciesFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dependenciesFile");
            this.dependencies.load(path);
        }
        if (this.dependencies.getItems().isEmpty()) {
            this.dependencies.loadDefault();
        }
    }

    public final void save() {
        Xmls.writeFormatted((String)"winery", (Consumer)new Consumer<Element>(this){
            final /* synthetic */ Project this$0;

            public final void accept(Element it) {
                this.this$0.getWinery().writeTo(it);
            }
            {
                this.this$0 = project;
            }
        }, (Path)this.wineryFile);
        Path path = this.repositoriesFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"repositoriesFile");
        this.repositories.save(path);
        Path path2 = this.dependenciesFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dependenciesFile");
        this.dependencies.save(path2);
    }

    public final void delete() {
        Collection collection = (Collection)Projects.Companion.getWritableItems(this);
        Project project = this;
        boolean bl = false;
        collection.remove(project);
        if (FileSystemUtils.deleteRecursively((Path)this.directory)) {
            Logger logger = this.logger;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
            LogExtensionsKt.INFO((Logger)logger, (String)"Project {0} deleted", (Object[])new Object[]{this.id});
        } else {
            Logger logger = this.logger;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
            LogExtensionsKt.WARN((Logger)logger, (String)"Project {0} does not exist", (Object[])new Object[]{this.id});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withRead(@NotNull Function1<? super Project, ? extends R> callback) {
        Object object;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            object = callback.invoke((Object)this);
        }
        finally {
            readLock.unlock();
        }
        return (R)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withWrite(@NotNull Function1<? super Project, ? extends R> callback) {
        Object object;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        OtherExtensionsKt.runFx((Object)this, (Function1)((Function1)new Function1<Project, Unit>(this){
            final /* synthetic */ Project this$0;

            public final void invoke(@NotNull Project it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Project.access$getLockedProperty$p(this.this$0).set(true);
            }
            {
                this.this$0 = project;
                super(1);
            }
        }));
        try {
            Object object2;
            int n;
            int n2;
            object = this.lock;
            boolean bl = false;
            ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
            int n3 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
            boolean bl2 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
            writeLock.lock();
            try {
                boolean bl3 = false;
                object2 = callback.invoke((Object)this);
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl4 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
            object = object2;
        }
        catch (Throwable throwable) {
            OtherExtensionsKt.runFx((Object)this, (Function1)((Function1)new Function1<Project, Unit>(this){
                final /* synthetic */ Project this$0;

                public final void invoke(@NotNull Project it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Project.access$getLockedProperty$p(this.this$0).set(false);
                }
                {
                    this.this$0 = project;
                    super(1);
                }
            }));
            throw throwable;
        }
        OtherExtensionsKt.runFx((Object)this, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */));
        return (R)object;
    }

    @NotNull
    public final ReadOnlyDoubleProperty getProgress() {
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.progressProperty.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyDoubleProperty, (String)"progressProperty.readOnlyProperty");
        return readOnlyDoubleProperty;
    }

    @NotNull
    public final ReadOnlyBooleanProperty getLocked() {
        ReadOnlyBooleanProperty readOnlyBooleanProperty = this.lockedProperty.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyBooleanProperty, (String)"lockedProperty.readOnlyProperty");
        return readOnlyBooleanProperty;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof Project && Intrinsics.areEqual((Object)((Project)other).id, (Object)this.id);
    }

    @NotNull
    public final Projects getProjects() {
        return this.projects;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public Project(@NotNull Projects projects, @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)projects, (String)"projects");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.projects = projects;
        this.id = id;
        this.winery = new FxWinery();
        this.repositories = new FxRepositories();
        this.dependencies = new FxDependencies();
        this.observables = (Observable[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])this.winery.getObservables(), (Object[])this.repositories.getObservables()), (Object[])this.dependencies.getObservables());
        this.directory = Projects.Companion.getDirectories(this).getProjectsHome().resolve(this.id);
        this.wineryFile = this.directory.resolve("winery.xml");
        this.repositoriesFile = this.directory.resolve("repositories.xml");
        this.dependenciesFile = this.directory.resolve("dependencies.xml");
        this.resourcesDirectory = this.directory.resolve("resources");
        this.classesDirectory = this.directory.resolve("classes");
        this.depsDirectory = this.directory.resolve("deps");
        this.runtimeDirectory = this.directory.resolve("runtime");
        this.cacheDirectory = this.directory.resolve("cache");
        this.cacheDepsDirectory = this.cacheDirectory.resolve("deps");
        this.logger = Logger.getLogger(this.id);
        this.lockedProperty = new ReadOnlyBooleanWrapper((Object)this, "locked");
        this.progressProperty = new ReadOnlyDoubleWrapper((Object)this, "progress", 0.0);
        this.lock = new ReentrantReadWriteLock();
        boolean existing = Files.isDirectory(this.directory, new LinkOption[0]);
        if (!existing) {
            this.winery.getName().set(I18nExtensionsKt.localized((String)"New project %d", (Object[])new Object[]{this.projects.getItems().size() + 1}).get());
        }
        Files.createDirectories(this.resourcesDirectory, new FileAttribute[0]);
        Files.createDirectories(this.classesDirectory, new FileAttribute[0]);
        Files.createDirectories(this.depsDirectory, new FileAttribute[0]);
        Files.createDirectories(this.runtimeDirectory, new FileAttribute[0]);
        Files.createDirectories(this.cacheDepsDirectory, new FileAttribute[0]);
        this.load();
        FxRepository central = new FxRepository("central", "https://repo1.maven.org/maven2/");
        if (!this.repositories.getItems().contains((Object)central)) {
            Collection collection = (Collection)this.repositories.getItems();
            boolean bl = false;
            collection.add(central);
        }
        if (!existing) {
            this.save();
        }
    }

    public Project(@NotNull Projects projects) {
        Intrinsics.checkParameterIsNotNull((Object)projects, (String)"projects");
        long l = System.currentTimeMillis();
        int n = 36;
        Projects projects2 = projects;
        Project project = this;
        boolean bl = false;
        String string = Long.toString(l, CharsKt.checkRadix((int)n));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Long.toString(this, checkRadix(radix))");
        String string2 = string;
        project(projects2, string2);
    }

    public static final /* synthetic */ ReadOnlyBooleanWrapper access$getLockedProperty$p(Project $this) {
        return $this.lockedProperty;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/marid/ide/project/Project$Friend;", "", "(Lorg/marid/ide/project/Project;)V", "progressWrapper", "Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "getProgressWrapper", "()Ljavafx/beans/property/ReadOnlyDoubleWrapper;", "marid-ide-fx"})
    public final class Friend {
        @NotNull
        public final ReadOnlyDoubleWrapper getProgressWrapper() {
            return Project.this.progressProperty;
        }
    }
}

