/*
 * Decompiled with CFR 0.152.
 */
package org.marid.maven;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.maven.Maven;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.marid.maven.ProjectBuilder;
import org.marid.maven.ProjectMavenTransferListener;
import org.marid.maven.ProjectPlexusLogger;

public class MavenProjectBuilder
implements ProjectBuilder {
    private final Path projectPath;
    private final Consumer<LogRecord> logRecordConsumer;
    private final Map<String, ProjectPlexusLogger> loggerMap = new ConcurrentHashMap<String, ProjectPlexusLogger>();
    private final List<String> goals = new ArrayList<String>();
    private final List<String> profiles = new ArrayList<String>();

    public MavenProjectBuilder(Path projectPath, Consumer<LogRecord> logRecordConsumer) {
        this.projectPath = projectPath;
        this.logRecordConsumer = logRecordConsumer;
    }

    private ProjectPlexusLogger logger(String name) {
        return this.loggerMap.computeIfAbsent(name, k -> new ProjectPlexusLogger((String)k, this.logRecordConsumer));
    }

    public MavenProjectBuilder goals(String ... goals) {
        Collections.addAll(this.goals, goals);
        return this;
    }

    public MavenProjectBuilder profiles(String ... ids) {
        Collections.addAll(this.profiles, ids);
        return this;
    }

    private PlexusContainer buildPlexusContainer() throws Exception {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        ClassRealm classRealm = classWorld.getClassRealm("plexus.core");
        CoreExtensionEntry extensionEntry = CoreExtensionEntry.discoverFrom((ClassRealm)classRealm);
        Module bindModule = binder -> {
            binder.bind(RepositoryConnectorFactory.class).to(BasicRepositoryConnectorFactory.class);
            binder.bind(TransporterFactory.class).to(HttpTransporterFactory.class);
            binder.bind(TransporterFactory.class).to(WagonTransporterFactory.class);
            binder.bind(TransporterFactory.class).to(FileTransporterFactory.class);
            binder.bind(CoreExports.class).toInstance((Object)new CoreExports(classRealm, extensionEntry.getExportedArtifacts(), extensionEntry.getExportedPackages()));
        };
        DefaultPlexusContainer container = new DefaultPlexusContainer(new DefaultContainerConfiguration().setClassWorld(classWorld).setRealm(classRealm).setClassPathScanning("index").setAutoWiring(true).setName("maven"), new Module[]{bindModule});
        container.setLoggerManager((LoggerManager)new BaseLoggerManager(){

            protected Logger createLogger(String name) {
                return MavenProjectBuilder.this.logger(name);
            }
        });
        return container;
    }

    private MavenExecutionRequest mavenExecutionRequest(PlexusContainer plexusContainer) throws Exception {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        MavenExecutionRequestPopulator populator = (MavenExecutionRequestPopulator)plexusContainer.lookup(MavenExecutionRequestPopulator.class);
        populator.populateDefaults((MavenExecutionRequest)request);
        request.setMultiModuleProjectDirectory(this.projectPath.toFile());
        return request.setOffline(false).setGoals(this.goals).setSystemProperties(System.getProperties()).setUserProperties(new Properties()).setReactorFailureBehavior("FAIL_AT_END").setShowErrors(true).setGlobalChecksumPolicy("warn").setPom(this.projectPath.resolve("pom.xml").toFile()).setBaseDirectory(this.projectPath.toFile()).setTransferListener((TransferListener)new ProjectMavenTransferListener(this.logRecordConsumer)).setCacheNotFound(true).setInteractiveMode(true).setCacheTransferError(false).setActiveProfiles(this.profiles.isEmpty() ? null : this.profiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(Consumer<Map<String, Object>> consumer) {
        PlexusContainer plexusContainer = null;
        try {
            plexusContainer = this.buildPlexusContainer();
            MavenExecutionRequest mavenExecutionRequest = this.mavenExecutionRequest(plexusContainer);
            Maven maven = (Maven)plexusContainer.lookup(Maven.class);
            Thread.currentThread().setContextClassLoader((ClassLoader)plexusContainer.getContainerRealm());
            MavenExecutionResult result = maven.execute(mavenExecutionRequest);
            consumer.accept((Map<String, Object>)ImmutableMap.of((Object)"time", (Object)result.getBuildSummary(result.getProject()).getTime(), (Object)"exceptions", (Object)result.getExceptions()));
        }
        catch (Exception x) {
            LogRecord record = new LogRecord(Level.WARNING, "Unable to execute maven");
            record.setThrown(x);
            record.setSourceClassName(null);
            this.logRecordConsumer.accept(record);
        }
        finally {
            if (plexusContainer != null) {
                plexusContainer.dispose();
            }
        }
    }
}

