/*
 * Decompiled with CFR 0.152.
 */
package org.marid.maven;

import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;

public class ProjectMavenTransferListener
implements TransferListener {
    private final Consumer<LogRecord> logRecordConsumer;

    public ProjectMavenTransferListener(Consumer<LogRecord> logRecordConsumer) {
        this.logRecordConsumer = logRecordConsumer;
    }

    private void log(Level level, String message, Object ... args) {
        LogRecord logRecord = new LogRecord(level, message);
        logRecord.setSourceClassName(null);
        logRecord.setParameters(args);
        this.logRecordConsumer.accept(logRecord);
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        this.log(Level.INFO, "{0}", event);
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        this.log(Level.INFO, "{0}", event);
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        this.log(Level.WARNING, "{0}", event);
    }

    public void transferSucceeded(TransferEvent event) {
        this.log(Level.INFO, "{0}", event);
    }

    public void transferFailed(TransferEvent event) {
        this.log(Level.SEVERE, "{0}", event);
    }
}

