/*
 * Decompiled with CFR 0.152.
 */
package org.marid.maven;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.codehaus.plexus.logging.AbstractLogger;

public class ProjectPlexusLogger
extends AbstractLogger {
    private final Map<String, ProjectPlexusLogger> children = new ConcurrentHashMap<String, ProjectPlexusLogger>();
    private final Consumer<LogRecord> logRecordConsumer;

    public ProjectPlexusLogger(String name, Consumer<LogRecord> logRecordConsumer) {
        super(1, name);
        this.logRecordConsumer = logRecordConsumer;
    }

    public void debug(String message, Throwable throwable) {
        this.log(Level.FINE, message, throwable);
    }

    public void info(String message, Throwable throwable) {
        this.log(Level.INFO, message, throwable);
    }

    public void warn(String message, Throwable throwable) {
        this.log(Level.WARNING, message, throwable);
    }

    public void error(String message, Throwable throwable) {
        this.log(Level.SEVERE, message, throwable);
    }

    public void fatalError(String message, Throwable throwable) {
        this.log(Level.SEVERE, message, throwable);
    }

    private void log(Level level, String message, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, message);
        logRecord.setThrown(throwable);
        logRecord.setLoggerName(this.getName());
        logRecord.setSourceClassName(null);
        this.logRecordConsumer.accept(logRecord);
    }

    public ProjectPlexusLogger getChildLogger(String name) {
        return this.children.computeIfAbsent(name, k -> new ProjectPlexusLogger(name, this.logRecordConsumer));
    }
}

