/*
 * Copyright (c) 2016 Dmitry Ovchinnikov
 * Marid, the free data acquisition and visualization software
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.marid.proto.modbus;

/**
 * @author Dmitry Ovchinnikov
 */
public class ModbusFloatCodec implements ModbusCodec<Float> {

    private final ModbusIntCodec codec;

    public ModbusFloatCodec(ModbusTwoRegisterOrder order) {
        this.codec = new ModbusIntCodec(order);
    }

    @Override
    public Float decode(byte[] data) {
        return Float.intBitsToFloat(codec.decode(data));
    }

    @Override
    public byte[] encode(Float data) {
        return codec.encode(Float.floatToIntBits(data));
    }
}
