/*
 * Decompiled with CFR 0.152.
 */
package org.marid.racks.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.marid.runtime.annotation.Constant;
import org.marid.runtime.annotation.Constants;
import org.marid.runtime.annotation.Title;

@Title(value="Network constants")
@Constants
public interface NetConstants {
    @Constant
    public static InetAddress inetAddressFromBytes(byte[] address) throws UnknownHostException {
        return InetAddress.getByAddress(address);
    }

    @Constant
    public static InetAddress inetAddressFromHostAndBytes(String host, byte[] address) throws UnknownHostException {
        return InetAddress.getByAddress(host, address);
    }

    @Constant
    public static InetAddress inetAddressFromHost(String host) throws UnknownHostException {
        return InetAddress.getByName(host);
    }

    @Constant
    public static InetAddress anyLocalAddress() {
        return new InetSocketAddress(0).getAddress();
    }

    @Constant
    public static InetAddress loopbackAddress() {
        return InetAddress.getLoopbackAddress();
    }

    @Constant
    public static InetSocketAddress socketAddress(String host, int port) {
        return new InetSocketAddress(host, port);
    }

    @Constant
    public static InetSocketAddress socketAddressUnresolved(String host, int port) {
        return InetSocketAddress.createUnresolved(host, port);
    }

    @Constant
    public static InetSocketAddress socketAddressFromInetAddress(InetAddress address, int port) {
        return new InetSocketAddress(address, port);
    }
}

