/*
 * Decompiled with CFR 0.152.
 */
package org.marid.racks.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.StandardSocketOptions;
import org.marid.io.function.IOSupplier;
import org.marid.runtime.annotation.Description;
import org.marid.runtime.annotation.In;
import org.marid.runtime.annotation.Out;
import org.marid.runtime.annotation.Rack;

@Rack
@Description(value="Server socket")
public class ServerSocketRack
implements Closeable {
    private final ServerSocket serverSocket;

    public ServerSocketRack(int port, int backlog, InetAddress bindAddress) throws IOException {
        this.serverSocket = bindAddress == null ? new ServerSocket(port, backlog) : new ServerSocket(port, backlog, bindAddress);
    }

    @In
    public void setInputBufferSize(int size) throws IOException {
        this.serverSocket.setOption(StandardSocketOptions.SO_RCVBUF, size);
    }

    @In
    public void setOutputBufferSize(int size) throws IOException {
        this.serverSocket.setOption(StandardSocketOptions.SO_SNDBUF, size);
    }

    @In
    public void setSoBroadcast(boolean broadcast) throws IOException {
        this.serverSocket.setOption(StandardSocketOptions.SO_BROADCAST, broadcast);
    }

    @Out
    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    @Out
    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @Out
    public IOSupplier<Socket> getSocketSupplier() {
        return this.serverSocket::accept;
    }

    @Override
    public void close() throws IOException {
        this.serverSocket.close();
    }
}

