/*
 * Decompiled with CFR 0.152.
 */
package org.marid.beans;

import java.beans.Introspector;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Formattable;
import java.util.Formatter;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.marid.beans.TypeInfo;
import org.springframework.core.ResolvableType;

public class MethodInfo
extends TypeInfo
implements Formattable {
    @Nonnull
    public final TypeInfo[] parameters;

    public MethodInfo(@Nonnull String name, @Nonnull ResolvableType type, @Nullable String title, @Nullable String description, @Nullable String icon, @Nonnull List<Class<?>> editors, @Nonnull TypeInfo[] parameters) {
        super(name, type, title, description, icon, editors);
        this.parameters = parameters;
    }

    @Override
    protected void map(BiConsumer<String, Object> consumer) {
        super.map(consumer);
        consumer.accept("parameters", Arrays.asList(this.parameters));
    }

    public boolean isSetter() {
        return this.name.startsWith("set") && this.name.length() > 3 && this.parameters.length == 1;
    }

    public boolean isGetter() {
        if (ResolvableType.forClass(Boolean.TYPE).equals((Object)this.type)) {
            return this.name.startsWith("is") && this.name.length() > 2 && this.parameters.length == 0;
        }
        return this.name.startsWith("get") && this.name.length() > 3 && this.parameters.length == 0;
    }

    public boolean isProperty() {
        return this.isGetter() || this.isSetter();
    }

    public String getPropertyName() {
        if (this.isProperty()) {
            if (this.isGetter()) {
                if (this.name.startsWith("get")) {
                    return Introspector.decapitalize(this.name.substring(3));
                }
                return Introspector.decapitalize(this.name.substring(2));
            }
            return Introspector.decapitalize(this.name.substring(3));
        }
        return null;
    }

    public boolean matches(Executable executable) {
        Class<?>[] parameters = executable.getParameterTypes();
        if (parameters.length != this.parameters.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].equals(this.parameters[i].type.getRawClass())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        formatter.format("%s", Stream.of(this.parameters).map((? super T i) -> i.name + ": " + i.type).collect(Collectors.joining(",", this.name + "(", ")")));
    }
}

