/*
 * Decompiled with CFR 0.152.
 */
package org.marid.beans;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.beans.NamedArg;
import javax.annotation.Nonnull;
import org.marid.beans.BeanEditor;
import org.marid.beans.ClassInfo;
import org.marid.beans.Info;
import org.marid.beans.MethodInfo;
import org.marid.beans.TypeInfo;
import org.marid.logging.Log;
import org.springframework.core.ResolvableType;

public class BeanIntrospector {
    @Nonnull
    public static List<ClassInfo> classInfos(@Nonnull ClassLoader classLoader, @Nonnull ResolvableType type) {
        ArrayList classInfos = new ArrayList();
        for (BeanEditor beanEditor : ServiceLoader.load(BeanEditor.class, classLoader)) {
            try {
                Set editorClasses;
                ResolvableType beanEditorType = ResolvableType.forClass(BeanEditor.class, beanEditor.getClass());
                ResolvableType p = beanEditorType.getGeneric(new int[]{0});
                if (p == ResolvableType.NONE || p.getRawClass() == null || !p.getRawClass().isAssignableFrom(type.getRawClass()) || (editorClasses = beanEditor.editors(type.getRawClass())).isEmpty()) continue;
                ArrayList<ResolvableType> types = new ArrayList<ResolvableType>();
                types.add(type);
                if (type.hasGenerics()) {
                    for (Class c : editorClasses) {
                        ResolvableType tc = ResolvableType.forClassWithGenerics(c, (ResolvableType[])type.getGenerics());
                        types.add(tc);
                        Type[] typeArray = c.getGenericInterfaces();
                        int n = typeArray.length;
                        for (int i = 0; i < n; ++i) {
                            Type itf = typeArray[i];
                            ResolvableType itfType = ResolvableType.forType((Type)itf, (ResolvableType)tc);
                            if (!itfType.getRawClass().isAnnotationPresent(Info.class)) continue;
                            types.add(itfType);
                        }
                    }
                } else {
                    for (Class c : editorClasses) {
                        types.add(ResolvableType.forClass(c));
                        for (Class<?> itf : c.getInterfaces()) {
                            if (!itf.isAnnotationPresent(Info.class)) continue;
                            types.add(ResolvableType.forClass(itf));
                        }
                    }
                }
                classInfos.add(types.stream().map(BeanIntrospector::classInfo).reduce(BeanIntrospector::merge).orElseThrow(IllegalStateException::new));
            }
            catch (TypeNotPresentException x) {
                Log.log((Level)Level.FINE, (String)"{0} is not loaded", (Object[])new Object[]{beanEditor});
            }
        }
        return classInfos.isEmpty() ? Collections.emptyList() : classInfos;
    }

    public static ClassInfo merge(@Nonnull ClassInfo c1, @Nonnull ClassInfo c2) {
        return new ClassInfo(c1.name, c1.type, c1.title != null ? c1.title : c2.title, c1.description != null ? c1.description : c2.description, c1.icon != null ? c1.icon : c2.icon, BeanIntrospector.merge(c1.editors, c2.editors), (MethodInfo[])Stream.of(c1.constructorInfos).map(c -> BeanIntrospector.merge(c, c2.constructorInfos)).toArray(MethodInfo[]::new), (MethodInfo[])Stream.of(c1.methodInfos).map(m -> BeanIntrospector.merge(m, c2.methodInfos)).toArray(MethodInfo[]::new));
    }

    static List<Class<?>> merge(List<Class<?>> e1, List<Class<?>> e2) {
        if (e1.isEmpty()) {
            return e2;
        }
        if (e2.isEmpty()) {
            return e1;
        }
        ArrayList result = new ArrayList(e1.size() + e2.size());
        result.addAll(e1);
        result.addAll(e2);
        return result;
    }

    private static TypeInfo merge(@Nonnull TypeInfo i1, @Nonnull TypeInfo i2) {
        return new TypeInfo(i1.name, i1.type, i2.title != null ? i2.title : i1.title, i2.description != null ? i2.description : i1.description, i2.icon != null ? i2.icon : i1.icon, BeanIntrospector.merge(i1.editors, i2.editors));
    }

    private static TypeInfo[] merge(TypeInfo[] p1, TypeInfo[] p2) {
        return (TypeInfo[])IntStream.range(0, p1.length).mapToObj(i -> BeanIntrospector.merge(p1[i], p2[i])).toArray(TypeInfo[]::new);
    }

    private static MethodInfo merge(@Nonnull MethodInfo m1, @Nonnull MethodInfo m2) {
        return new MethodInfo(m1.name, m1.type, m1.title != null ? m1.title : m2.title, m1.description != null ? m1.description : m2.description, m1.icon != null ? m1.icon : m2.icon, BeanIntrospector.merge(m1.editors, m2.editors), BeanIntrospector.merge(m1.parameters, m2.parameters));
    }

    private static boolean methodEquals(@Nonnull MethodInfo m1, @Nonnull MethodInfo m2) {
        if (m1.name.equals(m2.name)) {
            Object[] t1 = (Class[])Stream.of(m1.parameters).map(t -> t.type.getRawClass()).toArray(Class[]::new);
            Object[] t2 = (Class[])Stream.of(m2.parameters).map(t -> t.type.getRawClass()).toArray(Class[]::new);
            return Arrays.equals(t1, t2);
        }
        return false;
    }

    private static MethodInfo merge(@Nonnull MethodInfo methodInfo, @Nonnull MethodInfo[] methodInfos) {
        return Stream.of(methodInfos).filter(i -> BeanIntrospector.methodEquals(methodInfo, i)).reduce(methodInfo, BeanIntrospector::merge);
    }

    private static TypeInfo p(@Nonnull Parameter parameter, @Nonnull ResolvableType type) {
        Info info = parameter.getAnnotation(Info.class);
        ResolvableType paramType = ResolvableType.forType((Type)parameter.getParameterizedType(), (ResolvableType)type);
        String name = parameter.isAnnotationPresent(NamedArg.class) ? parameter.getAnnotation(NamedArg.class).value() : parameter.getName();
        return new TypeInfo(name, paramType, BeanIntrospector.title(info), BeanIntrospector.desc(info), BeanIntrospector.icon(info), BeanIntrospector.editor(info));
    }

    private static MethodInfo c(@Nonnull Constructor<?> constructor, @Nonnull ResolvableType type) {
        Info info = constructor.getAnnotation(Info.class);
        TypeInfo[] ps = (TypeInfo[])Stream.of(constructor.getParameters()).map(p -> BeanIntrospector.p(p, type)).toArray(TypeInfo[]::new);
        return new MethodInfo("init", type, BeanIntrospector.title(info), BeanIntrospector.desc(info), BeanIntrospector.icon(info), BeanIntrospector.editor(info), ps);
    }

    private static MethodInfo m(@Nonnull Method method, @Nonnull ResolvableType type) {
        Info info = method.getAnnotation(Info.class);
        TypeInfo[] ps = (TypeInfo[])Stream.of(method.getParameters()).map(p -> BeanIntrospector.p(p, type)).toArray(TypeInfo[]::new);
        ResolvableType methodType = ResolvableType.forType((Type)method.getGenericReturnType(), (ResolvableType)type);
        return new MethodInfo(method.getName(), methodType, BeanIntrospector.title(info), BeanIntrospector.desc(info), BeanIntrospector.icon(info), BeanIntrospector.editor(info), ps);
    }

    private static ClassInfo classInfo(@Nonnull ResolvableType type) {
        Class rc = type.getRawClass();
        Info info = rc.getAnnotation(Info.class);
        MethodInfo[] cs = (MethodInfo[])Stream.of(rc.getConstructors()).map(c -> BeanIntrospector.c(c, type)).toArray(MethodInfo[]::new);
        MethodInfo[] ms = (MethodInfo[])Stream.of(rc.getMethods()).map(m -> BeanIntrospector.m(m, type)).toArray(MethodInfo[]::new);
        return new ClassInfo(rc.getName(), type, BeanIntrospector.title(info), BeanIntrospector.desc(info), BeanIntrospector.icon(info), BeanIntrospector.editor(info), cs, ms);
    }

    private static String title(Info info) {
        return info != null && !info.title().isEmpty() ? info.title() : null;
    }

    private static String desc(Info info) {
        return info != null && !info.description().isEmpty() ? info.description() : null;
    }

    private static String icon(Info info) {
        return info != null && !info.icon().isEmpty() ? info.icon() : null;
    }

    private static List<Class<?>> editor(Info info) {
        return info == null || info.editors().length == 0 ? Collections.emptyList() : Arrays.asList(info.editors());
    }
}

