/*
 * Decompiled with CFR 0.152.
 */
package org.marid.beans;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.marid.beans.BeanIntrospector;
import org.marid.beans.MethodInfo;
import org.marid.beans.TypeInfo;
import org.springframework.core.ResolvableType;

public class ClassInfo
extends TypeInfo {
    @Nonnull
    public final MethodInfo[] constructorInfos;
    @Nonnull
    public final MethodInfo[] methodInfos;
    @Nonnull
    public final TypeInfo[] propertyInfos;

    public ClassInfo(@Nonnull String name, @Nonnull ResolvableType type, @Nullable String title, @Nullable String description, @Nullable String icon, @Nonnull List<Class<?>> editors, @Nonnull MethodInfo[] constructorInfos, @Nonnull MethodInfo[] methodInfos) {
        super(name, type, title, description, icon, editors);
        this.constructorInfos = constructorInfos;
        this.methodInfos = methodInfos;
        LinkedHashMap<String, MethodInfo[]> properties = new LinkedHashMap<String, MethodInfo[]>();
        for (MethodInfo methodInfo : methodInfos) {
            String propertyName = methodInfo.getPropertyName();
            if (propertyName == null) continue;
            MethodInfo[] methods = properties.computeIfAbsent(propertyName, n -> new MethodInfo[2]);
            methods[methodInfo.isGetter() ? 0 : 1] = methodInfo;
        }
        this.propertyInfos = (TypeInfo[])properties.entrySet().stream().map((? super T e) -> ClassInfo.merge((String)e.getKey(), (MethodInfo[])e.getValue())).toArray(TypeInfo[]::new);
    }

    @Override
    protected void map(BiConsumer<String, Object> consumer) {
        super.map(consumer);
        consumer.accept("constructors", Stream.of(this.constructorInfos).collect(Collectors.toCollection(LinkedHashSet::new)));
        consumer.accept("methods", Stream.of(this.methodInfos).collect(Collectors.toCollection(LinkedHashSet::new)));
        consumer.accept("properties", Stream.of(this.propertyInfos).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    private static TypeInfo merge(String pName, MethodInfo[] methodInfos) {
        ResolvableType pType = methodInfos[0] != null ? methodInfos[0].type : methodInfos[1].type;
        Function<Function, String> func = f -> {
            if (methodInfos[0] != null && f.apply(methodInfos[0]) != null) {
                return (String)f.apply(methodInfos[0]);
            }
            if (methodInfos[1] != null && f.apply(methodInfos[1]) != null) {
                return (String)f.apply(methodInfos[1]);
            }
            return null;
        };
        String pTitle = func.apply(i -> i.title);
        String pDesc = func.apply(i -> i.description);
        String pIcon = func.apply(i -> i.icon);
        List<List> editorList = Arrays.asList(methodInfos[0] != null ? methodInfos[0].editors : Collections.emptyList(), methodInfos[1] != null ? methodInfos[1].editors : Collections.emptyList());
        List<Class<?>> editors = BeanIntrospector.merge(editorList.get(0), editorList.get(1));
        return new TypeInfo(pName, pType, pTitle, pDesc, pIcon, editors);
    }
}

