/*
 * Decompiled with CFR 0.152.
 */
package org.marid.runtime;

import org.marid.runtime.MaridBeanPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class MaridBaseApplicationContext
extends GenericXmlApplicationContext {
    public MaridBaseApplicationContext(ClassLoader classLoader) {
        this.addBeanFactoryPostProcessor(beanFactory -> {
            beanFactory.addBeanPostProcessor((BeanPostProcessor)new MaridBeanPostProcessor(beanFactory));
            beanFactory.addBeanPostProcessor((BeanPostProcessor)new CommonAnnotationBeanPostProcessor());
        });
        this.setClassLoader(classLoader);
        this.setAllowCircularReferences(false);
        this.setValidating(false);
        this.setResourceLoader((ResourceLoader)new PathMatchingResourcePatternResolver(classLoader));
        this.load(new String[]{"classpath*:/META-INF/marid/**/*.xml"});
    }

    public MaridBaseApplicationContext() {
        this(Thread.currentThread().getContextClassLoader());
    }
}

