/*
 * Decompiled with CFR 0.152.
 */
package org.marid.runtime;

import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.marid.logging.LogSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class MaridBeanPostProcessor
implements LogSupport,
DestructionAwareBeanPostProcessor {
    private static final Logger LOGGER = Logger.getLogger("marid");
    private static final Pattern INIT_ATTR = Pattern.compile("init(\\d+)");
    private static final Pattern DESTROY_ATTR = Pattern.compile("destroy(\\d+)");
    private final ConfigurableListableBeanFactory beanFactory;
    private final SpelExpressionParser expressionParser;

    public MaridBeanPostProcessor(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.expressionParser = new SpelExpressionParser();
    }

    @Nonnull
    public Logger logger() {
        return LOGGER;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        this.log(INFO, "Destroying {0}", new Object[]{beanName});
        if (beanName != null && this.beanFactory.containsBeanDefinition(beanName)) {
            this.applyTriggers(bean, beanName, DESTROY_ATTR);
        }
    }

    public boolean requiresDestruction(Object o) {
        return true;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.log(INFO, "Initializing {0}", new Object[]{beanName});
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (beanName != null && this.beanFactory.containsBeanDefinition(beanName)) {
            this.applyTriggers(bean, beanName, INIT_ATTR);
        }
        this.log(INFO, "Initialized {0}", new Object[]{beanName});
        return bean;
    }

    private void applyTriggers(Object bean, String beanName, Pattern attrPattern) throws BeansException {
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
        String[] attributeNames = beanDefinition.attributeNames();
        if (attributeNames.length == 0) {
            return;
        }
        TreeMap<Integer, String> indexedAttributes = new TreeMap<Integer, String>();
        for (String string : attributeNames) {
            Matcher matcher = attrPattern.matcher(string);
            if (!matcher.matches()) continue;
            int index = Integer.parseInt(matcher.group(1));
            indexedAttributes.put(index, string);
        }
        if (indexedAttributes.isEmpty()) {
            return;
        }
        TreeMap<Integer, Object> results = new TreeMap<Integer, Object>();
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(bean);
        evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.beanFactory));
        evaluationContext.setVariable("results", results);
        for (Map.Entry entry : indexedAttributes.entrySet()) {
            String attr = (String)entry.getValue();
            entry.setValue(beanDefinition.getAttribute(attr).toString());
        }
        for (Map.Entry entry : indexedAttributes.entrySet()) {
            Integer index = (Integer)entry.getKey();
            String expressionText = (String)entry.getValue();
            try {
                Expression expression = this.expressionParser.parseExpression(expressionText);
                Object value = expression.getValue((EvaluationContext)evaluationContext);
                results.put(index, value);
            }
            catch (BeansException x) {
                throw new BeanInitializationException(attrPattern.pattern() + " trigger " + index + " error", (Throwable)x);
            }
        }
    }
}

