/*
 * Copyright (C) 2014 Dmitry Ovchinnikov
 * Marid, the free data acquisition and visualization software
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.marid.bd;

import org.marid.util.Utils;

/**
 * @author Dmitry Ovchinnikov
 */
public abstract class IoBlock extends StandardBlock {

    protected final Class<?> inputType;
    protected final Class<?> outputType;

    public final In input;
    public final Out output;

    public IoBlock(Class<?> inputType, Class<?> outputType) {
        this.inputType = inputType;
        this.outputType = outputType;
        this.input = new In("in", inputType, true, this::set);
        this.output = new Out("out", Utils.cast(outputType), this::get);
    }

    protected abstract void set(Object value);

    protected abstract Object get();
}
