/*
 * Copyright (c) 2016 Dmitry Ovchinnikov
 * Marid, the free data acquisition and visualization software
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.marid.misc;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * @author Dmitry Ovchinnikov.
 * @since 0.8
 */
public interface Iterables {

    static <E> Optional<E> last(List<E> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        } else if (list instanceof LinkedList<?>) {
            final LinkedList<E> linkedList = (LinkedList<E>) list;
            return Optional.ofNullable(linkedList.peekLast());
        } else {
            return Optional.ofNullable(list.get(list.size() - 1));
        }
    }

    static <E> Stream<E> stream(Class<E> type, Stream<?> stream) {
        return stream.filter(type::isInstance).map(type::cast);
    }
}
