/*
 * @(#)SudokuPuzzles.java        1.0.0    2016-04-16
 *
 * You may use this software under the condition of "Simplified BSD License"
 *
 * Copyright 2016 MARIUSZ GROMADA. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MARIUSZ GROMADA ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of MARIUSZ GROMADA.
 *
 * If you have any questions/bugs feel free to contact:
 *
 *     Mariusz Gromada
 *     mariuszgromada.org@gmail.com
 *     http://janetsudoku.mariuszgromada.org
 *     http://mathparser.org
 *     http://mathspace.pl
 *     http://github.com/mariuszgromada/Janet-Sudoku
 *     http://janetsudoku.codeplex.com
 *     http://sourceforge.net/projects/janetsudoku
 *     http://bitbucket.org/mariuszgromada/janet-sudoku
 *     http://github.com/mariuszgromada/MathParser.org-mXparser
 *
 *
 *                              Asked if he believes in one God, a mathematician answered:
 *                              "Yes, up to isomorphism."
 */
package org.mariuszgromada.math.janetsudoku;

/**
 * Set of static final arrays containing Sudoku puzzles.
 *
 * @author         <b>Mariusz Gromada</b><br>
 *                 <a href="mailto:mariuszgromada.org@gmail.com">mariuszgromada.org@gmail.com</a><br>
 *                 <a href="http://janetsudoku.mariuszgromada.org" target="_blank">Janet Sudoku - project web page</a><br>
 *                 <a href="http://mathspace.pl" target="_blank">MathSpace.pl</a><br>
 *                 <a href="http://mathparser.org" target="_blank">MathParser.org - mXparser project page</a><br>
 *                 <a href="http://github.com/mariuszgromada/Janet-Sudoku" target="_blank">Janet Sudoku on GitHub</a><br>
 *                 <a href="http://janetsudoku.codeplex.com" target="_blank">Janet Sudoku on CodePlex</a><br>
 *                 <a href="http://sourceforge.net/projects/janetsudoku" target="_blank">Janet Sudoku on SourceForge</a><br>
 *                 <a href="http://bitbucket.org/mariuszgromada/janet-sudoku" target="_blank">Janet Sudoku on BitBucket</a><br>
 *                 <a href="http://github.com/mariuszgromada/MathParser.org-mXparser" target="_blank">mXparser-MathParser.org on GitHub</a><br>
 *
 * @version        1.0.0
 */
public final class SudokuPuzzles {
	/**
	 * Sudoku example - number 0.
	 */
	public static final int[][] PUZZLE_EXAMPLE_000 = {
			{0,9,0, 0,7,0, 0,0,0},
			{0,0,1, 0,0,2, 0,0,8},
			{0,2,0, 9,0,0, 3,0,0},

			{0,0,8, 0,0,0, 0,4,0},
			{0,1,0, 0,0,9, 0,0,5},
			{0,0,5, 6,0,0, 0,0,0},

			{0,0,0, 7,0,0, 4,0,0},
			{1,0,0, 0,0,8, 0,0,9},
			{0,0,0, 0,3,0, 0,6,0}
		};
	/**
	 * Sudoku example - number 1.
	 */
	public static final int[][] PUZZLE_EXAMPLE_001 = {
			{5,3,0, 0,7,0, 0,0,0},
			{6,0,0, 1,9,5, 0,0,0},
			{0,9,8, 0,0,0, 0,6,0},

			{8,0,0, 0,6,0, 0,0,3},
			{4,0,0, 8,0,3, 0,0,1},
			{7,0,0, 0,2,0, 0,0,6},

			{0,6,0, 0,0,0, 2,8,0},
			{0,0,0, 4,1,9, 0,0,5},
			{0,0,0, 0,8,0, 0,7,9}
		};
	/**
	 * Sudoku example - number 2.
	 */
	public static final int[][] PUZZLE_EXAMPLE_002 = {
			{0,0,9, 1,0,8, 0,4,0},
			{0,4,0, 6,0,5, 7,0,8},
			{0,0,0, 0,0,0, 0,1,0},

			{8,0,0, 3,0,0, 0,7,0},
			{1,0,5, 7,0,2, 4,0,9},
			{0,9,0, 0,0,1, 0,0,2},

			{0,6,0, 0,0,0, 0,0,0},
			{9,0,3, 8,0,4, 0,2,0},
			{0,5,0, 2,0,6, 1,0,0},
		};
	/**
	 * Sudoku example - number 3.
	 */
	public static final int[][] PUZZLE_EXAMPLE_003 = {
			{3,0,0, 0,2,9, 0,0,5},
			{5,9,2, 0,3,8, 1,0,0},
			{0,7,8, 0,6,5, 3,9,2},

			{0,0,0, 9,0,0, 0,0,0},
			{0,0,1, 8,0,3, 9,0,0},
			{0,0,9, 0,0,4, 0,0,0},

			{8,0,0, 5,9,0, 4,2,3},
			{0,0,3, 0,8,0, 5,7,9},
			{9,0,0, 3,4,0, 0,0,1},
		};
	/**
	 * Sudoku example - number 4.
	 */
	public static final int[][] PUZZLE_EXAMPLE_004 = {
			{0,0,3, 0,2,0, 6,0,0},
			{9,0,0, 3,0,5, 0,0,1},
			{0,0,1, 8,0,6, 4,0,0},

			{0,0,8, 1,0,2, 9,0,0},
			{7,0,0, 0,0,0, 0,0,8},
			{0,0,6, 7,0,8, 2,0,0},

			{0,0,2, 6,0,9, 5,0,0},
			{8,0,0, 2,0,3, 0,0,9},
			{0,0,5, 0,1,0, 3,0,0},
		};
	/**
	 * Sudoku example - number 5.
	 */
	public static final int[][] PUZZLE_EXAMPLE_005 = {
			{2,0,0, 0,8,0, 3,0,0},
			{0,6,0, 0,7,0, 0,8,4},
			{0,3,0, 5,0,0, 2,0,9},

			{0,0,0, 1,0,5, 4,0,8},
			{0,0,0, 0,0,0, 0,0,0},
			{4,0,2, 7,0,6, 0,0,0},

			{3,0,1, 0,0,7, 0,4,0},
			{7,2,0, 0,4,0, 0,6,0},
			{0,0,4, 0,1,0, 0,0,3},
		};
	/**
	 * Sudoku example - number 6.
	 */
	public static final int[][] PUZZLE_EXAMPLE_006 = {
			{0,0,0, 0,0,0, 9,0,7},
			{0,0,0, 4,2,0, 1,8,0},
			{0,0,0, 7,0,5, 0,2,6},

			{1,0,0, 9,0,4, 0,0,0},
			{0,5,0, 0,0,0, 0,4,0},
			{0,0,0, 5,0,7, 0,0,9},

			{9,2,0, 1,0,8, 0,0,0},
			{0,3,4, 0,5,9, 0,0,0},
			{5,0,7, 0,0,0, 0,0,0},
		};
	/**
	 * Sudoku example - number 7.
	 */
	public static final int[][] PUZZLE_EXAMPLE_007 = {
			{0,3,0, 0,5,0, 0,4,0},
			{0,0,8, 0,1,0, 5,0,0},
			{4,6,0, 0,0,0, 0,1,2},

			{0,7,0, 5,0,2, 0,8,0},
			{0,0,0, 6,0,3, 0,0,0},
			{0,4,0, 1,0,9, 0,3,0},

			{2,5,0, 0,0,0, 0,9,8},
			{0,0,1, 0,2,0, 6,0,0},
			{0,8,0, 0,6,0, 0,2,0},
		};
	/**
	 * Sudoku example - number 8.
	 */
	public static final int[][] PUZZLE_EXAMPLE_008 = {
			{0,2,0, 8,1,0, 7,4,0},
			{7,0,0, 0,0,3, 1,0,0},
			{0,9,0, 0,0,2, 8,0,5},

			{0,0,9, 0,4,0, 0,8,7},
			{4,0,0, 2,0,8, 0,0,3},
			{1,6,0, 0,3,0, 2,0,0},

			{3,0,2, 7,0,0, 0,6,0},
			{0,0,5, 6,0,0, 0,0,8},
			{0,7,6, 0,5,1, 0,9,0},
		};
	/**
	 * Sudoku example - number 9.
	 */
	public static final int[][] PUZZLE_EXAMPLE_009 = {
			{1,0,0, 9,2,0, 0,0,0},
			{5,2,4, 0,1,0, 0,0,0},
			{0,0,0, 0,0,0, 0,7,0},

			{0,5,0, 0,0,8, 1,0,2},
			{0,0,0, 0,0,0, 0,0,0},
			{4,0,2, 7,0,0, 0,9,0},

			{0,6,0, 0,0,0, 0,0,0},
			{0,0,0, 0,3,0, 9,4,5},
			{0,0,0, 0,7,1, 0,0,6},
		};
	/**
	 * Sudoku example - number 10.
	 */
	public static final int[][] PUZZLE_EXAMPLE_010 = {
			{0,4,3, 0,8,0, 2,5,0},
			{6,0,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,1, 0,9,4},

			{9,0,0, 0,0,4, 0,7,0},
			{0,0,0, 6,0,8, 0,0,0},
			{0,1,0, 2,0,0, 0,0,3},

			{8,2,0, 5,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,0,5},
			{0,3,4, 0,9,0, 7,1,0},
		};
	/**
	 * Sudoku example - number 11.
	 */
	public static final int[][] PUZZLE_EXAMPLE_011 = {
			{4,8,0, 0,0,6, 9,0,2},
			{0,0,2, 0,0,8, 0,0,1},
			{9,0,0, 3,7,0, 0,6,0},

			{8,4,0, 0,1,0, 2,0,0},
			{0,0,3, 7,0,4, 1,0,0},
			{0,0,1, 0,6,0, 0,4,9},

			{0,2,0, 0,8,5, 0,0,7},
			{7,0,0, 9,0,0, 6,0,0},
			{6,0,9, 2,0,0, 0,1,8},
		};
	/**
	 * Sudoku example - number 12.
	 */
	public static final int[][] PUZZLE_EXAMPLE_012 = {
			{0,0,0, 9,0,0, 0,0,2},
			{0,5,0, 1,2,3, 4,0,0},
			{0,3,0, 0,0,0, 1,6,0},

			{9,0,8, 0,0,0, 0,0,0},
			{0,7,0, 0,0,0, 0,9,0},
			{0,0,0, 0,0,0, 2,0,5},

			{0,9,1, 0,0,0, 0,5,0},
			{0,0,7, 4,3,9, 0,2,0},
			{4,0,0, 0,0,7, 0,0,0},
		};
	/**
	 * Sudoku example - number 13.
	 */
	public static final int[][] PUZZLE_EXAMPLE_013 = {
			{0,0,1, 9,0,0, 0,0,3},
			{9,0,0, 7,0,0, 1,6,0},
			{0,3,0, 0,0,5, 0,0,7},

			{0,5,0, 0,0,0, 0,0,9},
			{0,0,4, 3,0,2, 6,0,0},
			{2,0,0, 0,0,0, 0,7,0},

			{6,0,0, 1,0,0, 0,3,0},
			{0,4,2, 0,0,7, 0,0,6},
			{5,0,0, 0,0,6, 8,0,0},
		};
	/**
	 * Sudoku example - number 14.
	 */
	public static final int[][] PUZZLE_EXAMPLE_014 = {
			{0,0,0, 1,2,5, 4,0,0},
			{0,0,8, 4,0,0, 0,0,0},
			{4,2,0, 8,0,0, 0,0,0},

			{0,3,0, 0,0,0, 0,9,5},
			{0,6,0, 9,0,2, 0,1,0},
			{5,1,0, 0,0,0, 0,6,0},

			{0,0,0, 0,0,3, 0,4,9},
			{0,0,0, 0,0,7, 2,0,0},
			{0,0,1, 2,9,8, 0,0,0},
		};
	/**
	 * Sudoku example - number 15.
	 */
	public static final int[][] PUZZLE_EXAMPLE_015 = {
			{0,6,2, 3,4,0, 7,5,0},
			{1,0,0, 0,0,5, 6,0,0},
			{5,7,0, 0,0,0, 0,4,0},

			{0,0,0, 0,9,4, 8,0,0},
			{4,0,0, 0,0,0, 0,0,6},
			{0,0,5, 8,3,0, 0,0,0},

			{0,3,0, 0,0,0, 0,9,1},
			{0,0,6, 4,0,0, 0,0,7},
			{0,5,9, 0,8,3, 2,6,0},
		};
	/**
	 * Sudoku example - number 16.
	 */
	public static final int[][] PUZZLE_EXAMPLE_016 = {
			{3,0,0, 0,0,0, 0,0,0},
			{0,0,5, 0,0,9, 0,0,0},
			{2,0,0, 5,0,4, 0,0,0},

			{0,2,0, 0,0,0, 7,0,0},
			{1,6,0, 0,0,0, 0,5,8},
			{7,0,4, 3,1,0, 6,0,0},

			{0,0,0, 8,9,0, 1,0,0},
			{0,0,0, 0,6,7, 0,8,0},
			{0,0,0, 0,0,5, 4,3,7},
		};
	/**
	 * Sudoku example - number 17.
	 */
	public static final int[][] PUZZLE_EXAMPLE_017 = {
			{6,3,0, 0,0,0, 0,0,0},
			{0,0,0, 5,0,0, 0,0,8},
			{0,0,5, 6,7,4, 0,0,0},

			{0,0,0, 0,2,0, 0,0,0},
			{0,0,3, 4,0,1, 0,2,0},
			{0,0,0, 0,0,0, 3,4,5},

			{0,0,0, 0,0,7, 0,0,4},
			{0,8,0, 3,0,0, 9,0,2},
			{9,4,7, 1,0,0, 0,8,0},
		};
	/**
	 * Sudoku example - number 18.
	 */
	public static final int[][] PUZZLE_EXAMPLE_018 = {
			{0,0,0, 0,2,0, 0,4,0},
			{0,0,8, 0,3,5, 0,0,0},
			{0,0,0, 0,7,0, 6,0,2},

			{0,3,1, 0,4,6, 9,7,0},
			{2,0,0, 0,0,0, 0,0,0},
			{0,0,0, 5,0,1, 2,0,3},

			{0,4,9, 0,0,0, 7,3,0},
			{0,0,0, 0,0,0, 0,1,0},
			{8,0,0, 0,0,4, 0,0,0},
		};
	/**
	 * Sudoku example - number 19.
	 */
	public static final int[][] PUZZLE_EXAMPLE_019 = {
			{3,6,1, 0,2,5, 9,0,0},
			{0,8,0, 9,6,0, 0,1,0},
			{4,0,0, 0,0,0, 0,5,7},

			{0,0,8, 0,0,0, 4,7,1},
			{0,0,0, 6,0,3, 0,0,0},
			{2,5,9, 0,0,0, 8,0,0},

			{7,4,0, 0,0,0, 0,0,5},
			{0,2,0, 0,1,8, 0,6,0},
			{0,0,5, 4,7,0, 3,2,9},
		};
	/**
	 * Sudoku example - number 20.
	 */
	public static final int[][] PUZZLE_EXAMPLE_020 = {
			{0,5,0, 8,0,7, 0,2,0},
			{6,0,0, 0,1,0, 0,9,0},
			{7,0,2, 5,4,0, 0,0,6},

			{0,7,0, 0,2,0, 3,0,1},
			{5,0,4, 0,0,0, 9,0,8},
			{1,0,3, 0,8,0, 0,7,0},

			{9,0,0, 0,7,6, 2,0,5},
			{0,6,0, 0,9,0, 0,0,3},
			{0,8,0, 1,0,3, 0,4,0},
		};
	/**
	 * Sudoku example - number 21.
	 */
	public static final int[][] PUZZLE_EXAMPLE_021 = {
			{0,8,0, 0,0,5, 0,0,0},
			{0,0,0, 0,0,3, 4,5,7},
			{0,0,0, 0,7,0, 8,0,9},

			{0,6,0, 4,0,0, 9,0,3},
			{0,0,7, 0,1,0, 5,0,0},
			{4,0,8, 0,0,7, 0,2,0},

			{9,0,1, 0,2,0, 0,0,0},
			{8,4,2, 3,0,0, 0,0,0},
			{0,0,0, 1,0,0, 0,8,0},
		};
	/**
	 * Sudoku example - number 22.
	 */
	public static final int[][] PUZZLE_EXAMPLE_022 = {
			{0,0,3, 5,0,2, 9,0,0},
			{0,0,0, 0,4,0, 0,0,0},
			{1,0,6, 0,0,0, 3,0,5},

			{9,0,0, 2,5,1, 0,0,8},
			{0,7,0, 4,0,8, 0,3,0},
			{8,0,0, 7,6,3, 0,0,1},

			{3,0,8, 0,0,0, 1,0,4},
			{0,0,0, 0,2,0, 0,0,0},
			{0,0,5, 1,0,4, 8,0,0},
		};
	/**
	 * Sudoku example - number 23.
	 */
	public static final int[][] PUZZLE_EXAMPLE_023 = {
			{0,0,0, 0,0,0, 0,0,0},
			{0,0,9, 8,0,5, 1,0,0},
			{0,5,1, 9,0,7, 4,2,0},

			{2,9,0, 4,0,1, 0,6,5},
			{0,0,0, 0,0,0, 0,0,0},
			{1,4,0, 5,0,8, 0,9,3},

			{0,2,6, 7,0,9, 5,8,0},
			{0,0,5, 1,0,3, 6,0,0},
			{0,0,0, 0,0,0, 0,0,0},
		};
	/**
	 * Sudoku example - number 24.
	 */
	public static final int[][] PUZZLE_EXAMPLE_024 = {
			{0,2,0, 0,3,0, 0,9,0},
			{0,0,0, 9,0,7, 0,0,0},
			{9,0,0, 2,0,8, 0,0,5},

			{0,0,4, 8,0,6, 5,0,0},
			{6,0,7, 0,0,0, 2,0,8},
			{0,0,3, 1,0,2, 9,0,0},

			{8,0,0, 6,0,5, 0,0,7},
			{0,0,0, 3,0,9, 0,0,0},
			{0,3,0, 0,2,0, 0,5,0},
		};
	/**
	 * Sudoku example - number 25.
	 */
	public static final int[][] PUZZLE_EXAMPLE_025 = {
			{0,0,5, 0,0,0, 0,0,6},
			{0,7,0, 0,0,9, 0,2,0},
			{0,0,0, 5,0,0, 1,0,7},

			{8,0,4, 1,5,0, 0,0,0},
			{0,0,0, 8,0,3, 0,0,0},
			{0,0,0, 0,9,2, 8,0,5},

			{9,0,7, 0,0,6, 0,0,0},
			{0,3,0, 4,0,0, 0,1,0},
			{2,0,0, 0,0,0, 6,0,0},
		};
	/**
	 * Sudoku example - number 26.
	 */
	public static final int[][] PUZZLE_EXAMPLE_026 = {
			{0,4,0, 0,0,0, 0,5,0},
			{0,0,1, 9,4,3, 6,0,0},
			{0,0,9, 0,0,0, 3,0,0},

			{6,0,0, 0,5,0, 0,0,2},
			{1,0,3, 0,0,0, 5,0,6},
			{8,0,0, 0,2,0, 0,0,7},

			{0,0,5, 0,0,0, 2,0,0},
			{0,0,2, 4,3,6, 7,0,0},
			{0,3,0, 0,0,0, 0,4,0},
		};
	/**
	 * Sudoku example - number 27.
	 */
	public static final int[][] PUZZLE_EXAMPLE_027 = {
			{0,0,4, 0,0,0, 0,0,0},
			{0,0,0, 0,3,0, 0,0,2},
			{3,9,0, 7,0,0, 0,8,0},

			{4,0,0, 0,0,9, 0,0,1},
			{2,0,9, 8,0,1, 3,0,7},
			{6,0,0, 2,0,0, 0,0,8},

			{0,1,0, 0,0,8, 0,5,3},
			{9,0,0, 0,4,0, 0,0,0},
			{0,0,0, 0,0,0, 8,0,0},
		};
	/**
	 * Sudoku example - number 28.
	 */
	public static final int[][] PUZZLE_EXAMPLE_028 = {
			{3,6,0, 0,2,0, 0,8,9},
			{0,0,0, 3,6,1, 0,0,0},
			{0,0,0, 0,0,0, 0,0,0},

			{8,0,3, 0,0,0, 6,0,2},
			{4,0,0, 6,0,3, 0,0,7},
			{6,0,7, 0,0,0, 1,0,8},

			{0,0,0, 0,0,0, 0,0,0},
			{0,0,0, 4,1,8, 0,0,0},
			{9,7,0, 0,3,0, 0,1,4},
		};
	/**
	 * Sudoku example - number 29.
	 */
	public static final int[][] PUZZLE_EXAMPLE_029 = {
			{5,0,0, 4,0,0, 0,6,0},
			{0,0,9, 0,0,0, 8,0,0},
			{6,4,0, 0,2,0, 0,0,0},

			{0,0,0, 0,0,1, 0,0,8},
			{2,0,8, 0,0,0, 5,0,1},
			{7,0,0, 5,0,0, 0,0,0},

			{0,0,0, 0,9,0, 0,8,4},
			{0,0,3, 0,0,0, 6,0,0},
			{0,6,0, 0,0,3, 0,0,2},
		};
	/**
	 * Sudoku example - number 30.
	 */
	public static final int[][] PUZZLE_EXAMPLE_030 = {
			{0,0,7, 2,5,6, 4,0,0},
			{4,0,0, 0,0,0, 0,0,5},
			{0,1,0, 0,3,0, 0,6,0},

			{0,0,0, 5,0,8, 0,0,0},
			{0,0,8, 0,6,0, 2,0,0},
			{0,0,0, 1,0,7, 0,0,0},

			{0,3,0, 0,7,0, 0,9,0},
			{2,0,0, 0,0,0, 0,0,4},
			{0,0,6, 3,1,2, 7,0,0},
		};
	/**
	 * Sudoku example - number 31.
	 */
	public static final int[][] PUZZLE_EXAMPLE_031 = {
			{0,0,0, 0,0,0, 0,0,0},
			{0,7,9, 0,5,0, 1,8,0},
			{8,0,0, 0,0,0, 0,0,7},

			{0,0,7, 3,0,6, 8,0,0},
			{4,5,0, 7,0,8, 0,9,6},
			{0,0,3, 5,0,2, 7,0,0},

			{7,0,0, 0,0,0, 0,0,5},
			{0,1,6, 0,3,0, 4,2,0},
			{0,0,0, 0,0,0, 0,0,0},
		};
	/**
	 * Sudoku example - number 32.
	 */
	public static final int[][] PUZZLE_EXAMPLE_032 = {
			{0,3,0, 0,0,0, 0,8,0},
			{0,0,9, 0,0,0, 5,0,0},
			{0,0,7, 5,0,9, 2,0,0},

			{7,0,0, 1,0,5, 0,0,8},
			{0,2,0, 0,9,0, 0,3,0},
			{9,0,0, 4,0,2, 0,0,1},

			{0,0,4, 2,0,7, 1,0,0},
			{0,0,2, 0,0,0, 8,0,0},
			{0,7,0, 0,0,0, 0,9,0},
		};
	/**
	 * Sudoku example - number 33.
	 */
	public static final int[][] PUZZLE_EXAMPLE_033 = {
			{2,0,0, 1,7,0, 6,0,3},
			{0,5,0, 0,0,0, 1,0,0},
			{0,0,0, 0,0,6, 0,7,9},

			{0,0,0, 0,4,0, 7,0,0},
			{0,0,0, 8,0,1, 0,0,0},
			{0,0,9, 0,5,0, 0,0,0},

			{3,1,0, 4,0,0, 0,0,0},
			{0,0,5, 0,0,0, 0,6,0},
			{9,0,6, 0,3,7, 0,0,2},
		};
	/**
	 * Sudoku example - number 34.
	 */
	public static final int[][] PUZZLE_EXAMPLE_034 = {
			{0,0,0, 0,0,0, 0,8,0},
			{8,0,0, 7,0,1, 0,4,0},
			{0,4,0, 0,2,0, 0,3,0},

			{3,7,4, 0,0,0, 9,0,0},
			{0,0,0, 0,3,0, 0,0,0},
			{0,0,5, 0,0,0, 3,2,1},

			{0,1,0, 0,6,0, 0,5,0},
			{0,5,0, 8,0,2, 0,0,6},
			{0,8,0, 0,0,0, 0,0,0},
		};
	/**
	 * Sudoku example - number 35.
	 */
	public static final int[][] PUZZLE_EXAMPLE_035 = {
			{0,0,0, 0,0,0, 0,8,5},
			{0,0,0, 2,1,0, 0,0,9},
			{9,6,0, 0,8,0, 1,0,0},

			{5,0,0, 8,0,0, 0,1,6},
			{0,0,0, 0,0,0, 0,0,0},
			{8,9,0, 0,0,6, 0,0,7},

			{0,0,9, 0,7,0, 0,5,2},
			{3,0,0, 0,5,4, 0,0,0},
			{4,8,0, 0,0,0, 0,0,0},
		};
	/**
	 * Sudoku example - number 36.
	 */
	public static final int[][] PUZZLE_EXAMPLE_036 = {
			{6,0,8, 0,7,0, 5,0,2},
			{0,5,0, 6,0,8, 0,7,0},
			{0,0,2, 0,0,0, 3,0,0},

			{5,0,0, 0,9,0, 0,0,6},
			{0,4,0, 3,0,2, 0,5,0},
			{8,0,0, 0,5,0, 0,0,3},

			{0,0,5, 0,0,0, 2,0,0},
			{0,1,0, 7,0,4, 0,9,0},
			{4,0,9, 0,6,0, 7,0,1},
		};
	/**
	 * Sudoku example - number 37.
	 */
	public static final int[][] PUZZLE_EXAMPLE_037 = {
			{0,5,0, 0,1,0, 0,4,0},
			{1,0,7, 0,0,0, 6,0,2},
			{0,0,0, 9,0,5, 0,0,0},

			{2,0,8, 0,3,0, 5,0,1},
			{0,4,0, 0,7,0, 0,2,0},
			{9,0,1, 0,8,0, 4,0,6},

			{0,0,0, 4,0,1, 0,0,0},
			{3,0,4, 0,0,0, 7,0,9},
			{0,2,0, 0,6,0, 0,1,0},
		};
	/**
	 * Sudoku example - number 38.
	 */
	public static final int[][] PUZZLE_EXAMPLE_038 = {
			{0,5,3, 0,0,0, 7,9,0},
			{0,0,9, 7,5,3, 4,0,0},
			{1,0,0, 0,0,0, 0,0,2},

			{0,9,0, 0,8,0, 0,1,0},
			{0,0,0, 9,0,7, 0,0,0},
			{0,8,0, 0,3,0, 0,7,0},

			{5,0,0, 0,0,0, 0,0,3},
			{0,0,7, 6,4,1, 2,0,0},
			{0,6,1, 0,0,0, 9,4,0},
		};
	/**
	 * Sudoku example - number 39.
	 */
	public static final int[][] PUZZLE_EXAMPLE_039 = {
			{0,0,6, 0,8,0, 3,0,0},
			{0,4,9, 0,7,0, 2,5,0},
			{0,0,0, 4,0,5, 0,0,0},

			{6,0,0, 3,1,7, 0,0,4},
			{0,0,7, 0,0,0, 8,0,0},
			{1,0,0, 8,2,6, 0,0,9},

			{0,0,0, 7,0,2, 0,0,0},
			{0,7,5, 0,4,0, 1,9,0},
			{0,0,3, 0,9,0, 6,0,0},
		};
	/**
	 * Sudoku example - number 40.
	 */
	public static final int[][] PUZZLE_EXAMPLE_040 = {
			{0,0,5, 0,8,0, 7,0,0},
			{7,0,0, 2,0,4, 0,0,5},
			{3,2,0, 0,0,0, 0,8,4},

			{0,6,0, 1,0,5, 0,4,0},
			{0,0,8, 0,0,0, 5,0,0},
			{0,7,0, 8,0,3, 0,1,0},

			{4,5,0, 0,0,0, 0,9,1},
			{6,0,0, 5,0,8, 0,0,7},
			{0,0,3, 0,1,0, 6,0,0},
		};
	/**
	 * Sudoku example - number 41.
	 */
	public static final int[][] PUZZLE_EXAMPLE_041 = {
			{0,0,0, 9,0,0, 8,0,0},
			{1,2,8, 0,0,6, 4,0,0},
			{0,7,0, 8,0,0, 0,6,0},

			{8,0,0, 4,3,0, 0,0,7},
			{5,0,0, 0,0,0, 0,0,9},
			{6,0,0, 0,7,9, 0,0,8},

			{0,9,0, 0,0,4, 0,1,0},
			{0,0,3, 6,0,0, 2,8,4},
			{0,0,1, 0,0,7, 0,0,0},
		};
	/**
	 * Sudoku example - number 42.
	 */
	public static final int[][] PUZZLE_EXAMPLE_042 = {
			{0,0,0, 0,8,0, 0,0,0},
			{2,7,0, 0,0,0, 0,5,4},
			{0,9,5, 0,0,0, 8,1,0},

			{0,0,9, 8,0,6, 4,0,0},
			{0,2,0, 4,0,3, 0,6,0},
			{0,0,6, 9,0,5, 1,0,0},

			{0,1,7, 0,0,0, 6,2,0},
			{4,6,0, 0,0,0, 0,3,8},
			{0,0,0, 0,9,0, 0,0,0},
		};
	/**
	 * Sudoku example - number 43.
	 */
	public static final int[][] PUZZLE_EXAMPLE_043 = {
			{0,0,0, 6,0,2, 0,0,0},
			{4,0,0, 0,5,0, 0,0,1},
			{0,8,5, 0,1,0, 6,2,0},

			{0,3,8, 2,0,6, 7,1,0},
			{0,0,0, 0,0,0, 0,0,0},
			{0,1,9, 4,0,7, 3,5,0},

			{0,2,6, 0,4,0, 5,3,0},
			{9,0,0, 0,2,0, 0,0,7},
			{0,0,0, 8,0,9, 0,0,0},
		};
	/**
	 * Sudoku example - number 44.
	 */
	public static final int[][] PUZZLE_EXAMPLE_044 = {
			{0,0,0, 9,0,0, 0,0,2},
			{0,5,0, 1,2,3, 4,0,0},
			{0,3,0, 0,0,0, 1,6,0},

			{9,0,8, 0,0,0, 0,0,0},
			{0,7,0, 0,0,0, 0,9,0},
			{0,0,0, 0,0,0, 2,0,5},
			{0,9,1, 0,0,0, 0,5,0},

			{0,0,7, 4,3,9, 0,2,0},
			{4,0,0, 0,0,7, 0,0,0},
		};
	/**
	 * Sudoku example - number 45.
	 */
	public static final int[][] PUZZLE_EXAMPLE_045 = {
			{3,8,0, 0,0,0, 0,0,0},
			{0,0,0, 4,0,0, 7,8,5},
			{0,0,9, 0,2,0, 3,0,0},

			{0,6,0, 0,9,0, 0,0,0},
			{8,0,0, 3,0,2, 0,0,9},
			{0,0,0, 0,4,0, 0,7,0},

			{0,0,1, 0,7,0, 5,0,0},
			{4,9,5, 0,0,6, 0,0,0},
			{0,0,0, 0,0,0, 0,9,2},
		};
	/**
	 * Sudoku example - number 46.
	 */
	public static final int[][] PUZZLE_EXAMPLE_046 = {
			{0,0,0, 1,5,8, 0,0,0},
			{0,0,2, 0,6,0, 8,0,0},
			{0,3,0, 0,0,0, 0,4,0},

			{0,2,7, 0,3,0, 5,1,0},
			{0,0,0, 0,0,0, 0,0,0},
			{0,4,6, 0,8,0, 7,9,0},

			{0,5,0, 0,0,0, 0,8,0},
			{0,0,4, 0,7,0, 1,0,0},
			{0,0,0, 3,2,5, 0,0,0},
		};
	/**
	 * Sudoku example - number 47.
	 */
	public static final int[][] PUZZLE_EXAMPLE_047 = {
			{0,1,0, 5,0,0, 2,0,0},
			{9,0,0, 0,0,1, 0,0,0},
			{0,0,2, 0,0,8, 0,3,0},

			{5,0,0, 0,3,0, 0,0,7},
			{0,0,8, 0,0,0, 5,0,0},
			{6,0,0, 0,8,0, 0,0,4},

			{0,4,0, 1,0,0, 7,0,0},
			{0,0,0, 7,0,0, 0,0,6},
			{0,0,3, 0,0,4, 0,5,0},
		};
	/**
	 * Sudoku example - number 48.
	 */
	public static final int[][] PUZZLE_EXAMPLE_048 = {
			{0,8,0, 0,0,0, 0,4,0},
			{0,0,0, 4,6,9, 0,0,0},
			{4,0,0, 0,0,0, 0,0,7},

			{0,0,5, 9,0,4, 6,0,0},
			{0,7,0, 6,0,8, 0,3,0},
			{0,0,8, 5,0,2, 1,0,0},

			{9,0,0, 0,0,0, 0,0,5},
			{0,0,0, 7,8,1, 0,0,0},
			{0,6,0, 0,0,0, 0,1,0},
		};
	/**
	 * Sudoku example - number 49.
	 */
	public static final int[][] PUZZLE_EXAMPLE_049 = {
			{9,0,4, 2,0,0, 0,0,7},
			{0,1,0, 0,0,0, 0,0,0},
			{0,0,0, 7,0,6, 5,0,0},

			{0,0,0, 8,0,0, 0,9,0},
			{0,2,0, 9,0,4, 0,6,0},
			{0,4,0, 0,0,2, 0,0,0},

			{0,0,1, 6,0,7, 0,0,0},
			{0,0,0, 0,0,0, 0,3,0},
			{3,0,0, 0,0,5, 7,0,2},
		};
	/**
	 * Sudoku example - number 50.
	 */
	public static final int[][] PUZZLE_EXAMPLE_050 = {
			{0,0,0, 7,0,0, 8,0,0},
			{0,0,6, 0,0,0, 0,3,1},
			{0,4,0, 0,0,2, 0,0,0},

			{0,2,4, 0,7,0, 0,0,0},
			{0,1,0, 0,3,0, 0,8,0},
			{0,0,0, 0,6,0, 2,9,0},

			{0,0,0, 8,0,0, 0,7,0},
			{8,6,0, 0,0,0, 5,0,0},
			{0,0,2, 0,0,6, 0,0,0},
		};
	/**
	 * Sudoku example - number 51.
	 */
	public static final int[][] PUZZLE_EXAMPLE_051 = {
			{0,0,1, 0,0,7, 0,9,0},
			{5,9,0, 0,8,0, 0,0,1},
			{0,3,0, 0,0,0, 0,8,0},

			{0,0,0, 0,0,5, 8,0,0},
			{0,5,0, 0,6,0, 0,2,0},
			{0,0,4, 1,0,0, 0,0,0},

			{0,8,0, 0,0,0, 0,3,0},
			{1,0,0, 0,2,0, 0,7,9},
			{0,2,0, 7,0,0, 4,0,0},
		};
	/**
	 * Sudoku example - number 52.
	 */
	public static final int[][] PUZZLE_EXAMPLE_052 = {
			{0,0,0, 0,0,3, 0,1,7},
			{0,1,5, 0,0,9, 0,0,8},
			{0,6,0, 0,0,0, 0,0,0},

			{1,0,0, 0,0,7, 0,0,0},
			{0,0,9, 0,0,0, 2,0,0},
			{0,0,0, 5,0,0, 0,0,4},

			{0,0,0, 0,0,0, 0,2,0},
			{5,0,0, 6,0,0, 3,4,0},
			{3,4,0, 2,0,0, 0,0,0},
		};
	/**
	 * Sudoku example - number 53.
	 */
	public static final int[][] PUZZLE_EXAMPLE_053 = {
			{3,0,0, 2,0,0, 0,0,0},
			{0,0,0, 1,0,7, 0,0,0},
			{7,0,6, 0,3,0, 5,0,0},

			{0,7,0, 0,0,9, 0,8,0},
			{9,0,0, 0,2,0, 0,0,4},
			{0,1,0, 8,0,0, 0,5,0},

			{0,0,9, 0,4,0, 3,0,1},
			{0,0,0, 7,0,2, 0,0,0},
			{0,0,0, 0,0,8, 0,0,6},
		};
	/**
	 * Sudoku example - number 54.
	 */
	public static final int[][] PUZZLE_EXAMPLE_054 = {
			{0,0,0, 0,0,6, 1,0,0},
			{0,0,0, 0,9,1, 6,0,8},
			{7,0,0, 0,0,0, 0,0,0},

			{0,0,0, 0,0,0, 0,0,2},
			{3,7,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,4, 0,0,6},

			{0,0,0, 7,3,0, 0,0,0},
			{0,8,1, 0,0,0, 0,0,0},
			{0,0,0, 5,0,0, 0,0,0},
		};
	/**
	 * Sudoku example - number 55.
	 */
	public static final int[][] PUZZLE_EXAMPLE_055 = {
			{0,0,8, 0,0,0, 0,3,2},
			{0,0,0, 0,6,1, 0,0,0},
			{0,0,5, 0,0,0, 0,0,0},

			{6,0,0, 0,0,3, 0,0,0},
			{1,0,0, 0,0,0, 0,0,7},
			{0,0,0, 2,0,0, 0,0,8},

			{0,0,0, 0,0,0, 6,0,0},
			{0,0,0, 8,2,0, 0,0,0},
			{5,3,0, 0,0,0, 9,0,0},
		};
	/**
	 * Sudoku example - number 56.
	 */
	public static final int[][] PUZZLE_EXAMPLE_056 = {
			{0,0,2, 8,0,9, 0,0,0},
			{0,9,0, 0,3,0, 4,0,0},
			{5,0,0, 0,0,0, 0,0,3},

			{9,0,0, 0,5,0, 0,0,4},
			{0,2,0, 0,0,0, 6,5,0},
			{0,0,0, 1,0,7, 0,2,0},

			{0,0,0, 7,0,0, 5,0,0},
			{3,0,0, 0,0,8, 0,0,0},
			{0,0,7, 4,0,0, 0,9,6}
		};
	/**
	 * Sudoku example - number 57.
	 */
	public static final int[][] PUZZLE_EXAMPLE_057 = {
			{0,0,0, 1,9,6, 3,0,0},
			{0,0,0, 0,0,0, 2,0,8},
			{7,0,0, 0,4,0, 0,6,0},

			{0,6,0, 0,0,7, 0,2,1},
			{0,0,0, 0,0,0, 0,0,0},
			{9,1,0, 8,0,0, 0,3,0},

			{0,8,0, 0,2,0, 0,0,3},
			{6,0,5, 0,0,0, 0,0,0},
			{0,0,3, 7,8,4, 0,0,0},
		};
	/**
	 * Sudoku example - number 58.
	 */
	public static final int[][] PUZZLE_EXAMPLE_058 = {
			{0,0,7, 0,0,0, 4,0,9},
			{0,0,6, 9,0,5, 2,0,0},
			{8,0,0, 0,7,0, 0,0,0},

			{0,3,0, 0,0,8, 0,6,0},
			{1,0,0, 0,6,0, 0,0,5},
			{7,0,0, 2,0,0, 0,8,0},

			{0,0,0, 0,9,0, 0,0,2},
			{0,0,1, 8,0,6, 5,0,0},
			{5,0,9, 0,0,0, 3,0,0},
		};
	/**
	 * Sudoku example - number 59.
	 */
	public static final int[][] PUZZLE_EXAMPLE_059 = {
			{0,0,0, 0,0,7, 2,0,5},
			{0,8,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,4,6},

			{0,0,9, 4,0,0, 0,0,1},
			{0,3,0, 0,0,0, 0,6,0},
			{0,0,0, 6,0,1, 7,0,0},

			{2,0,8, 0,0,5, 0,0,7},
			{0,9,0, 0,4,0, 0,2,0},
			{0,0,4, 0,0,0, 5,0,0}
		};
	/**
	 * Sudoku example - number 60.
	 */
	public static final int[][] PUZZLE_EXAMPLE_060 = {
			{0,0,1, 6,8,0, 0,0,0},
			{0,0,3, 0,0,0, 0,1,0},
			{0,0,8, 0,1,0, 5,9,0},

			{0,0,0, 8,6,0, 0,0,0},
			{0,1,0, 0,0,0, 0,7,8},
			{0,4,0, 0,0,0, 9,0,0},

			{9,0,4, 0,0,0, 0,0,2},
			{0,0,0, 7,0,8, 0,0,0},
			{3,0,0, 0,0,9, 0,0,7}
	};
	/**
	 * Sudoku example - number 61.
	 */
	public static final int[][] PUZZLE_EXAMPLE_061 = {
			{0,0,0, 7,0,0, 8,0,0},
			{0,6,0, 0,1,0, 0,0,0},
			{0,0,2, 0,0,0, 3,4,0},

			{9,0,0, 0,0,4, 0,7,0},
			{0,0,0, 5,0,2, 0,0,0},
			{4,0,0, 0,0,0, 0,0,1},

			{0,9,0, 0,0,0, 7,0,5},
			{0,8,5, 0,2,0, 0,0,0},
			{0,0,0, 0,0,7, 0,0,3}
	};
	/**
	 * Sudoku example - number 62.
	 */
	public static final int[][] PUZZLE_EXAMPLE_062 = {
			{4,0,0, 0,0,0, 0,0,0},
			{0,0,0, 3,4,0, 2,0,0},
			{6,8,0, 0,0,0, 7,0,0},

			{0,0,0, 6,5,4, 0,0,0},
			{0,0,0, 0,0,3, 0,8,5},
			{0,0,2, 0,0,0, 0,3,6},

			{0,0,0, 5,7,1, 0,0,0},
			{0,0,8, 0,0,0, 0,0,0},
			{0,0,6, 0,0,0, 0,1,7}
	};
	/**
	 * Sudoku example - number 63.
	 */
	public static final int[][] PUZZLE_EXAMPLE_063 = {
			{9,0,0, 0,0,1, 0,0,0},
			{0,0,0, 0,0,0, 0,3,7},
			{4,2,0, 9,0,0, 0,0,0},

			{0,0,0, 0,9,0, 3,0,0},
			{0,6,0, 8,1,0, 0,0,0},
			{1,0,0, 0,0,0, 0,5,0},

			{5,0,1, 0,0,0, 0,0,0},
			{0,0,4, 0,0,0, 6,0,0},
			{0,0,0, 0,5,3, 0,1,2}
	};
	/**
	 * Sudoku example - number 64.
	 */
	public static final int[][] PUZZLE_EXAMPLE_064 = {
			{0,0,0, 0,0,0, 1,7,0},
			{5,3,6, 0,0,0, 0,0,0},
			{0,0,0, 4,0,2, 0,0,0},

			{0,0,0, 0,9,0, 0,0,6},
			{0,0,9, 0,4,1, 0,0,0},
			{0,5,2, 0,0,0, 0,0,0},

			{0,4,0, 8,0,0, 0,0,0},
			{7,0,0, 0,5,0, 0,0,9},
			{0,0,0, 0,0,0, 2,8,7}
	};
	/**
	 * Sudoku example - number 65.
	 */
	public static final int[][] PUZZLE_EXAMPLE_065 = {
			{7,0,0, 0,9,0, 0,1,0},
			{0,3,6, 0,0,0, 0,7,0},
			{0,0,0, 6,4,0, 0,3,0},

			{0,0,0, 0,0,0, 0,0,3},
			{0,9,0, 3,0,8, 0,0,0},
			{0,6,0, 0,0,0, 2,0,4},

			{6,0,7, 0,0,0, 8,0,0},
			{0,0,0, 0,0,9, 0,0,0},
			{0,0,2, 0,7,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 66.
	 */
	public static final int[][] PUZZLE_EXAMPLE_066 = {
			{0,1,0, 0,0,6, 0,0,0},
			{0,0,0, 0,0,3, 0,8,0},
			{0,6,7, 0,0,0, 0,1,0},

			{3,0,1, 0,0,0, 0,0,5},
			{0,0,6, 0,0,2, 0,0,0},
			{0,0,0, 4,0,0, 1,0,3},

			{0,0,0, 0,6,0, 5,4,0},
			{2,0,0, 5,0,0, 0,0,0},
			{0,7,0, 0,0,0, 0,0,2}
	};
	/**
	 * Sudoku example - number 67.
	 */
	public static final int[][] PUZZLE_EXAMPLE_067 = {
			{0,0,0, 0,0,0, 8,0,0},
			{0,0,0, 0,0,0, 7,2,0},
			{3,6,0, 0,0,8, 0,0,0},

			{5,0,0, 8,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,5,8},
			{0,0,7, 2,9,0, 0,0,0},

			{0,4,0, 1,3,0, 0,0,7},
			{0,9,0, 0,4,0, 0,0,5},
			{0,0,1, 0,0,0, 0,6,0}
	};
	/**
	 * Sudoku example - number 68.
	 */
	public static final int[][] PUZZLE_EXAMPLE_068 = {
			{0,0,0, 2,0,0, 0,0,0},
			{4,0,0, 0,0,0, 0,0,0},
			{5,8,0, 7,3,0, 0,0,0},

			{9,0,7, 0,0,2, 0,0,0},
			{0,0,0, 0,0,0, 3,0,0},
			{0,0,0, 0,1,0, 8,0,9},

			{0,1,0, 0,0,0, 0,7,5},
			{0,0,2, 0,0,1, 0,9,0},
			{0,5,0, 0,0,9, 0,0,3}
	};
	/**
	 * Sudoku example - number 69.
	 */
	public static final int[][] PUZZLE_EXAMPLE_069 = {
			{9,0,0, 0,0,1, 0,0,0},
			{0,0,0, 0,0,0, 0,3,7},
			{4,2,0, 9,0,0, 0,0,0},

			{0,0,0, 0,9,0, 3,0,0},
			{0,6,0, 8,1,0, 0,0,0},
			{1,0,0, 0,0,0, 0,5,0},

			{5,0,1, 0,0,0, 0,0,0},
			{0,0,4, 0,0,0, 6,0,0},
			{0,0,0, 0,5,3, 0,1,2}
	};
	/**
	 * Sudoku example - number 70.
	 */
	public static final int[][] PUZZLE_EXAMPLE_070 = {
			{0,9,0, 0,0,0, 0,4,0},
			{0,0,0, 2,0,0, 8,0,0},
			{0,4,0, 6,5,0, 0,0,0},

			{6,0,0, 0,0,0, 0,5,0},
			{0,0,0, 0,1,0, 0,3,8},
			{3,0,0, 0,0,2, 0,0,0},

			{0,0,0, 5,0,9, 0,0,2},
			{2,0,3, 0,0,0, 0,0,7},
			{0,0,1, 0,0,0, 0,0,4}
	};
	/**
	 * Sudoku example - number 71.
	 */
	public static final int[][] PUZZLE_EXAMPLE_071 = {
			{2,0,0, 0,9,0, 0,0,0},
			{0,0,9, 0,0,0, 0,4,1},
			{3,0,0, 0,0,0, 0,8,0},

			{0,1,0, 4,0,0, 0,0,0},
			{0,0,0, 3,0,0, 7,6,0},
			{0,0,5, 0,0,0, 0,0,0},

			{0,0,0, 0,2,0, 8,0,5},
			{0,0,0, 0,8,5, 0,0,7},
			{6,0,0, 0,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 72.
	 */
	public static final int[][] PUZZLE_EXAMPLE_072 = {
			{9,0,0, 5,0,0, 6,0,0},
			{0,6,0, 3,0,0, 0,0,0},
			{0,0,0, 0,8,0, 4,0,0},

			{2,0,0, 0,0,6, 0,3,0},
			{8,0,0, 0,2,3, 0,0,0},
			{0,0,0, 0,0,0, 0,0,7},

			{0,0,9, 0,5,4, 0,0,0},
			{0,0,7, 0,0,0, 0,9,4},
			{0,0,5, 0,0,0, 0,7,0}
	};
	/**
	 * Sudoku example - number 73.
	 */
	public static final int[][] PUZZLE_EXAMPLE_073 = {
			{0,0,0, 0,0,8, 0,0,2},
			{0,0,3, 0,0,0, 0,0,5},
			{7,0,0, 0,9,0, 0,0,0},

			{0,0,0, 3,0,4, 1,0,0},
			{8,2,1, 0,0,0, 0,0,0},
			{0,0,0, 0,8,0, 5,0,0},

			{0,0,0, 0,7,0, 0,9,0},
			{0,4,0, 6,0,0, 0,0,0},
			{6,9,0, 0,0,0, 0,7,4}
	};
	/**
	 * Sudoku example - number 74.
	 */
	public static final int[][] PUZZLE_EXAMPLE_074 = {
			{0,2,0, 0,0,9, 0,0,0},
			{7,0,0, 0,0,0, 0,0,2},
			{0,0,0, 0,1,0, 0,7,6},

			{0,1,8, 0,0,0, 0,0,0},
			{0,0,6, 0,0,8, 0,5,0},
			{0,0,0, 0,7,0, 8,2,0},

			{0,0,0, 2,0,0, 0,0,0},
			{4,0,1, 3,0,0, 0,0,0},
			{0,0,0, 0,0,0, 3,9,4}
	};
	/**
	 * Sudoku example - number 75.
	 */
	public static final int[][] PUZZLE_EXAMPLE_075 = {
			{0,0,0, 9,0,2, 1,0,0},
			{0,0,6, 4,0,0, 0,0,0},
			{0,0,1, 0,0,0, 9,0,4},

			{0,0,0, 0,5,0, 0,4,0},
			{6,1,0, 0,0,0, 0,0,0},
			{0,0,0, 0,6,4, 8,0,0},

			{0,0,0, 7,0,8, 0,0,0},
			{9,7,0, 0,0,0, 0,0,3},
			{2,0,0, 0,0,0, 0,5,0}
	};
	/**
	 * Sudoku example - number 76.
	 */
	public static final int[][] PUZZLE_EXAMPLE_076 = {
			{0,0,0, 0,8,1, 0,0,0},
			{0,0,0, 0,9,0, 0,6,0},
			{0,0,5, 0,2,0, 0,3,0},

			{3,0,0, 0,0,0, 0,0,7},
			{0,0,0, 8,0,0, 0,0,9},
			{0,7,6, 0,0,0, 0,0,4},

			{0,1,0, 0,0,4, 9,0,0},
			{4,0,7, 0,0,0, 1,0,0},
			{0,0,0, 1,0,9, 0,0,0}
	};
	/**
	 * Sudoku example - number 77.
	 */
	public static final int[][] PUZZLE_EXAMPLE_077 = {
			{5,0,0, 3,0,0, 0,0,0},
			{0,0,0, 0,5,0, 0,0,7},
			{2,0,8, 0,0,0, 0,0,0},

			{0,5,0, 0,0,0, 0,0,9},
			{0,4,0, 7,0,6, 0,0,0},
			{0,0,0, 2,0,0, 8,0,6},

			{0,0,4, 0,0,2, 0,9,0},
			{0,9,0, 0,0,1, 0,2,0},
			{0,0,0, 0,0,0, 1,3,0}
	};
	/**
	 * Sudoku example - number 78.
	 */
	public static final int[][] PUZZLE_EXAMPLE_078 = {
			{0,2,0, 0,0,5, 0,0,0},
			{0,9,0, 0,0,0, 0,1,0},
			{0,0,0, 7,0,0, 0,4,0},

			{0,0,0, 8,0,0, 1,0,0},
			{0,0,0, 9,2,0, 7,0,0},
			{1,0,5, 0,0,0, 0,0,0},

			{9,0,0, 0,7,0, 0,0,0},
			{0,0,0, 6,0,9, 0,0,2},
			{6,0,4, 0,0,0, 0,0,8}
	};
	/**
	 * Sudoku example - number 79.
	 */
	public static final int[][] PUZZLE_EXAMPLE_079 = {
			{0,3,5, 0,0,0, 0,0,0},
			{0,0,0, 0,7,0, 0,5,3},
			{0,4,0, 2,0,0, 0,0,0},

			{0,0,0, 0,0,5, 0,0,4},
			{1,0,0, 0,0,0, 3,0,0},
			{0,0,2, 0,8,0, 0,0,0},

			{3,0,0, 0,0,0, 7,0,0},
			{0,0,0, 0,0,0, 4,2,8},
			{0,0,0, 9,1,7, 0,0,0}
	};
	/**
	 * Sudoku example - number 80.
	 */
	public static final int[][] PUZZLE_EXAMPLE_080 = {
			{0,9,8, 0,0,0, 0,0,6},
			{0,0,0, 0,0,0, 8,0,0},
			{0,0,0, 3,4,0, 0,0,0},

			{0,0,0, 0,1,0, 4,2,0},
			{0,1,0, 6,0,0, 0,0,0},
			{5,0,0, 0,0,0, 0,3,0},

			{7,2,9, 0,0,0, 0,0,0},
			{6,0,0, 0,0,7, 0,0,0},
			{0,0,0, 8,0,5, 0,0,2}
	};
	/**
	 * Sudoku example - number 81.
	 */
	public static final int[][] PUZZLE_EXAMPLE_081 = {
			{0,0,0, 1,7,8, 0,0,0},
			{2,0,9, 0,0,0, 0,8,0},
			{0,0,0, 0,0,0, 5,0,0},

			{0,3,0, 8,0,0, 0,0,0},
			{1,0,0, 0,0,0, 9,0,6},
			{0,0,0, 0,9,0, 0,0,5},

			{0,0,0, 5,0,7, 0,0,8},
			{0,4,7, 0,0,6, 0,0,0},
			{0,0,8, 0,0,1, 0,0,0}
	};
	/**
	 * Sudoku example - number 82.
	 */
	public static final int[][] PUZZLE_EXAMPLE_082 = {
			{0,0,0, 0,0,8, 0,0,0},
			{2,3,0, 0,0,0, 0,0,0},
			{0,0,0, 0,6,0, 5,0,7},

			{0,4,0, 9,0,0, 8,0,0},
			{0,1,5, 0,0,0, 0,0,0},
			{0,0,0, 0,5,0, 7,6,0},

			{0,0,0, 0,0,0, 9,4,1},
			{0,0,0, 4,0,9, 0,0,0},
			{6,0,0, 0,0,1, 0,0,0}
	};
	/**
	 * Sudoku example - number 83.
	 */
	public static final int[][] PUZZLE_EXAMPLE_083 = {
			{0,0,4, 0,0,6, 0,7,0},
			{0,0,0, 0,0,0, 0,8,9},
			{0,0,7, 8,0,9, 0,0,0},

			{9,0,0, 2,0,0, 5,0,0},
			{7,0,0, 0,0,0, 0,9,0},
			{0,2,0, 4,0,0, 0,0,0},

			{0,0,0, 0,0,0, 6,0,8},
			{0,6,0, 0,3,0, 0,0,0},
			{0,0,5, 0,2,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 84.
	 */
	public static final int[][] PUZZLE_EXAMPLE_084 = {
			{3,0,0, 0,0,0, 0,0,9},
			{0,0,0, 0,6,0, 5,0,0},
			{0,7,0, 3,0,0, 0,0,0},

			{0,6,7, 0,1,0, 0,0,0},
			{0,0,0, 0,0,7, 6,5,0},
			{0,0,3, 0,0,0, 1,0,0},

			{1,0,2, 0,0,0, 0,0,0},
			{0,0,0, 9,0,2, 0,0,3},
			{0,0,0, 8,0,0, 0,0,5}
	};
	/**
	 * Sudoku example - number 85.
	 */
	public static final int[][] PUZZLE_EXAMPLE_085 = {
			{0,0,0, 0,0,0, 9,2,7},
			{3,0,0, 0,0,1, 0,0,0},
			{0,6,9, 0,0,0, 0,0,0},

			{0,0,0, 1,4,0, 0,0,0},
			{0,8,0, 0,0,0, 0,6,9},
			{0,0,0, 5,0,0, 0,4,0},

			{0,0,0, 0,1,0, 6,0,0},
			{5,0,3, 0,6,4, 0,0,0},
			{8,0,0, 0,0,0, 0,0,3}
	};
	/**
	 * Sudoku example - number 86.
	 */
	public static final int[][] PUZZLE_EXAMPLE_086 = {
			{0,0,0, 5,0,0, 0,0,0},
			{1,0,0, 0,0,4, 0,0,6},
			{0,3,9, 0,0,0, 0,0,0},

			{0,8,0, 0,1,0, 0,2,0},
			{4,5,0, 0,8,0, 0,0,0},
			{0,0,0, 0,5,0, 3,8,0},

			{0,9,0, 6,0,0, 0,0,0},
			{0,0,5, 0,0,0, 9,1,0},
			{0,0,0, 0,0,7, 2,0,0}
	};
	/**
	 * Sudoku example - number 87.
	 */
	public static final int[][] PUZZLE_EXAMPLE_087 = {
			{5,0,0, 0,0,4, 0,0,9},
			{0,0,0, 0,8,9, 0,0,5},
			{4,0,6, 0,0,0, 0,0,0},

			{0,0,0, 0,1,0, 0,4,0},
			{0,5,0, 0,0,0, 7,0,0},
			{0,3,0, 8,4,0, 0,0,0},

			{0,0,9, 1,2,0, 0,0,0},
			{0,8,0, 9,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,1,6}
	};
	/**
	 * Sudoku example - number 88.
	 */
	public static final int[][] PUZZLE_EXAMPLE_088 = {
			{5,0,6, 0,0,0, 0,0,0},
			{0,0,0, 3,0,1, 0,0,0},
			{0,0,0, 0,0,0, 4,9,0},

			{0,9,8, 0,1,0, 0,0,0},
			{0,0,0, 0,8,0, 0,0,4},
			{0,0,0, 0,4,0, 0,6,7},

			{0,7,0, 0,0,8, 6,0,0},
			{0,0,0, 0,0,0, 0,8,0},
			{0,2,0, 5,0,9, 0,0,0}
	};
	/**
	 * Sudoku example - number 89.
	 */
	public static final int[][] PUZZLE_EXAMPLE_089 = {
			{0,0,0, 0,0,5, 1,6,0},
			{0,9,0, 0,0,0, 4,0,0},
			{0,7,0, 0,8,0, 0,0,0},

			{0,0,0, 0,7,0, 0,0,8},
			{2,0,9, 0,0,1, 0,0,0},
			{0,0,4, 0,0,0, 0,0,6},

			{0,0,6, 9,0,0, 0,4,0},
			{0,0,0, 0,0,0, 0,5,0},
			{0,0,8, 4,0,2, 0,0,0}
	};
	/**
	 * Sudoku example - number 90.
	 */
	public static final int[][] PUZZLE_EXAMPLE_090 = {
			{0,2,0, 0,0,9, 0,0,0},
			{7,0,0, 0,0,0, 0,0,2},
			{0,0,0, 0,1,0, 0,7,6},

			{0,1,8, 0,0,0, 0,0,0},
			{0,0,6, 0,0,8, 0,5,0},
			{0,0,0, 0,7,0, 8,2,0},

			{0,0,0, 2,0,0, 0,0,0},
			{4,0,1, 3,0,0, 0,0,0},
			{0,0,0, 0,0,0, 3,9,4}
	};
	/**
	 * Sudoku example - number 91.
	 */
	public static final int[][] PUZZLE_EXAMPLE_091 = {
			{1,8,0, 0,0,2, 0,0,0},
			{0,0,6, 0,0,0, 7,0,0},
			{0,0,0, 0,0,0, 3,0,1},

			{5,3,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,9, 0,2,4},
			{0,0,0, 0,0,8, 0,0,0},

			{0,0,0, 1,0,0, 0,5,0},
			{8,0,2, 0,0,0, 0,6,0},
			{0,4,0, 0,5,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 92.
	 */
	public static final int[][] PUZZLE_EXAMPLE_092 = {
			{0,1,8, 0,0,6, 0,0,0},
			{0,0,5, 0,0,0, 8,4,0},
			{0,0,6, 0,0,5, 0,9,0},

			{3,9,0, 0,0,0, 0,0,8},
			{0,0,0, 0,5,0, 7,0,0},
			{0,0,0, 3,0,7, 0,0,0},

			{6,0,0, 9,0,0, 0,0,0},
			{0,0,0, 0,8,0, 0,0,0},
			{0,0,0, 0,0,0, 2,8,4}
	};
	/**
	 * Sudoku example - number 93.
	 */
	public static final int[][] PUZZLE_EXAMPLE_093 = {
			{8,0,0, 0,0,6, 0,9,4},
			{5,0,0, 0,0,0, 0,8,2},
			{4,0,0, 7,0,0, 0,0,0},

			{0,0,6, 0,0,0, 2,3,0},
			{0,0,2, 0,7,0, 0,0,0},
			{0,0,0, 3,0,0, 0,0,0},

			{0,7,0, 0,0,2, 0,0,0},
			{0,0,0, 0,5,0, 6,0,8},
			{0,9,0, 0,3,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 94.
	 */
	public static final int[][] PUZZLE_EXAMPLE_094 = {
			{0,1,0, 0,0,0, 0,0,2},
			{0,5,2, 0,3,0, 0,0,0},
			{0,0,0, 1,0,0, 5,0,0},

			{7,0,0, 0,0,0, 4,1,0},
			{8,0,0, 0,0,0, 0,9,0},
			{0,0,0, 0,2,8, 0,0,0},

			{0,0,0, 0,9,4, 0,7,0},
			{0,0,0, 0,0,0, 6,0,0},
			{4,6,9, 0,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 95.
	 */
	public static final int[][] PUZZLE_EXAMPLE_095 = {
			{0,0,0, 0,0,0, 5,2,0},
			{0,0,5, 6,4,0, 0,0,0},
			{0,0,4, 0,0,0, 0,1,0},

			{0,1,0, 0,0,0, 3,0,0},
			{0,0,0, 5,9,0, 0,0,1},
			{0,9,6, 0,0,0, 0,0,0},

			{0,2,0, 0,0,8, 0,7,0},
			{6,0,0, 0,0,0, 0,0,0},
			{3,0,0, 0,0,1, 0,0,5}
	};
	/**
	 * Sudoku example - number 96.
	 */
	public static final int[][] PUZZLE_EXAMPLE_096 = {
			{0,3,0, 0,0,0, 9,0,0},
			{0,0,0, 0,2,4, 6,0,0},
			{8,1,0, 0,0,0, 2,0,0},

			{0,0,0, 7,3,0, 0,0,5},
			{3,0,0, 0,6,0, 0,1,0},
			{0,0,0, 0,0,0, 0,6,0},

			{0,0,8, 4,0,0, 0,0,0},
			{0,0,6, 0,0,0, 0,4,7},
			{0,0,0, 2,0,1, 0,0,0}
	};
	/**
	 * Sudoku example - number 97.
	 */
	public static final int[][] PUZZLE_EXAMPLE_097 = {
			{0,8,0, 7,0,0, 0,0,1},
			{0,9,0, 0,0,0, 0,3,6},
			{0,0,0, 3,0,9, 0,0,0},

			{0,0,1, 0,4,0, 0,0,0},
			{0,2,0, 0,1,0, 0,0,7},
			{0,0,7, 0,0,0, 8,0,0},

			{1,0,0, 0,0,0, 2,4,0},
			{4,0,0, 0,0,0, 0,0,0},
			{8,0,0, 6,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 98.
	 */
	public static final int[][] PUZZLE_EXAMPLE_098 = {
			{0,0,0, 9,0,2, 1,0,0},
			{0,0,6, 4,0,0, 0,0,0},
			{0,0,1, 0,0,0, 9,0,4},

			{0,0,0, 0,5,0, 0,4,0},
			{6,1,0, 0,0,0, 0,0,0},
			{0,0,0, 0,6,4, 8,0,0},

			{0,0,0, 7,0,8, 0,0,0},
			{9,7,0, 0,0,0, 0,0,3},
			{2,0,0, 0,0,0, 0,5,0}
	};
	/**
	 * Sudoku example - number 99.
	 */
	public static final int[][] PUZZLE_EXAMPLE_099 = {
			{0,0,0, 0,8,1, 0,0,0},
			{0,0,0, 0,9,0, 0,6,0},
			{0,0,5, 0,2,0, 0,3,0},

			{3,0,0, 0,0,0, 0,0,7},
			{0,0,0, 8,0,0, 0,0,9},
			{0,7,6, 0,0,0, 0,0,4},

			{0,1,0, 0,0,4, 9,0,0},
			{4,0,7, 0,0,0, 1,0,0},
			{0,0,0, 1,0,9, 0,0,0}
	};
	/**
	 * Sudoku example - number 100.
	 */
	public static final int[][] PUZZLE_EXAMPLE_100 = {
			{5,0,0, 3,0,0, 0,0,0},
			{0,0,0, 0,5,0, 0,0,7},
			{2,0,8, 0,0,0, 0,0,0},

			{0,5,0, 0,0,0, 0,0,9},
			{0,4,0, 7,0,6, 0,0,0},
			{0,0,0, 2,0,0, 8,0,6},

			{0,0,4, 0,0,2, 0,9,0},
			{0,9,0, 0,0,1, 0,2,0},
			{0,0,0, 0,0,0, 1,3,0}
	};
	/**
	 * Sudoku example - number 101.
	 */
	public static final int[][] PUZZLE_EXAMPLE_101 = {
			{0,2,0, 0,0,5, 0,0,0},
			{0,9,0, 0,0,0, 0,1,0},
			{0,0,0, 7,0,0, 0,4,0},

			{0,0,0, 8,0,0, 1,0,0},
			{0,0,0, 9,2,0, 7,0,0},
			{1,0,5, 0,0,0, 0,0,0},

			{9,0,0, 0,7,0, 0,0,0},
			{0,0,0, 6,0,9, 0,0,2},
			{6,0,4, 0,0,0, 0,0,8}
	};
	/**
	 * Sudoku example - number 102.
	 */
	public static final int[][] PUZZLE_EXAMPLE_102 = {
			{0,3,5, 0,0,0, 0,0,0},
			{0,0,0, 0,7,0, 0,5,3},
			{0,4,0, 2,0,0, 0,0,0},

			{0,0,0, 0,0,5, 0,0,4},
			{1,0,0, 0,0,0, 3,0,0},
			{0,0,2, 0,8,0, 0,0,0},

			{3,0,0, 0,0,0, 7,0,0},
			{0,0,0, 0,0,0, 4,2,8},
			{0,0,0, 9,1,7, 0,0,0}
	};
	/**
	 * Sudoku example - number 103.
	 */
	public static final int[][] PUZZLE_EXAMPLE_103 = {
			{0,9,8, 0,0,0, 0,0,6},
			{0,0,0, 0,0,0, 8,0,0},
			{0,0,0, 3,4,0, 0,0,0},

			{0,0,0, 0,1,0, 4,2,0},
			{0,1,0, 6,0,0, 0,0,0},
			{5,0,0, 0,0,0, 0,3,0},

			{7,2,9, 0,0,0, 0,0,0},
			{6,0,0, 0,0,7, 0,0,0},
			{0,0,0, 8,0,5, 0,0,2}
	};
	/**
	 * Sudoku example - number 104.
	 */
	public static final int[][] PUZZLE_EXAMPLE_104 = {
			{0,0,0, 1,7,8, 0,0,0},
			{2,0,9, 0,0,0, 0,8,0},
			{0,0,0, 0,0,0, 5,0,0},

			{0,3,0, 8,0,0, 0,0,0},
			{1,0,0, 0,0,0, 9,0,6},
			{0,0,0, 0,9,0, 0,0,5},

			{0,0,0, 5,0,7, 0,0,8},
			{0,4,7, 0,0,6, 0,0,0},
			{0,0,8, 0,0,1, 0,0,0}
	};
	/**
	 * Sudoku example - number 105.
	 */
	public static final int[][] PUZZLE_EXAMPLE_105 = {
			{0,0,0, 0,0,8, 0,0,0},
			{2,3,0, 0,0,0, 0,0,0},
			{0,0,0, 0,6,0, 5,0,7},

			{0,4,0, 9,0,0, 8,0,0},
			{0,1,5, 0,0,0, 0,0,0},
			{0,0,0, 0,5,0, 7,6,0},

			{0,0,0, 0,0,0, 9,4,1},
			{0,0,0, 4,0,9, 0,0,0},
			{6,0,0, 0,0,1, 0,0,0}
	};
	/**
	 * Sudoku example - number 106.
	 */
	public static final int[][] PUZZLE_EXAMPLE_106 = {
			{0,0,4, 0,0,6, 0,7,0},
			{0,0,0, 0,0,0, 0,8,9},
			{0,0,7, 8,0,9, 0,0,0},

			{9,0,0, 2,0,0, 5,0,0},
			{7,0,0, 0,0,0, 0,9,0},
			{0,2,0, 4,0,0, 0,0,0},

			{0,0,0, 0,0,0, 6,0,8},
			{0,6,0, 0,3,0, 0,0,0},
			{0,0,5, 0,2,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 107.
	 */
	public static final int[][] PUZZLE_EXAMPLE_107 = {
			{3,0,0, 0,0,0, 0,0,9},
			{0,0,0, 0,6,0, 5,0,0},
			{0,7,0, 3,0,0, 0,0,0},

			{0,6,7, 0,1,0, 0,0,0},
			{0,0,0, 0,0,7, 6,5,0},
			{0,0,3, 0,0,0, 1,0,0},

			{1,0,2, 0,0,0, 0,0,0},
			{0,0,0, 9,0,2, 0,0,3},
			{0,0,0, 8,0,0, 0,0,5}
	};
	/**
	 * Sudoku example - number 108.
	 */
	public static final int[][] PUZZLE_EXAMPLE_108 = {
			{0,0,0, 0,0,0, 9,2,7},
			{3,0,0, 0,0,1, 0,0,0},
			{0,6,9, 0,0,0, 0,0,0},

			{0,0,0, 1,4,0, 0,0,0},
			{0,8,0, 0,0,0, 0,6,9},
			{0,0,0, 5,0,0, 0,4,0},

			{0,0,0, 0,1,0, 6,0,0},
			{5,0,3, 0,6,4, 0,0,0},
			{8,0,0, 0,0,0, 0,0,3}
	};
	/**
	 * Sudoku example - number 109.
	 */
	public static final int[][] PUZZLE_EXAMPLE_109 = {
			{0,0,0, 5,0,0, 0,0,0},
			{1,0,0, 0,0,4, 0,0,6},
			{0,3,9, 0,0,0, 0,0,0},

			{0,8,0, 0,1,0, 0,2,0},
			{4,5,0, 0,8,0, 0,0,0},
			{0,0,0, 0,5,0, 3,8,0},

			{0,9,0, 6,0,0, 0,0,0},
			{0,0,5, 0,0,0, 9,1,0},
			{0,0,0, 0,0,7, 2,0,0}
	};
	/**
	 * Sudoku example - number 110.
	 */
	public static final int[][] PUZZLE_EXAMPLE_110 = {
			{5,0,0, 0,0,4, 0,0,9},
			{0,0,0, 0,8,9, 0,0,5},
			{4,0,6, 0,0,0, 0,0,0},

			{0,0,0, 0,1,0, 0,4,0},
			{0,5,0, 0,0,0, 7,0,0},
			{0,3,0, 8,4,0, 0,0,0},

			{0,0,9, 1,2,0, 0,0,0},
			{0,8,0, 9,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,1,6}
	};
	/**
	 * Sudoku example - number 111.
	 */
	public static final int[][] PUZZLE_EXAMPLE_111 = {
			{5,0,6, 0,0,0, 0,0,0},
			{0,0,0, 3,0,1, 0,0,0},
			{0,0,0, 0,0,0, 4,9,0},

			{0,9,8, 0,1,0, 0,0,0},
			{0,0,0, 0,8,0, 0,0,4},
			{0,0,0, 0,4,0, 0,6,7},

			{0,7,0, 0,0,8, 6,0,0},
			{0,0,0, 0,0,0, 0,8,0},
			{0,2,0, 5,0,9, 0,0,0}
	};
	/**
	 * Sudoku example - number 112.
	 */
	public static final int[][] PUZZLE_EXAMPLE_112 = {
			{0,0,0, 0,0,5, 1,6,0},
			{0,9,0, 0,0,0, 4,0,0},
			{0,7,0, 0,8,0, 0,0,0},

			{0,0,0, 0,7,0, 0,0,8},
			{2,0,9, 0,0,1, 0,0,0},
			{0,0,4, 0,0,0, 0,0,6},

			{0,0,6, 9,0,0, 0,4,0},
			{0,0,0, 0,0,0, 0,5,0},
			{0,0,8, 4,0,2, 0,0,0}
	};
	/**
	 * Sudoku example - number 113.
	 */
	public static final int[][] PUZZLE_EXAMPLE_113 = {
			{0,2,0, 0,0,9, 0,0,0},
			{7,0,0, 0,0,0, 0,0,2},
			{0,0,0, 0,1,0, 0,7,6},

			{0,1,8, 0,0,0, 0,0,0},
			{0,0,6, 0,0,8, 0,5,0},
			{0,0,0, 0,7,0, 8,2,0},

			{0,0,0, 2,0,0, 0,0,0},
			{4,0,1, 3,0,0, 0,0,0},
			{0,0,0, 0,0,0, 3,9,4}
	};
	/**
	 * Sudoku example - number 114.
	 */
	public static final int[][] PUZZLE_EXAMPLE_114 = {
			{1,8,0, 0,0,2, 0,0,0},
			{0,0,6, 0,0,0, 7,0,0},
			{0,0,0, 0,0,0, 3,0,1},

			{5,3,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,9, 0,2,4},
			{0,0,0, 0,0,8, 0,0,0},

			{0,0,0, 1,0,0, 0,5,0},
			{8,0,2, 0,0,0, 0,6,0},
			{0,4,0, 0,5,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 115.
	 */
	public static final int[][] PUZZLE_EXAMPLE_115 = {
			{0,1,8, 0,0,6, 0,0,0},
			{0,0,5, 0,0,0, 8,4,0},
			{0,0,6, 0,0,5, 0,9,0},

			{3,9,0, 0,0,0, 0,0,8},
			{0,0,0, 0,5,0, 7,0,0},
			{0,0,0, 3,0,7, 0,0,0},

			{6,0,0, 9,0,0, 0,0,0},
			{0,0,0, 0,8,0, 0,0,0},
			{0,0,0, 0,0,0, 2,8,4}
	};
	/**
	 * Sudoku example - number 116.
	 */
	public static final int[][] PUZZLE_EXAMPLE_116 = {
			{8,0,0, 0,0,6, 0,9,4},
			{5,0,0, 0,0,0, 0,8,2},
			{4,0,0, 7,0,0, 0,0,0},

			{0,0,6, 0,0,0, 2,3,0},
			{0,0,2, 0,7,0, 0,0,0},
			{0,0,0, 3,0,0, 0,0,0},

			{0,7,0, 0,0,2, 0,0,0},
			{0,0,0, 0,5,0, 6,0,8},
			{0,9,0, 0,3,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 117.
	 */
	public static final int[][] PUZZLE_EXAMPLE_117 = {
			{0,1,0, 0,0,0, 0,0,2},
			{0,5,2, 0,3,0, 0,0,0},
			{0,0,0, 1,0,0, 5,0,0},

			{7,0,0, 0,0,0, 4,1,0},
			{8,0,0, 0,0,0, 0,9,0},
			{0,0,0, 0,2,8, 0,0,0},

			{0,0,0, 0,9,4, 0,7,0},
			{0,0,0, 0,0,0, 6,0,0},
			{4,6,9, 0,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 118.
	 */
	public static final int[][] PUZZLE_EXAMPLE_118 = {
			{0,0,0, 0,0,0, 5,2,0},
			{0,0,5, 6,4,0, 0,0,0},
			{0,0,4, 0,0,0, 0,1,0},

			{0,1,0, 0,0,0, 3,0,0},
			{0,0,0, 5,9,0, 0,0,1},
			{0,9,6, 0,0,0, 0,0,0},

			{0,2,0, 0,0,8, 0,7,0},
			{6,0,0, 0,0,0, 0,0,0},
			{3,0,0, 0,0,1, 0,0,5}
	};
	/**
	 * Sudoku example - number 119.
	 */
	public static final int[][] PUZZLE_EXAMPLE_119 = {
			{0,3,0, 0,0,0, 9,0,0},
			{0,0,0, 0,2,4, 6,0,0},
			{8,1,0, 0,0,0, 2,0,0},

			{0,0,0, 7,3,0, 0,0,5},
			{3,0,0, 0,6,0, 0,1,0},
			{0,0,0, 0,0,0, 0,6,0},

			{0,0,8, 4,0,0, 0,0,0},
			{0,0,6, 0,0,0, 0,4,7},
			{0,0,0, 2,0,1, 0,0,0}
	};
	/**
	 * Sudoku example - number 120.
	 */
	public static final int[][] PUZZLE_EXAMPLE_120 = {
			{0,8,0, 7,0,0, 0,0,1},
			{0,9,0, 0,0,0, 0,3,6},
			{0,0,0, 3,0,9, 0,0,0},

			{0,0,1, 0,4,0, 0,0,0},
			{0,2,0, 0,1,0, 0,0,7},
			{0,0,7, 0,0,0, 8,0,0},

			{1,0,0, 0,0,0, 2,4,0},
			{4,0,0, 0,0,0, 0,0,0},
			{8,0,0, 6,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 121.
	 */
	public static final int[][] PUZZLE_EXAMPLE_121 = {
			{0,0,4, 0,0,0, 0,2,0},
			{0,0,0, 7,6,0, 0,9,0},
			{3,0,6, 0,0,0, 0,0,0},

			{0,0,5, 0,0,0, 3,0,1},
			{0,0,0, 0,4,0, 0,0,0},
			{0,0,0, 3,9,0, 6,0,0},

			{0,0,0, 0,0,4, 7,0,0},
			{6,2,0, 0,0,0, 0,0,0},
			{7,0,0, 9,0,2, 0,0,0}
	};
	/**
	 * Sudoku example - number 122.
	 */
	public static final int[][] PUZZLE_EXAMPLE_122 = {
			{7,2,5, 0,0,0, 0,0,0},
			{0,0,0, 6,0,0, 0,0,0},
			{0,0,9, 3,0,0, 0,5,0},

			{0,1,0, 0,4,8, 0,0,0},
			{0,0,7, 0,0,5, 0,0,0},
			{0,0,0, 0,0,0, 8,2,0},

			{0,0,0, 4,3,0, 0,0,0},
			{3,0,0, 0,0,0, 9,0,0},
			{5,0,0, 0,0,0, 7,0,8}
	};
	/**
	 * Sudoku example - number 123.
	 */
	public static final int[][] PUZZLE_EXAMPLE_123 = {
			{0,2,0, 0,0,0, 0,7,5},
			{1,0,0, 5,0,0, 0,0,0},
			{0,0,0, 6,2,0, 0,9,0},

			{0,0,7, 9,0,1, 0,0,0},
			{0,0,3, 0,0,0, 0,0,6},
			{0,0,4, 0,0,0, 2,0,7},

			{4,5,0, 0,0,0, 8,0,0},
			{0,0,0, 0,0,4, 0,0,0},
			{0,0,0, 0,6,0, 5,0,0}
	};
	/**
	 * Sudoku example - number 124.
	 */
	public static final int[][] PUZZLE_EXAMPLE_124 = {
			{0,0,8, 0,0,0, 9,0,0},
			{0,5,3, 0,0,6, 0,0,0},
			{0,0,0, 0,0,2, 6,0,5},

			{0,0,0, 2,5,0, 0,0,0},
			{6,0,1, 0,0,0, 0,4,0},
			{0,0,0, 0,0,0, 0,0,3},

			{8,1,0, 9,0,0, 0,0,0},
			{0,9,0, 0,0,0, 8,5,0},
			{0,0,0, 0,6,4, 0,0,0}
	};
	/**
	 * Sudoku example - number 125.
	 */
	public static final int[][] PUZZLE_EXAMPLE_125 = {
			{0,3,0, 0,8,0, 0,4,0},
			{0,0,2, 0,4,0, 0,0,0},
			{0,0,1, 0,0,0, 2,6,0},

			{5,0,6, 9,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,0,3},
			{0,0,3, 6,0,0, 9,0,0},

			{2,0,0, 0,0,5, 0,0,4},
			{9,0,0, 0,0,4, 0,0,0},
			{0,0,0, 0,0,0, 0,1,9}
	};
	/**
	 * Sudoku example - number 126.
	 */
	public static final int[][] PUZZLE_EXAMPLE_126 = {
			{0,0,0, 0,0,5, 0,6,0},
			{0,0,0, 0,0,7, 3,0,0},
			{6,9,3, 0,0,0, 0,0,0},

			{0,0,0, 1,3,2, 0,0,0},
			{0,0,2, 0,0,0, 9,5,0},
			{0,8,0, 0,0,0, 0,0,0},

			{8,0,0, 0,0,0, 0,0,0},
			{5,4,0, 0,1,0, 0,0,0},
			{0,0,0, 4,0,0, 8,0,3}
	};
	/**
	 * Sudoku example - number 127.
	 */
	public static final int[][] PUZZLE_EXAMPLE_127 = {
			{0,0,5, 4,0,0, 0,0,0},
			{0,8,0, 0,0,0, 0,0,0},
			{0,0,0, 0,6,0, 0,7,3},

			{0,0,2, 0,0,0, 7,0,0},
			{0,0,0, 2,0,4, 9,0,0},
			{6,0,9, 5,0,0, 0,0,0},

			{0,2,0, 0,0,3, 0,0,0},
			{8,5,0, 0,7,0, 0,0,0},
			{0,0,0, 0,0,0, 0,4,8}
	};
	/**
	 * Sudoku example - number 128.
	 */
	public static final int[][] PUZZLE_EXAMPLE_128 = {
			{0,7,0, 0,2,0, 0,0,0},
			{0,0,0, 0,0,7, 6,0,0},
			{2,6,0, 0,0,0, 0,4,0},

			{0,0,0, 9,8,5, 0,0,0},
			{7,0,0, 0,0,0, 4,0,0},
			{5,0,0, 0,0,0, 0,9,0},

			{0,0,5, 2,0,0, 0,0,0},
			{0,0,0, 1,0,0, 0,0,3},
			{0,3,1, 0,0,0, 5,0,6}
	};
	/**
	 * Sudoku example - number 129.
	 */
	public static final int[][] PUZZLE_EXAMPLE_129 = {
			{0,7,0, 0,0,0, 0,0,3},
			{2,6,0, 0,0,0, 0,0,0},
			{0,0,0, 0,1,9, 0,7,0},

			{0,0,0, 0,8,0, 2,0,0},
			{8,0,0, 0,0,0, 7,0,0},
			{0,1,0, 3,6,0, 0,0,0},

			{0,0,6, 0,0,0, 8,0,4},
			{0,0,0, 1,4,6, 0,0,0},
			{0,0,1, 0,0,8, 0,0,2}
	};
	/**
	 * Sudoku example - number 130.
	 */
	public static final int[][] PUZZLE_EXAMPLE_130 = {
			{0,2,0, 0,0,0, 0,8,0},
			{4,0,0, 0,0,0, 0,1,0},
			{0,0,0, 0,0,7, 0,6,0},

			{0,7,0, 0,1,0, 5,0,0},
			{5,8,0, 0,4,0, 0,0,0},
			{0,0,0, 0,6,0, 9,0,0},

			{0,0,5, 0,0,8, 0,0,3},
			{0,0,6, 0,0,0, 1,0,0},
			{0,0,0, 0,0,6, 0,0,0}
	};
	/**
	 * Sudoku example - number 131.
	 */
	public static final int[][] PUZZLE_EXAMPLE_131 = {
			{0,0,0, 0,7,0, 8,9,0},
			{0,0,2, 0,0,0, 4,0,3},
			{0,0,0, 3,0,0, 0,0,0},

			{7,1,0, 0,0,0, 0,0,8},
			{0,0,0, 4,0,2, 0,0,0},
			{0,8,0, 0,0,7, 0,0,0},

			{6,2,0, 0,0,0, 0,5,0},
			{0,0,0, 0,9,0, 1,0,0},
			{0,0,0, 0,4,0, 0,6,0}
	};
	/**
	 * Sudoku example - number 132.
	 */
	public static final int[][] PUZZLE_EXAMPLE_132 = {
			{0,6,0, 0,5,7, 0,0,0},
			{0,1,0, 0,0,0, 0,0,6},
			{0,0,0, 0,0,0, 3,0,5},

			{0,0,0, 8,1,4, 0,0,0},
			{0,0,3, 0,0,0, 0,8,0},
			{5,0,6, 0,0,0, 0,0,0},

			{0,0,0, 3,0,0, 0,1,7},
			{8,0,0, 0,0,0, 0,5,0},
			{0,0,4, 9,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 133.
	 */
	public static final int[][] PUZZLE_EXAMPLE_133 = {
			{0,0,3, 9,0,0, 6,0,0},
			{0,2,6, 0,0,0, 0,0,0},
			{0,0,0, 0,4,0, 7,0,0},

			{0,0,0, 0,0,0, 0,5,8},
			{0,0,0, 1,0,8, 0,0,4},
			{0,5,0, 0,0,2, 0,0,0},

			{0,0,0, 0,8,0, 0,0,0},
			{4,0,1, 0,0,0, 0,6,0},
			{3,0,0, 0,2,0, 5,0,0}
	};
	/**
	 * Sudoku example - number 134.
	 */
	public static final int[][] PUZZLE_EXAMPLE_134 = {
			{4,0,0, 0,1,0, 0,0,0},
			{0,0,9, 0,0,0, 0,0,1},
			{0,0,6, 0,8,9, 0,0,0},

			{0,0,0, 0,0,0, 0,4,5},
			{0,7,5, 0,0,0, 0,9,0},
			{0,0,0, 0,3,0, 0,0,0},

			{0,4,0, 5,0,0, 2,0,0},
			{0,0,0, 1,0,8, 3,0,0},
			{1,0,0, 0,0,0, 6,0,0}
	};
	/**
	 * Sudoku example - number 135.
	 */
	public static final int[][] PUZZLE_EXAMPLE_135 = {
			{0,0,8, 2,0,0, 0,0,0},
			{0,0,0, 0,0,3, 1,0,0},
			{0,5,0, 0,0,0, 4,2,0},

			{0,0,0, 0,0,0, 0,8,9},
			{0,0,0, 4,8,0, 0,0,0},
			{7,0,0, 0,0,0, 0,0,0},

			{0,0,0, 0,9,7, 0,0,6},
			{4,0,0, 0,0,1, 7,0,0},
			{9,0,2, 0,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 136.
	 */
	public static final int[][] PUZZLE_EXAMPLE_136 = {
			{0,7,8, 0,9,0, 0,0,0},
			{0,0,0, 0,2,0, 0,5,7},
			{0,0,0, 0,3,0, 0,6,0},

			{0,0,3, 7,0,0, 0,0,0},
			{0,0,0, 6,0,0, 0,3,5},
			{6,0,4, 0,0,0, 0,0,8},

			{9,0,0, 0,0,3, 0,0,0},
			{0,0,0, 0,0,1, 5,0,0},
			{0,8,0, 0,0,0, 7,0,1}
	};
	/**
	 * Sudoku example - number 137.
	 */
	public static final int[][] PUZZLE_EXAMPLE_137 = {
			{0,7,0, 0,0,0, 0,8,4},
			{0,0,0, 5,0,8, 0,0,1},
			{0,0,8, 0,0,0, 0,0,0},

			{0,0,0, 0,0,1, 2,0,0},
			{0,2,5, 0,0,3, 0,0,0},
			{0,0,9, 0,0,0, 7,0,5},

			{3,4,0, 0,0,0, 0,0,0},
			{0,0,0, 0,9,0, 0,3,0},
			{5,0,0, 7,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 138.
	 */
	public static final int[][] PUZZLE_EXAMPLE_138 = {
			{0,0,8, 0,0,0, 6,9,0},
			{0,0,0, 0,0,0, 8,3,0},
			{0,3,0, 0,9,0, 0,0,0},

			{1,0,0, 8,0,0, 0,0,5},
			{7,0,0, 1,0,5, 0,0,0},
			{8,0,0, 6,0,0, 0,0,2},

			{0,0,0, 0,0,0, 0,1,6},
			{5,9,0, 0,0,0, 0,0,0},
			{0,0,0, 7,6,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 139.
	 */
	public static final int[][] PUZZLE_EXAMPLE_139 = {
			{0,6,0, 0,0,0, 0,9,0},
			{0,0,2, 0,0,0, 6,3,0},
			{0,0,0, 9,0,2, 0,0,0},

			{6,4,3, 0,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,0,2},
			{0,0,0, 8,0,7, 0,0,5},

			{4,0,0, 0,9,0, 0,0,0},
			{7,0,0, 0,0,0, 5,0,4},
			{0,0,0, 3,5,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 140.
	 */
	public static final int[][] PUZZLE_EXAMPLE_140 = {
			{7,0,0, 0,0,0, 9,8,0},
			{0,0,2, 8,0,0, 0,0,0},
			{0,0,0, 6,5,0, 0,0,0},

			{0,0,0, 0,0,1, 0,9,7},
			{0,0,6, 0,0,0, 0,2,0},
			{0,1,0, 4,0,0, 0,0,0},

			{2,0,0, 0,6,0, 4,0,0},
			{0,0,0, 0,1,0, 0,3,0},
			{1,8,5, 0,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 141.
	 */
	public static final int[][] PUZZLE_EXAMPLE_141 = {
			{0,0,0, 0,5,0, 0,3,0},
			{3,6,0, 0,2,0, 0,0,0},
			{0,0,0, 0,7,0, 0,0,2},

			{0,0,0, 0,0,7, 1,0,0},
			{0,0,4, 0,0,0, 5,0,0},
			{0,2,0, 3,0,0, 9,0,0},

			{5,0,0, 0,0,0, 0,8,9},
			{4,0,6, 0,0,9, 0,0,0},
			{0,0,0, 6,0,5, 0,0,0}
	};
	/**
	 * Sudoku example - number 142.
	 */
	public static final int[][] PUZZLE_EXAMPLE_142 = {
			{8,0,0, 1,0,2, 0,0,0},
			{5,0,0, 0,0,0, 0,2,0},
			{0,0,0, 0,0,0, 9,6,0},

			{0,5,8, 7,0,0, 0,0,0},
			{0,0,3, 0,0,0, 0,0,8},
			{0,0,0, 5,2,0, 0,0,0},

			{0,0,0, 0,0,9, 2,0,0},
			{9,3,0, 0,0,0, 0,0,0},
			{0,6,0, 0,0,0, 7,0,4}
	};
	/**
	 * Sudoku example - number 143.
	 */
	public static final int[][] PUZZLE_EXAMPLE_143 = {
			{0,6,0, 0,0,0, 0,9,1},
			{0,0,0, 0,9,3, 0,0,0},
			{0,7,0, 0,6,0, 0,0,0},

			{5,0,4, 6,0,0, 0,0,0},
			{0,0,0, 0,2,0, 5,0,7},
			{3,0,0, 0,0,0, 0,0,4},

			{0,0,0, 8,0,0, 7,0,0},
			{0,0,0, 0,0,0, 8,6,0},
			{0,0,6, 0,0,4, 0,0,0}
	};
	/**
	 * Sudoku example - number 144.
	 */
	public static final int[][] PUZZLE_EXAMPLE_144 = {
			{3,0,1, 0,0,0, 0,0,0},
			{0,0,0, 0,6,0, 1,0,9},
			{0,0,0, 0,9,3, 2,0,0},

			{0,0,3, 2,0,0, 0,0,0},
			{0,6,7, 0,0,0, 0,0,0},
			{0,0,0, 0,0,0, 9,2,6},

			{7,0,0, 0,0,0, 0,8,5},
			{0,0,0, 3,0,5, 0,7,0},
			{5,0,0, 0,0,7, 0,0,0}
	};
	/**
	 * Sudoku example - number 145.
	 */
	public static final int[][] PUZZLE_EXAMPLE_145 = {
			{0,0,0, 0,6,0, 0,0,5},
			{1,7,0, 0,0,0, 0,8,9},
			{0,0,5, 0,0,0, 0,0,0},

			{0,9,0, 1,0,6, 0,0,0},
			{0,2,0, 4,0,0, 0,0,1},
			{0,0,0, 0,0,0, 3,0,2},

			{0,0,7, 0,0,0, 1,2,0},
			{0,0,0, 0,1,2, 0,4,0},
			{8,0,0, 0,0,9, 0,0,0}
	};
	/**
	 * Sudoku example - number 146.
	 */
	public static final int[][] PUZZLE_EXAMPLE_146 = {
			{0,0,0, 3,0,0, 0,0,0},
			{0,0,0, 0,0,1, 2,0,8},
			{1,9,0, 0,0,0, 0,0,4},

			{0,0,4, 0,9,0, 0,6,0},
			{0,0,0, 6,7,0, 0,0,0},
			{2,0,7, 0,0,0, 0,0,0},

			{0,0,0, 0,1,0, 7,0,2},
			{0,0,3, 0,5,2, 0,0,0},
			{0,7,0, 0,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 147.
	 */
	public static final int[][] PUZZLE_EXAMPLE_147 = {
			{0,0,0, 0,2,9, 0,3,0},
			{0,0,9, 0,0,0, 0,4,0},
			{0,0,8, 0,0,3, 0,0,6},

			{5,6,0, 0,0,0, 0,0,0},
			{4,0,0, 0,0,0, 9,0,0},
			{0,0,0, 5,0,0, 0,0,3},

			{0,0,0, 0,0,0, 4,2,0},
			{0,8,0, 0,6,0, 5,0,0},
			{0,1,0, 0,0,2, 0,0,0}
	};
	/**
	 * Sudoku example - number 148.
	 */
	public static final int[][] PUZZLE_EXAMPLE_148 = {
			{0,6,0, 0,0,0, 0,0,2},
			{3,4,0, 0,0,0, 0,9,6},
			{0,0,0, 1,0,0, 0,0,0},

			{0,0,3, 0,0,2, 0,0,0},
			{0,0,0, 4,0,8, 0,7,0},
			{4,0,0, 0,0,0, 8,0,0},

			{8,0,6, 0,4,0, 0,0,0},
			{0,0,0, 0,1,0, 0,0,5},
			{0,0,2, 0,0,0, 7,0,0}
	};
	/**
	 * Sudoku example - number 149.
	 */
	public static final int[][] PUZZLE_EXAMPLE_149 = {
			{0,0,0, 9,0,0, 0,1,0},
			{0,7,0, 0,0,0, 0,6,9},
			{0,6,0, 0,0,2, 0,0,0},

			{9,0,6, 0,0,0, 2,0,0},
			{0,0,0, 0,0,3, 9,0,8},
			{0,0,5, 0,0,0, 0,0,0},

			{0,0,0, 0,7,0, 3,0,0},
			{0,0,0, 6,3,0, 0,0,0},
			{2,8,0, 0,0,0, 6,0,0}
	};
	/**
	 * Sudoku example - number 150.
	 */
	public static final int[][] PUZZLE_EXAMPLE_150 = {
			{0,0,0, 0,0,0, 3,0,6},
			{0,4,0, 8,0,9, 0,0,0},
			{0,7,0, 0,0,1, 0,0,9},

			{0,0,0, 0,8,3, 0,1,0},
			{0,0,9, 0,0,0, 0,2,0},
			{0,5,1, 0,0,0, 0,0,0},

			{0,0,0, 0,0,0, 4,0,0},
			{1,0,0, 5,6,0, 0,0,0},
			{5,0,0, 0,4,0, 0,3,0}
	};
	/**
	 * Sudoku example - number 151.
	 */
	public static final int[][] PUZZLE_EXAMPLE_151 = {
			{0,0,5, 0,3,0, 0,0,0},
			{7,0,9, 0,0,0, 0,6,0},
			{0,0,6, 4,0,0, 0,0,0},

			{0,0,0, 0,0,0, 4,0,8},
			{0,0,0, 0,6,1, 0,0,0},
			{0,9,0, 0,0,0, 0,0,2},

			{0,4,0, 6,0,3, 0,0,0},
			{0,2,0, 0,0,0, 8,0,0},
			{0,0,0, 0,7,0, 0,5,0}
	};
	/**
	 * Sudoku example - number 152.
	 */
	public static final int[][] PUZZLE_EXAMPLE_152 = {
			{0,0,5, 0,4,0, 0,0,0},
			{7,0,0, 0,0,0, 1,0,5},
			{3,0,0, 0,0,0, 0,8,0},

			{0,9,0, 8,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,5,0},
			{0,7,0, 9,1,0, 0,0,0},

			{0,0,9, 0,0,2, 0,0,0},
			{0,8,2, 0,0,0, 0,6,3},
			{0,0,0, 1,0,0, 5,0,9}
	};
	/**
	 * Sudoku example - number 153.
	 */
	public static final int[][] PUZZLE_EXAMPLE_153 = {
			{0,1,0, 4,0,0, 0,0,0},
			{0,0,4, 0,6,0, 0,2,0},
			{0,0,0, 0,0,9, 7,0,0},

			{0,0,7, 0,4,3, 0,0,2},
			{0,2,0, 0,8,0, 0,4,0},
			{3,0,0, 6,0,0, 8,0,0},

			{0,0,6, 0,0,0, 0,0,1},
			{0,5,0, 0,2,0, 0,8,0},
			{2,0,0, 9,0,0, 6,0,5}
	};
	/**
	 * Sudoku example - number 154.
	 */
	public static final int[][] PUZZLE_EXAMPLE_154 = {
			{3,0,0, 7,0,0, 0,0,0},
			{0,2,0, 0,5,0, 0,4,0},
			{0,0,5, 0,0,4, 0,0,0},

			{0,0,4, 0,0,6, 0,0,3},
			{0,7,0, 8,0,0, 1,0,0},
			{9,0,0, 0,1,0, 0,2,0},

			{8,0,0, 0,0,5, 0,0,1},
			{0,0,9, 0,8,0, 5,0,0},
			{0,6,0, 4,0,0, 0,3,0}
	};
	/**
	 * Sudoku example - number 155.
	 */
	public static final int[][] PUZZLE_EXAMPLE_155 = {
			{0,0,2, 5,4,0, 0,0,1},
			{0,3,0, 0,0,1, 0,0,0},
			{0,0,0, 0,7,3, 0,8,0},

			{0,0,1, 3,0,7, 0,0,6},
			{3,0,0, 0,2,0, 0,1,0},
			{0,0,0, 6,0,0, 2,0,0},

			{1,0,0, 0,9,0, 0,0,5},
			{0,0,5, 0,0,0, 3,6,0},
			{0,4,0, 0,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 156.
	 */
	public static final int[][] PUZZLE_EXAMPLE_156 = {
			{0,0,0, 0,3,0, 5,0,2},
			{2,0,0, 0,0,0, 8,7,0},
			{0,0,0, 0,0,9, 0,0,4},

			{8,0,0, 0,0,7, 0,0,9},
			{0,0,0, 0,0,0, 0,6,0},
			{0,0,6, 9,0,3, 0,0,0},

			{7,0,0, 0,0,0, 0,0,5},
			{0,5,0, 0,0,8, 9,4,0},
			{0,0,1, 6,0,0, 0,3,0}
	};
	/**
	 * Sudoku example - number 157.
	 */
	public static final int[][] PUZZLE_EXAMPLE_157 = {
			{0,0,2, 5,0,0, 4,0,0},
			{0,5,0, 0,9,0, 0,7,0},
			{4,0,0, 0,0,1, 0,0,5},

			{2,0,0, 7,0,0, 0,0,0},
			{0,0,0, 0,3,0, 0,4,0},
			{0,0,8, 0,0,5, 0,0,6},

			{0,0,4, 0,6,0, 0,9,0},
			{6,9,0, 0,0,0, 1,0,0},
			{5,0,0, 1,0,0, 0,0,2}
	};
	/**
	 * Sudoku example - number 158.
	 */
	public static final int[][] PUZZLE_EXAMPLE_158 = {
			{0,0,0, 0,7,0, 2,0,0},
			{0,0,0, 0,0,3, 0,7,9},
			{0,1,0, 2,0,0, 4,0,0},

			{0,0,6, 0,5,0, 0,9,0},
			{0,9,0, 0,0,6, 0,2,7},
			{8,0,0, 0,0,9, 0,0,0},

			{0,0,0, 0,1,0, 8,0,3},
			{2,0,0, 0,3,0, 0,6,0},
			{0,5,0, 6,0,0, 0,0,0}
	};
	/**
	 * Sudoku example - number 159.
	 */
	public static final int[][] PUZZLE_EXAMPLE_159 = {
			{0,0,0, 6,0,0, 7,2,4},
			{0,0,2, 0,0,0, 1,0,0},
			{0,0,0, 9,0,0, 0,0,0},

			{0,0,9, 5,0,8, 2,0,0},
			{6,0,0, 0,0,4, 0,0,0},
			{0,1,0, 0,0,9, 5,0,0},

			{0,0,6, 0,0,0, 0,0,2},
			{4,0,0, 1,0,0, 0,3,0},
			{0,0,0, 0,8,5, 9,0,6}
	};
	/**
	 * Sudoku example - number 160.
	 */
	public static final int[][] PUZZLE_EXAMPLE_160 = {
			{0,0,0, 0,0,6, 0,0,0},
			{0,0,9, 0,8,0, 0,3,0},
			{0,0,0, 0,5,0, 9,4,0},

			{5,8,0, 0,9,2, 3,0,0},
			{0,0,3, 0,0,0, 2,9,0},
			{2,0,0, 0,0,0, 0,0,7},

			{0,0,5, 0,0,7, 0,0,9},
			{6,0,0, 0,3,0, 0,2,0},
			{0,7,0, 0,0,0, 0,1,0}
	};
	/**
	 * Number of Sudoku examples available in Store.
	 */
	public static final int NUMBER_OF_PUZZLE_EXAMPLES = 161;
	/**
	 * Puzzle with non-unique solution.
	 */
	public static final int[][] PUZZLE_NON_UNIQUE_SOLUTION = {
			{0,8,0, 0,0,9, 7,4,3},
			{0,5,0, 0,0,8, 0,1,0},
			{0,1,0, 0,0,0, 0,0,0},

			{8,0,0, 0,0,5, 0,0,0},
			{0,0,0, 8,0,4, 0,0,0},
			{0,0,0, 3,0,0, 0,0,6},

			{0,0,0, 0,0,0, 0,7,0},
			{0,3,0, 5,0,0, 0,8,0},
			{9,7,2, 4,0,0, 0,5,0}
	};
	/**
	 * Puzzle without solution.
	 */
	public static final int[][] PUZZLE_NO_SOLUTION = {
			{0,0,0, 8,0,0, 0,0,0},
			{4,0,0, 0,1,5, 0,3,0},
			{0,2,9, 0,4,0, 5,1,8},

			{0,4,0, 0,0,0, 1,2,0},
			{0,0,0, 6,0,2, 0,0,0},
			{0,3,2, 0,0,0, 0,9,0},

			{6,9,3, 0,5,0, 8,7,0},
			{0,5,0, 4,8,0, 0,0,1},
			{0,0,0, 0,0,3, 0,0,2}
	};
	/**
	 * Puzzle containing obvious error.
	 */
	public static final int[][] PUZZLE_ERROR = {
			{0,0,0, 8,0,0, 0,0,0},
			{4,0,0, 0,1,5, 0,3,0},
			{0,2,9, 0,4,0, 5,1,8},

			{0,4,0, 0,0,0, 1,2,0},
			{0,0,0, 6,0,2, 0,0,0},
			{3,3,2, 0,0,0, 0,9,0},

			{6,9,3, 0,5,0, 8,7,0},
			{0,5,0, 4,8,0, 0,0,1},
			{0,0,0, 0,0,3, 0,0,0}
	};
	/**
	 * Blank puzzle.
	 */
	public static final int[][] PUZZLE_EMPTY = {
			{0,0,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,0,0},

			{0,0,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,0,0},

			{0,0,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,0,0},
			{0,0,0, 0,0,0, 0,0,0}
	};
	/**
	 * Puzzle used in regression tests.
	 */
	public static final int[][] PUZZLE_REGTESTS = {
			{0,0,0, 8,0,0, 0,0,0},
			{4,0,0, 0,1,5, 0,3,0},
			{0,2,9, 0,4,0, 5,1,8},

			{0,4,0, 0,0,0, 1,2,0},
			{0,0,0, 6,0,2, 0,0,0},
			{0,3,2, 0,0,0, 0,9,0},

			{6,9,3, 0,5,0, 8,7,0},
			{0,5,0, 4,8,0, 0,0,1},
			{0,0,0, 0,0,3, 0,0,0}
	};
	/**
	 * Puzzle solution used in regression tests.
	 */
	public static final int[][] PUZZLE_REGTESTS_SOLUTION = {
			{3,1,5, 8,2,7, 9,4,6},
			{4,6,8, 9,1,5, 7,3,2},
			{7,2,9, 3,4,6, 5,1,8},

			{9,4,6, 5,3,8, 1,2,7},
			{5,7,1, 6,9,2, 4,8,3},
			{8,3,2, 1,7,4, 6,9,5},

			{6,9,3, 2,5,1, 8,7,4},
			{2,5,7, 4,8,9, 3,6,1},
			{1,8,4, 7,6,3, 2,5,9}
	};
	/**
	 * Gets Sudoku example for the Sudoku Store.
	 * @param exampleNumber     Example number.
	 * @return                  Sudoku example is exists, otherwise null.
	 * @see SudokuPuzzles#NUMBER_OF_PUZZLE_EXAMPLES
	 */
	public static final int[][] getPuzzleExample(int exampleNumber) {
		switch(exampleNumber) {
		case   0: return PUZZLE_EXAMPLE_000;
		case   1: return PUZZLE_EXAMPLE_001;
		case   2: return PUZZLE_EXAMPLE_002;
		case   3: return PUZZLE_EXAMPLE_003;
		case   4: return PUZZLE_EXAMPLE_004;
		case   5: return PUZZLE_EXAMPLE_005;
		case   6: return PUZZLE_EXAMPLE_006;
		case   7: return PUZZLE_EXAMPLE_007;
		case   8: return PUZZLE_EXAMPLE_008;
		case   9: return PUZZLE_EXAMPLE_009;
		case  10: return PUZZLE_EXAMPLE_010;
		case  11: return PUZZLE_EXAMPLE_011;
		case  12: return PUZZLE_EXAMPLE_012;
		case  13: return PUZZLE_EXAMPLE_013;
		case  14: return PUZZLE_EXAMPLE_014;
		case  15: return PUZZLE_EXAMPLE_015;
		case  16: return PUZZLE_EXAMPLE_016;
		case  17: return PUZZLE_EXAMPLE_017;
		case  18: return PUZZLE_EXAMPLE_018;
		case  19: return PUZZLE_EXAMPLE_019;
		case  20: return PUZZLE_EXAMPLE_020;
		case  21: return PUZZLE_EXAMPLE_021;
		case  22: return PUZZLE_EXAMPLE_022;
		case  23: return PUZZLE_EXAMPLE_023;
		case  24: return PUZZLE_EXAMPLE_024;
		case  25: return PUZZLE_EXAMPLE_025;
		case  26: return PUZZLE_EXAMPLE_026;
		case  27: return PUZZLE_EXAMPLE_027;
		case  28: return PUZZLE_EXAMPLE_028;
		case  29: return PUZZLE_EXAMPLE_029;
		case  30: return PUZZLE_EXAMPLE_030;
		case  31: return PUZZLE_EXAMPLE_031;
		case  32: return PUZZLE_EXAMPLE_032;
		case  33: return PUZZLE_EXAMPLE_033;
		case  34: return PUZZLE_EXAMPLE_034;
		case  35: return PUZZLE_EXAMPLE_035;
		case  36: return PUZZLE_EXAMPLE_036;
		case  37: return PUZZLE_EXAMPLE_037;
		case  38: return PUZZLE_EXAMPLE_038;
		case  39: return PUZZLE_EXAMPLE_039;
		case  40: return PUZZLE_EXAMPLE_040;
		case  41: return PUZZLE_EXAMPLE_041;
		case  42: return PUZZLE_EXAMPLE_042;
		case  43: return PUZZLE_EXAMPLE_043;
		case  44: return PUZZLE_EXAMPLE_044;
		case  45: return PUZZLE_EXAMPLE_045;
		case  46: return PUZZLE_EXAMPLE_046;
		case  47: return PUZZLE_EXAMPLE_047;
		case  48: return PUZZLE_EXAMPLE_048;
		case  49: return PUZZLE_EXAMPLE_049;
		case  50: return PUZZLE_EXAMPLE_050;
		case  51: return PUZZLE_EXAMPLE_051;
		case  52: return PUZZLE_EXAMPLE_052;
		case  53: return PUZZLE_EXAMPLE_053;
		case  54: return PUZZLE_EXAMPLE_054;
		case  55: return PUZZLE_EXAMPLE_055;
		case  56: return PUZZLE_EXAMPLE_056;
		case  57: return PUZZLE_EXAMPLE_057;
		case  58: return PUZZLE_EXAMPLE_058;
		case  59: return PUZZLE_EXAMPLE_059;
		case  60: return PUZZLE_EXAMPLE_060;
		case  61: return PUZZLE_EXAMPLE_061;
		case  62: return PUZZLE_EXAMPLE_062;
		case  63: return PUZZLE_EXAMPLE_063;
		case  64: return PUZZLE_EXAMPLE_064;
		case  65: return PUZZLE_EXAMPLE_065;
		case  66: return PUZZLE_EXAMPLE_066;
		case  67: return PUZZLE_EXAMPLE_067;
		case  68: return PUZZLE_EXAMPLE_068;
		case  69: return PUZZLE_EXAMPLE_069;
		case  70: return PUZZLE_EXAMPLE_070;
		case  71: return PUZZLE_EXAMPLE_071;
		case  72: return PUZZLE_EXAMPLE_072;
		case  73: return PUZZLE_EXAMPLE_073;
		case  74: return PUZZLE_EXAMPLE_074;
		case  75: return PUZZLE_EXAMPLE_075;
		case  76: return PUZZLE_EXAMPLE_076;
		case  77: return PUZZLE_EXAMPLE_077;
		case  78: return PUZZLE_EXAMPLE_078;
		case  79: return PUZZLE_EXAMPLE_079;
		case  80: return PUZZLE_EXAMPLE_080;
		case  81: return PUZZLE_EXAMPLE_081;
		case  82: return PUZZLE_EXAMPLE_082;
		case  83: return PUZZLE_EXAMPLE_083;
		case  84: return PUZZLE_EXAMPLE_084;
		case  85: return PUZZLE_EXAMPLE_085;
		case  86: return PUZZLE_EXAMPLE_086;
		case  87: return PUZZLE_EXAMPLE_087;
		case  88: return PUZZLE_EXAMPLE_088;
		case  89: return PUZZLE_EXAMPLE_089;
		case  90: return PUZZLE_EXAMPLE_090;
		case  91: return PUZZLE_EXAMPLE_091;
		case  92: return PUZZLE_EXAMPLE_092;
		case  93: return PUZZLE_EXAMPLE_093;
		case  94: return PUZZLE_EXAMPLE_094;
		case  95: return PUZZLE_EXAMPLE_095;
		case  96: return PUZZLE_EXAMPLE_096;
		case  97: return PUZZLE_EXAMPLE_097;
		case  98: return PUZZLE_EXAMPLE_098;
		case  99: return PUZZLE_EXAMPLE_099;
		case 100: return PUZZLE_EXAMPLE_100;
		case 101: return PUZZLE_EXAMPLE_101;
		case 102: return PUZZLE_EXAMPLE_102;
		case 103: return PUZZLE_EXAMPLE_103;
		case 104: return PUZZLE_EXAMPLE_104;
		case 105: return PUZZLE_EXAMPLE_105;
		case 106: return PUZZLE_EXAMPLE_106;
		case 107: return PUZZLE_EXAMPLE_107;
		case 108: return PUZZLE_EXAMPLE_108;
		case 109: return PUZZLE_EXAMPLE_109;
		case 110: return PUZZLE_EXAMPLE_110;
		case 111: return PUZZLE_EXAMPLE_111;
		case 112: return PUZZLE_EXAMPLE_112;
		case 113: return PUZZLE_EXAMPLE_113;
		case 114: return PUZZLE_EXAMPLE_114;
		case 115: return PUZZLE_EXAMPLE_115;
		case 116: return PUZZLE_EXAMPLE_116;
		case 117: return PUZZLE_EXAMPLE_117;
		case 118: return PUZZLE_EXAMPLE_118;
		case 119: return PUZZLE_EXAMPLE_119;
		case 120: return PUZZLE_EXAMPLE_120;
		case 121: return PUZZLE_EXAMPLE_121;
		case 122: return PUZZLE_EXAMPLE_122;
		case 123: return PUZZLE_EXAMPLE_123;
		case 124: return PUZZLE_EXAMPLE_124;
		case 125: return PUZZLE_EXAMPLE_125;
		case 126: return PUZZLE_EXAMPLE_126;
		case 127: return PUZZLE_EXAMPLE_127;
		case 128: return PUZZLE_EXAMPLE_128;
		case 129: return PUZZLE_EXAMPLE_129;
		case 130: return PUZZLE_EXAMPLE_130;
		case 131: return PUZZLE_EXAMPLE_131;
		case 132: return PUZZLE_EXAMPLE_132;
		case 133: return PUZZLE_EXAMPLE_133;
		case 134: return PUZZLE_EXAMPLE_134;
		case 135: return PUZZLE_EXAMPLE_135;
		case 136: return PUZZLE_EXAMPLE_136;
		case 137: return PUZZLE_EXAMPLE_137;
		case 138: return PUZZLE_EXAMPLE_138;
		case 139: return PUZZLE_EXAMPLE_139;
		case 140: return PUZZLE_EXAMPLE_140;
		case 141: return PUZZLE_EXAMPLE_141;
		case 142: return PUZZLE_EXAMPLE_142;
		case 143: return PUZZLE_EXAMPLE_143;
		case 144: return PUZZLE_EXAMPLE_144;
		case 145: return PUZZLE_EXAMPLE_145;
		case 146: return PUZZLE_EXAMPLE_146;
		case 147: return PUZZLE_EXAMPLE_147;
		case 148: return PUZZLE_EXAMPLE_148;
		case 149: return PUZZLE_EXAMPLE_149;
		case 150: return PUZZLE_EXAMPLE_150;
		case 151: return PUZZLE_EXAMPLE_151;
		case 152: return PUZZLE_EXAMPLE_152;
		case 153: return PUZZLE_EXAMPLE_153;
		case 154: return PUZZLE_EXAMPLE_154;
		case 155: return PUZZLE_EXAMPLE_155;
		case 156: return PUZZLE_EXAMPLE_156;
		case 157: return PUZZLE_EXAMPLE_157;
		case 158: return PUZZLE_EXAMPLE_158;
		case 159: return PUZZLE_EXAMPLE_159;
		case 160: return PUZZLE_EXAMPLE_160;
		}
		return null;
	}
	/**
	 * Returns pre-calculated puzzle example difficulty rating based on
	 * the average number of steps-back performed while recursive
	 * solving sudoku board.
	 *
	 * @param exampleNumber    The example number {@link SudokuPuzzles#NUMBER_OF_PUZZLE_EXAMPLES}
	 * @return Puzzle example difficulty rating if example exist, otherwise -1.
	 */
	public static final double getPuzzleExampleRating(int exampleNumber) {
		switch(exampleNumber) {
		case 0: return 16508.0;
		case 1: return 0.4883;
		case 2: return 51.2331;
		case 3: return 55.591;
		case 4: return 0.3388;
		case 5: return 56.0881;
		case 6: return 96.6181;
		case 7: return 33.6664;
		case 8: return 0.0;
		case 9: return 353.9754;
		case 10: return 109.1;
		case 11: return 0.0;
		case 12: return 165.0856;
		case 13: return 183.9458;
		case 14: return 78.7183;
		case 15: return 10.1855;
		case 16: return 48.706;
		case 17: return 134.1346;
		case 18: return 18.5211;
		case 19: return 0.0;
		case 20: return 0.0;
		case 21: return 58.8111;
		case 22: return 1.7414;
		case 23: return 2.8341;
		case 24: return 23.5595;
		case 25: return 25.9445;
		case 26: return 12.95;
		case 27: return 27.7823;
		case 28: return 100.8806;
		case 29: return 462.7025;
		case 30: return 26.0428;
		case 31: return 33.278;
		case 32: return 125.7742;
		case 33: return 70.2516;
		case 34: return 223.5712;
		case 35: return 140.9966;
		case 36: return 33.3216;
		case 37: return 0.3826;
		case 38: return 9.9931;
		case 39: return 0.0;
		case 40: return 24.6277;
		case 41: return 1.1782;
		case 42: return 17.7745;
		case 43: return 0.0;
		case 44: return 165.6251;
		case 45: return 110.1459;
		case 46: return 114.5724;
		case 47: return 640.8249;
		case 48: return 119.8463;
		case 49: return 309.2923;
		case 50: return 2172.0281;
		case 51: return 236.1443;
		case 52: return 988.1157;
		case 53: return 132.6192;
		case 54: return 8322.3573;
		case 55: return 7432.5132;
		case 56: return 668.5909;
		case 57: return 157.0134;
		case 58: return 88.7463;
		case 59: return 435.6916;
		case 60: return 1276.2663;
		case 61: return 2152.4068;
		case 62: return 3036.9442;
		case 63: return 5494.2985;
		case 64: return 3136.2059;
		case 65: return 4585.2456;
		case 66: return 5821.1648;
		case 67: return 3337.3596;
		case 68: return 3245.0605;
		case 69: return 5546.811;
		case 70: return 4011.0084;
		case 71: return 7007.3941;
		case 72: return 4804.9543;
		case 73: return 5253.8681;
		case 74: return 9104.2412;
		case 75: return 5981.1307;
		case 76: return 7714.3667;
		case 77: return 5168.0915;
		case 78: return 5713.7337;
		case 79: return 8497.8882;
		case 80: return 5689.7018;
		case 81: return 5306.3356;
		case 82: return 4266.1281;
		case 83: return 4759.1475;
		case 84: return 10059.386;
		case 85: return 6830.1646;
		case 86: return 6395.9648;
		case 87: return 5842.1947;
		case 88: return 7135.9897;
		case 89: return 4923.0003;
		case 90: return 9250.4479;
		case 91: return 6643.2122;
		case 92: return 4712.7865;
		case 93: return 5874.3865;
		case 94: return 5165.2185;
		case 95: return 6509.0771;
		case 96: return 5817.7646;
		case 97: return 5996.8558;
		case 98: return 6014.2312;
		case 99: return 7780.2057;
		case 100: return 5139.7681;
		case 101: return 5730.9668;
		case 102: return 8402.8476;
		case 103: return 5640.3683;
		case 104: return 5434.191;
		case 105: return 4310.922;
		case 106: return 4689.9895;
		case 107: return 9955.5047;
		case 108: return 6779.1354;
		case 109: return 6434.8869;
		case 110: return 5829.1784;
		case 111: return 7069.0643;
		case 112: return 4864.7725;
		case 113: return 9164.5675;
		case 114: return 6641.4688;
		case 115: return 4728.0803;
		case 116: return 5837.2494;
		case 117: return 5181.0739;
		case 118: return 6581.734;
		case 119: return 5698.6323;
		case 120: return 5934.2534;
		case 121: return 5818.5249;
		case 122: return 4059.2744;
		case 123: return 6293.2476;
		case 124: return 5788.7381;
		case 125: return 5023.26;
		case 126: return 5763.6511;
		case 127: return 7978.1718;
		case 128: return 5560.4409;
		case 129: return 7303.329;
		case 130: return 7538.4912;
		case 131: return 9699.7072;
		case 132: return 6400.1522;
		case 133: return 5157.6518;
		case 134: return 5821.0391;
		case 135: return 7509.5778;
		case 136: return 6951.3082;
		case 137: return 4643.7038;
		case 138: return 6688.7481;
		case 139: return 6233.424;
		case 140: return 7135.0519;
		case 141: return 7897.4095;
		case 142: return 11863.9296;
		case 143: return 4021.0106;
		case 144: return 5261.6504;
		case 145: return 4730.1875;
		case 146: return 5998.4946;
		case 147: return 4627.4944;
		case 148: return 11177.0007;
		case 149: return 7646.0643;
		case 150: return 4709.8763;
		case 151: return 3958.1588;
		case 152: return 8105.8169;
		case 153: return 555.5173;
		case 154: return 849.9111;
		case 155: return 497.7862;
		case 156: return 520.7626;
		case 157: return 337.4846;
		case 158: return 659.9023;
		case 159: return 159.138;
		case 160: return 358.9299;
		}
		return -1;
	}
}