/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku;

import org.mariuszgromada.math.janetsudoku.DigitRandomSeed;

class EmptyCell {
    public static final int CELL_ID = 0;
    int rowIndex = -1;
    int colIndex = -1;
    int[] digitsStillFree = new int[10];
    DigitRandomSeed[] digitsRandomSeed = new DigitRandomSeed[10];
    int digitsStillFreeNumber;
    double randomSeed;

    public EmptyCell() {
        int i = 0;
        while (i < 10) {
            this.digitsRandomSeed[i] = new DigitRandomSeed();
            this.digitsRandomSeed[i].digit = i;
            this.digitsRandomSeed[i].randomSeed = Math.random();
            ++i;
        }
        this.sortDigitsRandomSeed(1, 9);
        this.randomSeed = Math.random();
        this.setAllDigitsStillFree();
    }

    private void sortDigitsRandomSeed(int l, int r) {
        int i = l;
        int j = r;
        DigitRandomSeed x = this.digitsRandomSeed[(l + r) / 2];
        while (true) {
            if (this.digitsRandomSeed[i].randomSeed < x.randomSeed) {
                ++i;
                continue;
            }
            while (this.digitsRandomSeed[j].randomSeed > x.randomSeed) {
                --j;
            }
            if (i <= j) {
                DigitRandomSeed w = this.digitsRandomSeed[i];
                this.digitsRandomSeed[i] = this.digitsRandomSeed[j];
                this.digitsRandomSeed[j] = w;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.sortDigitsRandomSeed(l, j);
        }
        if (i < r) {
            this.sortDigitsRandomSeed(i, r);
        }
    }

    public void setAllDigitsStillFree() {
        int i = 0;
        while (i < 10) {
            this.digitsStillFree[i] = 1;
            ++i;
        }
        this.digitsStillFreeNumber = 0;
    }

    int order() {
        return this.digitsStillFreeNumber;
    }

    double orderPlusRndSeed() {
        return (double)this.digitsStillFreeNumber + this.randomSeed;
    }
}

