/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku;

import org.mariuszgromada.math.janetsudoku.SudokuStore;

public final class ErrorCodes {
    public static final int SUDOKUSOLVER_LOADBOARD_LOADING_FAILED = -100;
    public static final int SUDOKUSOLVER_SOLVE_SOLVING_NOT_STARTED = -101;
    public static final int SUDOKUSOLVER_SOLVE_SOLVING_FAILED = -102;
    public static final int SUDOKUSOLVER_FINDALLSOLUTIONS_SEARCHING_NOT_STARTED = -103;
    public static final int SUDOKUSOLVER_CHECKIFUNIQUESOLUTION_CHECKING_NOT_STARTED = -104;
    public static final int SUDOKUSOLVER_SETCELL_INCORRECT_DEFINITION = -105;
    public static final int SUDOKUSOLVER_GETCELLDIGIT_INCORRECT_INDEX = -106;
    public static final int SUDOKUSTORE_BOARDSEGMENTSTARTINDEX_INCORRECT_SEGMENT = -107;
    public static final int SUDOKUSTORE_RANDOMINDEX_INCORRECT_PARAMETER = -108;
    public static final int SUDOKUSTORE_RANDOMNUMBER_INCORRECT_PARAMETER = -109;
    public static final int SUDOKUSOLVER_BOARD_ERROR = -110;
    public static final int SUDOKUSTORE_CALCULATEPUZZLERATING_PUZZLE_ERROR = -111;
    public static final int SUDOKUSTORE_CALCULATEPUZZLERATING_NO_SOLUTION = -112;
    public static final int SUDOKUSTORE_CALCULATEPUZZLERATING_NON_UNIQUE_SOLUTION = -113;
    public static final int SUDOKUSTORE_CALCULATEPUZZLERATING_THREADS_JOIN_FAILED = -114;
    public static final String SUDOKUSOLVER_LOADBOARD_LOADING_FAILED_MSG = "Failed loading sudoku board.";
    public static final String SUDOKUSOLVER_SOLVE_SOLVING_NOT_STARTED_MSG = "Sudoku solving process not started - board is not ready.";
    public static final String SUDOKUSOLVER_SOLVE_SOLVING_FAILED_MSG = "Sudoku solving process started, but failed - board contains an error?";
    public static final String SUDOKUSOLVER_FINDALLSOLUTIONS_SEARCHING_NOT_STARTED_MSG = "Searching for all solutions not started = board is not ready.";
    public static final String SUDOKUSOLVER_CHECKIFUNIQUESOLUTION_CHECKING_NOT_STARTED_MSG = "Checking if only unique solution exists not started - board is not ready.";
    public static final String SUDOKUSOLVER_SETCELL_INCORRECT_DEFINITION_MSG = "Trying to access the cell, but definition contains an error.";
    public static final String SUDOKUSOLVER_GETCELLDIGIT_INCORRECT_INDEX_MSG = "Trying to access the cell, but index out of board range.";
    public static final String SUDOKUSTORE_BOARDSEGMENTSTARTINDEX_INCORRECT_SEGMENT_MSG = "Incorrect board segment index - should be betweem 0 and 2.";
    public static final String SUDOKUSTORE_RANDOMINDEX_INCORRECT_PARAMETER_MSG = "Parameter can not be negative.";
    public static final String SUDOKUSTORE_RANDOMNUMBER_INCORRECT_PARAMETER_MSG = "Parameter has to be positive.";
    public static final String SUDOKUSOLVER_BOARD_ERROR_MSG = "Sudoku board contains an error.";
    public static final String SUDOKUSTORE_CALCULATEPUZZLERATING_PUZZLE_ERROR_MSG = "Puzzle contains obvious puzzle error.";
    public static final String SUDOKUSTORE_CALCULATEPUZZLERATING_NO_SOLUTION_MSG = "Puzzle solution does not exist.";
    public static final String SUDOKUSTORE_CALCULATEPUZZLERATING_NON_UNIQUE_SOLUTION_MSG = "Puzzle has non-unique solution.";
    public static final String SUDOKUSTORE_CALCULATEPUZZLERATING_THREADS_JOIN_FAILED_MSG = "Threads join failed.";
    public static final String ERROR_CODE_UNKNOWN_MSG = "Incorrect error code.";

    public static final String getErrorDescription(int errorCode) {
        switch (errorCode) {
            case -100: {
                return SUDOKUSOLVER_LOADBOARD_LOADING_FAILED_MSG;
            }
            case -101: {
                return SUDOKUSOLVER_SOLVE_SOLVING_NOT_STARTED_MSG;
            }
            case -102: {
                return SUDOKUSOLVER_SOLVE_SOLVING_FAILED_MSG;
            }
            case -103: {
                return SUDOKUSOLVER_FINDALLSOLUTIONS_SEARCHING_NOT_STARTED_MSG;
            }
            case -104: {
                return SUDOKUSOLVER_CHECKIFUNIQUESOLUTION_CHECKING_NOT_STARTED_MSG;
            }
            case -105: {
                return SUDOKUSOLVER_SETCELL_INCORRECT_DEFINITION_MSG;
            }
            case -106: {
                return SUDOKUSOLVER_GETCELLDIGIT_INCORRECT_INDEX_MSG;
            }
            case -107: {
                return SUDOKUSTORE_BOARDSEGMENTSTARTINDEX_INCORRECT_SEGMENT_MSG;
            }
            case -108: {
                return SUDOKUSTORE_RANDOMINDEX_INCORRECT_PARAMETER_MSG;
            }
            case -109: {
                return SUDOKUSTORE_RANDOMNUMBER_INCORRECT_PARAMETER_MSG;
            }
            case -110: {
                return SUDOKUSOLVER_BOARD_ERROR_MSG;
            }
            case -111: {
                return SUDOKUSTORE_CALCULATEPUZZLERATING_PUZZLE_ERROR_MSG;
            }
            case -112: {
                return SUDOKUSTORE_CALCULATEPUZZLERATING_NO_SOLUTION_MSG;
            }
            case -113: {
                return SUDOKUSTORE_CALCULATEPUZZLERATING_NON_UNIQUE_SOLUTION_MSG;
            }
            case -114: {
                return SUDOKUSTORE_CALCULATEPUZZLERATING_THREADS_JOIN_FAILED_MSG;
            }
        }
        return ERROR_CODE_UNKNOWN_MSG;
    }

    public static final boolean errorCodeExists(int errorCode) {
        switch (errorCode) {
            case -100: {
                return true;
            }
            case -101: {
                return true;
            }
            case -102: {
                return true;
            }
            case -103: {
                return true;
            }
            case -104: {
                return true;
            }
            case -105: {
                return true;
            }
            case -106: {
                return true;
            }
            case -107: {
                return true;
            }
            case -108: {
                return true;
            }
            case -109: {
                return true;
            }
            case -110: {
                return true;
            }
        }
        return false;
    }

    public static final void consolePrintlnIfError(int errorCode) {
        if (ErrorCodes.errorCodeExists(errorCode)) {
            SudokuStore.consolePrintln(ErrorCodes.getErrorDescription(errorCode));
        }
    }
}

