/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku;

import java.util.ArrayList;
import org.mariuszgromada.math.janetsudoku.BoardCell;
import org.mariuszgromada.math.janetsudoku.SubSquare;
import org.mariuszgromada.math.janetsudoku.SudokuPuzzles;
import org.mariuszgromada.math.janetsudoku.SudokuSolver;
import org.mariuszgromada.math.janetsudoku.SudokuStore;
import org.mariuszgromada.math.janetsudoku.utils.DateTimeX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SudokuGenerator {
    public static final char PARAM_GEN_RND_BOARD = '1';
    public static final char PARAM_DO_NOT_SOLVE = '2';
    public static final char PARAM_DO_NOT_TRANSFORM = '3';
    private boolean generateRandomBoard;
    private boolean transformBeforeGeneration;
    private boolean solveBeforeGeneration;
    private static final int BOARD_SIZE = 9;
    private static final int BOARD_CELLS_NUMBER = 81;
    private static final int CELL_EMPTY = 0;
    private static final int DIGIT_STILL_FREE = 1;
    private static final int DIGIT_IN_USE = 2;
    private boolean randomizeFilledCells;
    private int[][] sudokuBoard;
    private BoardCell[] boardCells;
    private static final int MSG_INFO = 1;
    private static final int MSG_ERROR = -1;
    private String messages = "";
    private String lastMessage = "";
    private String lastErrorMessage = "";
    private double computingTime;
    private int generatorState;
    public static final int GENERATOR_INIT_STARTED = 1;
    public static final int GENERATOR_INIT_FINISHED = 2;
    public static final int GENERATOR_INIT_FAILED = -1;
    public static final int GENERATOR_GEN_NOT_STARTED = -2;
    public static final int GENERATOR_GEN_STARTED = 3;
    public static final int GENERATOR_GEN_FINISHED = 4;
    public static final int GENERATOR_GEN_FAILED = -3;

    private void initInternalVars() {
        this.generatorState = 1;
        this.randomizeFilledCells = true;
        this.computingTime = 0.0;
    }

    private void setParameters(char ... parameters) {
        this.generateRandomBoard = false;
        this.solveBeforeGeneration = true;
        this.transformBeforeGeneration = true;
        if (parameters != null && parameters.length > 0) {
            char[] cArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                char p = cArray[n2];
                switch (p) {
                    case '1': {
                        this.generateRandomBoard = true;
                        break;
                    }
                    case '2': {
                        this.solveBeforeGeneration = false;
                        break;
                    }
                    case '3': {
                        this.transformBeforeGeneration = false;
                    }
                }
                ++n2;
            }
        }
    }

    private void boardInit(int[][] initBoard, String info) {
        if (initBoard == null && this.generateRandomBoard) {
            SudokuSolver puzzle = new SudokuSolver(SudokuPuzzles.PUZZLE_EMPTY);
            puzzle.solve();
            if (puzzle.getSolvingState() == 3) {
                this.sudokuBoard = puzzle.solvedBoard;
                this.addMessage("(SudokuGenerator) Generator initialized using random board (" + info + ").", 1);
                this.generatorState = 2;
                return;
            }
            this.addMessage("(SudokuGenerator) Generator initialization using random board (" + info + ") failed. Board with error?", -1);
            this.addMessage(puzzle.getLastErrorMessage(), -1);
            this.generatorState = -1;
            return;
        }
        if (!SudokuStore.checkPuzzle(initBoard)) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator initialization (" + info + ") failed. Board with error?", -1);
            return;
        }
        if (this.solveBeforeGeneration) {
            SudokuSolver puzzle = new SudokuSolver(initBoard);
            puzzle.solve();
            if (puzzle.getSolvingState() == 3) {
                this.sudokuBoard = puzzle.solvedBoard;
                this.addMessage("(SudokuGenerator) Generator initialized usign provided board + finding solution (" + info + ").", 1);
                this.generatorState = 2;
                return;
            }
            this.addMessage("(SudokuGenerator) Generator initialization usign provided board + finding solution (" + info + ") failed. Board with error?", -1);
            this.addMessage(puzzle.getLastErrorMessage(), -1);
            this.generatorState = -1;
            return;
        }
        int[][] board = initBoard;
        SudokuSolver puzzle = new SudokuSolver(board);
        if (puzzle.checkIfUniqueSolution() == 1) {
            this.sudokuBoard = board;
            this.addMessage("(SudokuGenerator) Generator initialized usign provided board (" + info + ").", 1);
            this.generatorState = 2;
            return;
        }
        this.addMessage("(SudokuGenerator) Generator initialization usign provided board (" + info + ") failed. Solution not exists or is non unique.", -1);
        this.addMessage(puzzle.getLastErrorMessage(), -1);
        this.generatorState = -1;
    }

    public SudokuGenerator(char ... parameters) {
        this.setParameters(parameters);
        this.initInternalVars();
        if (this.generateRandomBoard) {
            this.boardInit(null, "random board");
        } else {
            int example = SudokuStore.randomIndex(161);
            int[][] board = SudokuStore.boardCopy(SudokuStore.getPuzzleExample(example));
            if (this.transformBeforeGeneration) {
                this.boardInit(SudokuStore.seqOfRandomBoardTransf(board), "transformed example: " + example);
            } else {
                this.boardInit(board, "example: " + example);
            }
        }
    }

    public SudokuGenerator(int example, char ... parameters) {
        this.setParameters(parameters);
        this.initInternalVars();
        if (example >= 0 && example < 161) {
            int[][] board = SudokuStore.boardCopy(SudokuStore.getPuzzleExample(example));
            if (this.transformBeforeGeneration) {
                this.boardInit(SudokuStore.seqOfRandomBoardTransf(board), "transformed example: " + example);
            } else {
                this.boardInit(board, "example: " + example);
            }
        } else {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized incorrect example number: " + example + " - should be between 1 and " + 161 + ".", -1);
        }
    }

    public SudokuGenerator(int[][] initialBoard, char ... parameters) {
        this.setParameters(parameters);
        this.initInternalVars();
        if (initialBoard == null) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - null initial board.", -1);
        } else if (initialBoard.length != 9) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - incorrect number of rows in initial board, is: " + initialBoard.length + ",  expected: " + 9 + ".", -1);
        } else if (initialBoard[0].length != 9) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - incorrect number of columns in initial board, is: " + initialBoard[0].length + ", expected: " + 9 + ".", -1);
        } else if (!SudokuStore.checkPuzzle(initialBoard)) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - initial board contains an error.", -1);
        } else {
            int[][] board = SudokuStore.boardCopy(initialBoard);
            if (this.transformBeforeGeneration) {
                this.boardInit(SudokuStore.seqOfRandomBoardTransf(board), "transformed board provided by the user");
            } else {
                this.boardInit(board, "board provided by the user");
            }
        }
    }

    public SudokuGenerator(String boardFilePath, char ... parameters) {
        this.setParameters(parameters);
        this.initInternalVars();
        if (boardFilePath == null) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - null board file path.", -1);
        } else if (boardFilePath.length() == 0) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - blank board file path.", -1);
        } else {
            int[][] board = SudokuStore.loadBoard(boardFilePath);
            if (this.transformBeforeGeneration) {
                this.boardInit(SudokuStore.seqOfRandomBoardTransf(board), "transformed board provided by the user");
            } else {
                this.boardInit(board, "board provided by the user");
            }
        }
    }

    public SudokuGenerator(String[] boardDefinition, char ... parameters) {
        this.setParameters(parameters);
        this.initInternalVars();
        if (boardDefinition == null) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - null board definition.", -1);
        } else if (boardDefinition.length == 0) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - blank board definition.", -1);
        } else {
            int[][] board = SudokuStore.loadBoard(boardDefinition);
            if (this.transformBeforeGeneration) {
                this.boardInit(SudokuStore.seqOfRandomBoardTransf(board), "transformed board provided by the user");
            } else {
                this.boardInit(board, "board provided by the user");
            }
        }
    }

    public SudokuGenerator(ArrayList<String> boardDefinition, char ... parameters) {
        this.setParameters(parameters);
        this.initInternalVars();
        if (boardDefinition == null) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - null board definition.", -1);
        } else if (boardDefinition.size() == 0) {
            this.generatorState = -1;
            this.addMessage("(SudokuGenerator) Generator not initialized - blank board definition.", -1);
        } else {
            int[][] board = SudokuStore.loadBoard(boardDefinition);
            if (this.transformBeforeGeneration) {
                this.boardInit(SudokuStore.seqOfRandomBoardTransf(board), "transformed board provided by the user");
            } else {
                this.boardInit(board, "board provided by the user");
            }
        }
    }

    public int[][] generate() {
        if (this.generatorState != 2) {
            this.generatorState = -2;
            this.addMessage("(SudokuGenerator) Generation process not started due to incorrect initialization.", -1);
            return null;
        }
        long solvingStartTime = DateTimeX.currentTimeMillis();
        this.generatorState = 3;
        this.addMessage("(SudokuGenerator) Generation process started.", 1);
        if (this.randomizeFilledCells) {
            this.addMessage("(SudokuGenerator) >>> Will randomize filled cells within cells with the same impact.", 1);
        }
        this.boardCells = new BoardCell[81];
        int cellIndex = 0;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                int d = this.sudokuBoard[i][j];
                if (d != 0) {
                    this.boardCells[cellIndex] = new BoardCell(i, j, d);
                    ++cellIndex;
                }
                ++j;
            }
            ++i;
        }
        int filledCells = cellIndex;
        int i2 = 0;
        while (i2 < 9) {
            int j = 0;
            while (j < 9) {
                int d = this.sudokuBoard[i2][j];
                if (d == 0) {
                    this.boardCells[cellIndex] = new BoardCell(i2, j, d);
                    ++cellIndex;
                }
                ++j;
            }
            ++i2;
        }
        this.updateDigitsStillFreeCounts();
        this.sortBoardCells(0, filledCells - 1);
        do {
            int lastIndex;
            int r = 0;
            int i3 = this.boardCells[r].rowIndex;
            int j = this.boardCells[r].colIndex;
            int d = this.sudokuBoard[i3][j];
            this.sudokuBoard[i3][j] = 0;
            SudokuSolver s = new SudokuSolver(this.sudokuBoard);
            if (s.checkIfUniqueSolution() != 1) {
                this.sudokuBoard[i3][j] = d;
            }
            if (r < (lastIndex = filledCells - 1)) {
                BoardCell b1 = this.boardCells[r];
                BoardCell b2 = this.boardCells[lastIndex];
                this.boardCells[lastIndex] = b1;
                this.boardCells[r] = b2;
            }
            this.updateDigitsStillFreeCounts();
            if (--filledCells <= 0) continue;
            this.sortBoardCells(0, filledCells - 1);
        } while (filledCells > 0);
        long solvingEndTime = DateTimeX.currentTimeMillis();
        this.computingTime = (double)(solvingEndTime - solvingStartTime) / 1000.0;
        this.generatorState = 4;
        this.addMessage("(SudokuGenerator) Generation process finished, computing time: " + this.computingTime + " s.", 1);
        return this.sudokuBoard;
    }

    public boolean saveBoard(String filePath) {
        boolean savingStatus = SudokuStore.saveBoard(this.sudokuBoard, filePath);
        if (savingStatus) {
            this.addMessage("(saveBoard) Saving successful, file: " + filePath, 1);
        } else {
            this.addMessage("(saveBoard) Saving failed, file: " + filePath, -1);
        }
        return savingStatus;
    }

    public boolean saveBoard(String filePath, String headComment) {
        boolean savingStatus = SudokuStore.saveBoard(this.sudokuBoard, filePath, headComment);
        if (savingStatus) {
            this.addMessage("(saveBoard) Saving successful, file: " + filePath, 1);
        } else {
            this.addMessage("(saveBoard) Saving failed, file: " + filePath, -1);
        }
        return savingStatus;
    }

    public boolean saveBoard(String filePath, String headComment, String tailComment) {
        boolean savingStatus = SudokuStore.saveBoard(this.sudokuBoard, filePath, headComment, tailComment);
        if (savingStatus) {
            this.addMessage("(saveBoard) Saving successful, file: " + filePath, 1);
        } else {
            this.addMessage("(saveBoard) Saving failed, file: " + filePath, -1);
        }
        return savingStatus;
    }

    private void updateDigitsStillFreeCounts() {
        int i = 0;
        while (i < 81) {
            this.countDigitsStillFree(this.boardCells[i]);
            ++i;
        }
    }

    private void countDigitsStillFree(BoardCell boardCell) {
        int boardDigit;
        int[] digitsStillFree = new int[10];
        int emptyCellsNumber = 0;
        int j = 0;
        while (j < 9) {
            boardDigit = this.sudokuBoard[boardCell.rowIndex][j];
            if (boardDigit != 0) {
                digitsStillFree[boardDigit] = 2;
            } else if (j != boardCell.colIndex) {
                ++emptyCellsNumber;
            }
            ++j;
        }
        int i = 0;
        while (i < 9) {
            boardDigit = this.sudokuBoard[i][boardCell.colIndex];
            if (boardDigit != 0) {
                digitsStillFree[boardDigit] = 2;
            } else if (i != boardCell.rowIndex) {
                ++emptyCellsNumber;
            }
            ++i;
        }
        SubSquare sub = SubSquare.getSubSqare(boardCell);
        int i2 = sub.rowMin;
        while (i2 < sub.rowMax) {
            int j2 = sub.colMin;
            while (j2 < sub.colMax) {
                int boardDigit2 = this.sudokuBoard[i2][j2];
                if (boardDigit2 != 0) {
                    digitsStillFree[boardDigit2] = 2;
                } else if (i2 != boardCell.rowIndex && j2 != boardCell.colIndex) {
                    ++emptyCellsNumber;
                }
                ++j2;
            }
            ++i2;
        }
        digitsStillFree[boardCell.digit] = 0;
        boardCell.digitsStillFreeNumber = emptyCellsNumber;
        int digit = 1;
        while (digit < 10) {
            if (digitsStillFree[digit] == 1) {
                ++boardCell.digitsStillFreeNumber;
            }
            ++digit;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sortBoardCells(int l, int r) {
        i = l;
        j = r;
        x = this.boardCells[(l + r) / 2];
        do {
            block7: {
                if (!this.randomizeFilledCells) ** GOTO lbl14
                while (this.boardCells[i].orderPlusRndSeed() < x.orderPlusRndSeed()) {
                    ++i;
                }
                while (this.boardCells[j].orderPlusRndSeed() > x.orderPlusRndSeed()) {
                    --j;
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    ++i;
lbl14:
                    // 2 sources

                    ** while (this.boardCells[i].order() < x.order())
                }
lbl15:
                // 2 sources

                while (this.boardCells[j].order() > x.order()) {
                    --j;
                }
            }
            if (i > j) continue;
            w = this.boardCells[i];
            this.boardCells[i] = this.boardCells[j];
            this.boardCells[j] = w;
            ++i;
            --j;
        } while (i <= j);
        if (l < j) {
            this.sortBoardCells(l, j);
        }
        if (i < r) {
            this.sortBoardCells(i, r);
        }
    }

    public void enableRndSeedOnFilledCells() {
        this.randomizeFilledCells = true;
    }

    public void disableRndSeedOnFilledCells() {
        this.randomizeFilledCells = false;
    }

    private void addMessage(String msg, int msgType) {
        String vdt = "[Janet-Sudoku-v.1.1.1][" + DateTimeX.getCurrDateTimeStr() + "]";
        String mt = "(msg)";
        if (msgType == -1) {
            mt = "(error)";
            this.lastErrorMessage = msg;
        }
        this.messages = String.valueOf(this.messages) + SudokuStore.NEW_LINE_SEPARATOR + vdt + mt + " " + msg;
        this.lastMessage = msg;
    }

    public String getMessages() {
        return this.messages;
    }

    public void clearMessages() {
        this.messages = "";
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public int getGeneratorState() {
        return this.generatorState;
    }
}

