/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku;

import java.util.ArrayList;
import java.util.Stack;
import org.mariuszgromada.math.janetsudoku.BoardCell;
import org.mariuszgromada.math.janetsudoku.EmptyCell;
import org.mariuszgromada.math.janetsudoku.SubSquare;
import org.mariuszgromada.math.janetsudoku.SudokuBoard;
import org.mariuszgromada.math.janetsudoku.SudokuStore;
import org.mariuszgromada.math.janetsudoku.utils.ArrayX;
import org.mariuszgromada.math.janetsudoku.utils.DateTimeX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SudokuSolver {
    public static final int SOLVING_STATE_NOT_STARTED = 1;
    public static final int SOLVING_STATE_STARTED = 2;
    public static final int SOLVING_STATE_SOLVED = 3;
    public static final int SOLUTION_NOT_EXISTS = -1;
    public static final int SOLUTION_UNIQUE = 1;
    public static final int SOLUTION_NON_UNIQUE = 2;
    private static final int MSG_INFO = 1;
    private static final int MSG_ERROR = -1;
    private static final int BOARD_SIZE = 9;
    private static final int BOARD_CELLS_NUMBER = 81;
    private static final int BOARD_STATE_EMPTY = 1;
    private static final int BOARD_STATE_LOADED = 2;
    private static final int BOARD_STATE_READY = 3;
    private static final int BOARD_STATE_ERROR = -110;
    private static final int CELL_EMPTY = 0;
    private static final int DIGIT_STILL_FREE = 1;
    private static final int DIGIT_IN_USE = 2;
    private static final int INDEX_NULL = -1;
    int[][] sudokuBoard = new int[9][9];
    int[][] solvedBoard = null;
    private int[][] boardBackup = new int[9][9];
    private Stack<BoardCell> solutionPath;
    private ArrayList<SudokuBoard> solutionsList;
    private int boardState;
    private int solvingState;
    private double computingTime;
    private int closedPathsCounter;
    private int totalPathsCounter;
    private boolean randomizeEmptyCells;
    private boolean randomizeFreeDigits;
    private EmptyCell[] emptyCells = new EmptyCell[81];
    private EmptyCell[][] emptyCellsPointer = new EmptyCell[9][9];
    private int emptyCellsNumber;
    private String messages = "";
    private String lastMessage = "";
    private String lastErrorMessage = "";
    private int solutionNumber;

    public SudokuSolver() {
        this.clearPuzzels();
        this.randomizeEmptyCells = true;
        this.randomizeFreeDigits = true;
        this.findEmptyCells();
    }

    public SudokuSolver(int exampleNumber) {
        this.clearPuzzels();
        this.randomizeEmptyCells = true;
        this.randomizeFreeDigits = true;
        this.loadBoard(exampleNumber);
    }

    public SudokuSolver(String filePath) {
        this.clearPuzzels();
        this.randomizeEmptyCells = true;
        this.randomizeFreeDigits = true;
        this.loadBoard(filePath);
    }

    public SudokuSolver(String[] boardDefinition) {
        this.clearPuzzels();
        this.randomizeEmptyCells = true;
        this.randomizeFreeDigits = true;
        this.loadBoard(this.sudokuBoard);
    }

    public SudokuSolver(ArrayList<String> boardDefinition) {
        this.clearPuzzels();
        this.randomizeEmptyCells = true;
        this.randomizeFreeDigits = true;
        this.loadBoard(boardDefinition);
    }

    public SudokuSolver(int[][] sudokuBoard) {
        this.clearPuzzels();
        this.randomizeEmptyCells = true;
        this.randomizeFreeDigits = true;
        this.loadBoard(sudokuBoard);
    }

    public int loadBoard(int exampleNumber) {
        if (exampleNumber < 0 || exampleNumber > 161) {
            this.addMessage("(loadBoard) Loading failed - example number should be between 0 and 160", -1);
            return -100;
        }
        if (this.boardState != 1) {
            this.clearPuzzels();
        }
        int[][] loadedBoard = SudokuStore.getPuzzleExample(exampleNumber);
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.sudokuBoard[i][j] = loadedBoard[i][j];
                ++j;
            }
            ++i;
        }
        this.boardState = 2;
        this.addMessage("(loadBoard) Sudoku example board " + exampleNumber + " loaded", 1);
        return this.findEmptyCells();
    }

    public int loadBoard(String filePath) {
        int[][] loadedBoard = SudokuStore.loadBoard(filePath);
        if (loadedBoard == null) {
            this.addMessage("(loadBoard) Loading from file failed: " + filePath, -1);
            return -100;
        }
        if (this.boardState != 1) {
            this.clearPuzzels();
        }
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.sudokuBoard[i][j] = loadedBoard[i][j];
                ++j;
            }
            ++i;
        }
        this.boardState = 2;
        this.addMessage("(loadBoard) Sudoku loaded, file: " + filePath, 1);
        return this.findEmptyCells();
    }

    public int loadBoard(String[] boardDefinition) {
        int[][] loadedBoard = SudokuStore.loadBoard(boardDefinition);
        if (loadedBoard == null) {
            this.addMessage("(loadBoard) Loading from array of strings failed.", -1);
            return -100;
        }
        if (this.boardState != 1) {
            this.clearPuzzels();
        }
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.sudokuBoard[i][j] = loadedBoard[i][j];
                ++j;
            }
            ++i;
        }
        this.boardState = 2;
        this.addMessage("(loadBoard) Sudoku loaded from array of strings. ", 1);
        return this.findEmptyCells();
    }

    public int loadBoard(ArrayList<String> boardDefinition) {
        int[][] loadedBoard = SudokuStore.loadBoard(boardDefinition);
        if (loadedBoard == null) {
            this.addMessage("(loadBoard) Loading from list of strings failed.", -1);
            return -100;
        }
        if (this.boardState != 1) {
            this.clearPuzzels();
        }
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.sudokuBoard[i][j] = loadedBoard[i][j];
                ++j;
            }
            ++i;
        }
        this.boardState = 2;
        this.addMessage("(loadBoard) Sudoku loaded from list of strings. ", 1);
        return this.findEmptyCells();
    }

    public int loadBoard(int[][] sudokuBoard) {
        int j;
        if (sudokuBoard == null) {
            this.addMessage("(loadBoard) Loading from array failed - null array!", -1);
            return -100;
        }
        if (sudokuBoard.length != 9) {
            this.addMessage("(loadBoard) Loading from array failed - incorrect number of rows! " + sudokuBoard.length, -1);
            return -100;
        }
        int i = 0;
        while (i < sudokuBoard.length) {
            if (sudokuBoard[i].length != 9) {
                this.addMessage("(loadBoard) Loading from array failed - incorrect number of columns! " + sudokuBoard[i].length, -1);
                return -100;
            }
            ++i;
        }
        i = 0;
        while (i < 9) {
            j = 0;
            while (j < 9) {
                int d = sudokuBoard[i][j];
                if ((d < 1 || d > 9) && d != 0) {
                    this.addMessage("(loadBoard) Loading from array failed - incorrect digit: " + d, -1);
                    return -100;
                }
                ++j;
            }
            ++i;
        }
        if (this.boardState != 1) {
            this.clearPuzzels();
        }
        i = 0;
        while (i < 9) {
            j = 0;
            while (j < 9) {
                this.sudokuBoard[i][j] = sudokuBoard[i][j];
                ++j;
            }
            ++i;
        }
        this.boardState = 2;
        this.addMessage("(loadBoard) Sudoku loaded from array!", 1);
        return this.findEmptyCells();
    }

    public boolean saveBoard(String filePath) {
        boolean savingStatus = SudokuStore.saveBoard(this.sudokuBoard, filePath);
        if (savingStatus) {
            this.addMessage("(saveBoard) Saving successful, file: " + filePath, 1);
        } else {
            this.addMessage("(saveBoard) Saving failed, file: " + filePath, -1);
        }
        return savingStatus;
    }

    public boolean saveBoard(String filePath, String headComment) {
        boolean savingStatus = SudokuStore.saveBoard(this.sudokuBoard, filePath, headComment);
        if (savingStatus) {
            this.addMessage("(saveBoard) Saving successful, file: " + filePath, 1);
        } else {
            this.addMessage("(saveBoard) Saving failed, file: " + filePath, -1);
        }
        return savingStatus;
    }

    public boolean saveBoard(String filePath, String headComment, String tailComment) {
        boolean savingStatus = SudokuStore.saveBoard(this.sudokuBoard, filePath, headComment, tailComment);
        if (savingStatus) {
            this.addMessage("(saveBoard) Saving successful, file: " + filePath, 1);
        } else {
            this.addMessage("(saveBoard) Saving failed, file: " + filePath, -1);
        }
        return savingStatus;
    }

    public boolean saveSolvedBoard(String filePath) {
        boolean savingStatus = SudokuStore.saveBoard(this.solvedBoard, filePath);
        if (savingStatus) {
            this.addMessage("(saveSolvedBoard) Saving successful, file: " + filePath, 1);
        } else {
            this.addMessage("(saveSolvedBoard) Saving failed, file: " + filePath, -1);
        }
        return savingStatus;
    }

    public boolean saveSolvedBoard(String filePath, String headComment) {
        boolean savingStatus = SudokuStore.saveBoard(this.solvedBoard, filePath, headComment);
        if (savingStatus) {
            this.addMessage("(saveSolvedBoard) Saving successful, file: " + filePath, 1);
        } else {
            this.addMessage("(saveSolvedBoard) Saving failed, file: " + filePath, -1);
        }
        return savingStatus;
    }

    public boolean saveSolvedBoard(String filePath, String headComment, String tailComment) {
        boolean savingStatus = SudokuStore.saveBoard(this.solvedBoard, filePath, headComment, tailComment);
        if (savingStatus) {
            this.addMessage("(saveSolvedBoard) Saving successful, file: " + filePath, 1);
        } else {
            this.addMessage("(saveSolvedBoard) Saving failed, file: " + filePath, -1);
        }
        return savingStatus;
    }

    public int setCell(int rowIndex, int colIndex, int digit) {
        if (rowIndex < 0 || rowIndex >= 9) {
            this.addMessage("(setCell) Incorrect row index - is: " + rowIndex + ", should be between 0 and " + 9 + ".", -1);
            return -105;
        }
        if (colIndex < 0 || colIndex >= 9) {
            this.addMessage("(setCell) Incorrect colmn index - is: " + colIndex + ", should be between 0 and " + 9 + ".", -1);
            return -105;
        }
        if ((digit < 1 || digit > 9) && digit != 0) {
            this.addMessage("(setCell) Incorrect digit definition - is: " + digit + ", should be between 1 and 9, or " + 0 + " for empty cell", -1);
            return -105;
        }
        this.sudokuBoard[rowIndex][colIndex] = digit;
        return this.findEmptyCells();
    }

    public int getCellDigit(int rowIndex, int colIndex) {
        if (rowIndex < 0 || rowIndex >= 9) {
            this.addMessage("(getCellDigit) Incorrect row index - is: " + rowIndex + ", should be between 0 and " + 9 + ".", -1);
            return -106;
        }
        if (colIndex < 0 || colIndex >= 9) {
            this.addMessage("(getCellDigit) Incorrect colmn index - is: " + colIndex + ", should be between 0 and " + 9 + ".", -1);
            return -106;
        }
        return this.sudokuBoard[rowIndex][colIndex];
    }

    public int solve() {
        switch (this.boardState) {
            case 1: {
                this.addMessage("(solve) Nothing to solve - the board is empty!", -1);
                this.solvingState = 1;
                return -101;
            }
            case -110: {
                this.addMessage("(solve) Can not start solving process - the board contains an error!", -1);
                this.solvingState = 1;
                return -101;
            }
            case 2: {
                this.addMessage("(solve) Can not start solving process - the board is not ready!", -1);
                this.solvingState = 1;
                return -101;
            }
            case 3: {
                this.addMessage("(solve) Starting solving process!", 1);
                if (this.randomizeEmptyCells) {
                    this.addMessage("(solve) >>> Will randomize empty cells if number of still free digits is the same.", 1);
                }
                if (this.randomizeFreeDigits) {
                    this.addMessage("(solve) >>> Will randomize still free digits for a given empty cell.", 1);
                }
                this.solvingState = 2;
                this.solutionPath = new Stack();
                this.backupCurrentBoard();
                long solvingStartTime = DateTimeX.currentTimeMillis();
                this.closedPathsCounter = 0;
                this.solve(0);
                long solvingEndTime = DateTimeX.currentTimeMillis();
                this.computingTime = (double)(solvingEndTime - solvingStartTime) / 1000.0;
                if (this.solvingState != 3) {
                    this.solvingState = -102;
                    this.boardState = -110;
                    this.addMessage("(solve) Error while solving - no solutions found - setting board state as 'error' !!", -1);
                } else {
                    this.addMessage("(solve) Sudoku solved !!! Cells solved: " + this.emptyCellsNumber + " ... Closed routes: " + this.closedPathsCounter + " ... solving time: " + this.computingTime + " s.", 1);
                    this.emptyCellsNumber = 0;
                }
                this.restoreBoardFromBackup();
                return this.solvingState;
            }
        }
        this.addMessage("(solve) Can not start solving process - do not know why :-(. Please report bug!", -1);
        this.solvingState = 1;
        return -101;
    }

    private void solve(int level) {
        if (this.solvingState != 2) {
            return;
        }
        if (level == this.emptyCellsNumber) {
            this.solvingState = 3;
            this.solvedBoard = this.getBoardCopy();
            return;
        }
        EmptyCell emptyCell = this.emptyCells[level];
        int digitsStillFreeNumber = emptyCell.digitsStillFreeNumber;
        if (digitsStillFreeNumber > 0) {
            int digitNum = 0;
            int digitIndex = 1;
            while (digitIndex <= 9) {
                int digit = digitIndex;
                if (this.randomizeFreeDigits) {
                    digit = emptyCell.digitsRandomSeed[digitIndex].digit;
                }
                if (emptyCell.digitsStillFree[digit] == 1) {
                    ++digitNum;
                    this.sudokuBoard[emptyCell.rowIndex][emptyCell.colIndex] = digit;
                    if (level + 1 < this.emptyCellsNumber - 1) {
                        this.sortEmptyCells(level + 1, this.emptyCellsNumber - 1);
                    }
                    this.solutionPath.push(new BoardCell(emptyCell.rowIndex, emptyCell.colIndex, digit));
                    this.updateDigitsStillFree(emptyCell);
                    this.solve(level + 1);
                    if (this.solvingState == 2) {
                        this.solutionPath.pop();
                        if (digitNum == digitsStillFreeNumber) {
                            this.sudokuBoard[emptyCell.rowIndex][emptyCell.colIndex] = 0;
                            this.updateDigitsStillFree(emptyCell);
                            if (level < this.emptyCellsNumber - 1) {
                                this.sortEmptyCells(level, this.emptyCellsNumber - 1);
                            }
                            ++this.closedPathsCounter;
                        }
                    } else {
                        return;
                    }
                }
                ++digitIndex;
            }
        } else {
            this.sudokuBoard[emptyCell.rowIndex][emptyCell.colIndex] = 0;
            this.updateDigitsStillFree(emptyCell);
        }
    }

    public int findAllSolutions() {
        switch (this.boardState) {
            case 1: {
                this.addMessage("(findAllSolutions) Nothing to solve - the board is empty!", -1);
                return -103;
            }
            case -110: {
                this.addMessage("(findAllSolutions) Can not start solving process - the board contains an error!", -1);
                return -103;
            }
            case 2: {
                this.addMessage("(findAllSolutions) Can not start solving process - the board is not ready!", -1);
                return -103;
            }
            case 3: {
                this.addMessage("(findAllSolutions) Starting solving process!", 1);
                if (this.randomizeEmptyCells) {
                    this.addMessage("(findAllSolutions) >>> Will randomize empty cells if number of still free digits is the same.", 1);
                }
                if (this.randomizeFreeDigits) {
                    this.addMessage("(findAllSolutions) >>> Will randomize still free digits for a given empty cell.", 1);
                }
                this.solutionsList = new ArrayList();
                this.backupCurrentBoard();
                long solvingStartTime = DateTimeX.currentTimeMillis();
                this.totalPathsCounter = 0;
                this.findAllSolutions(0);
                long solvingEndTime = DateTimeX.currentTimeMillis();
                this.computingTime = (double)(solvingEndTime - solvingStartTime) / 1000.0;
                this.restoreBoardFromBackup();
                return this.solutionsList.size();
            }
        }
        this.addMessage("(findAllSolutions) Can not start solving process - do not know why :-(", -1);
        return -101;
    }

    private void findAllSolutions(int level) {
        if (level == this.emptyCellsNumber) {
            SudokuBoard solution = new SudokuBoard();
            solution.board = this.getBoardCopy();
            solution.pathNumber = this.totalPathsCounter;
            this.solutionsList.add(solution);
            return;
        }
        EmptyCell emptyCell = this.emptyCells[level];
        int digitsStillFreeNumber = emptyCell.digitsStillFreeNumber;
        if (digitsStillFreeNumber > 0) {
            int digitNum = 0;
            int digitIndex = 1;
            while (digitIndex <= 9) {
                int digit = digitIndex;
                if (this.randomizeFreeDigits) {
                    digit = emptyCell.digitsRandomSeed[digitIndex].digit;
                }
                if (emptyCell.digitsStillFree[digit] == 1) {
                    ++digitNum;
                    this.sudokuBoard[emptyCell.rowIndex][emptyCell.colIndex] = digit;
                    if (level + 1 < this.emptyCellsNumber - 1) {
                        this.sortEmptyCells(level + 1, this.emptyCellsNumber - 1);
                    }
                    this.updateDigitsStillFree(emptyCell);
                    this.findAllSolutions(level + 1);
                    if (digitNum == digitsStillFreeNumber) {
                        this.sudokuBoard[emptyCell.rowIndex][emptyCell.colIndex] = 0;
                        this.updateDigitsStillFree(emptyCell);
                        if (level < this.emptyCellsNumber - 1) {
                            this.sortEmptyCells(level, this.emptyCellsNumber - 1);
                        }
                        ++this.totalPathsCounter;
                    }
                }
                ++digitIndex;
            }
        } else {
            this.sudokuBoard[emptyCell.rowIndex][emptyCell.colIndex] = 0;
            this.updateDigitsStillFree(emptyCell);
        }
    }

    public int checkIfUniqueSolution() {
        switch (this.boardState) {
            case 1: {
                this.addMessage("(checkIfUniqueSolution) Nothing to solve - the board is empty!", -1);
                return -104;
            }
            case -110: {
                this.addMessage("(checkIfUniqueSolution) Can not start solving process - the board contains an error!", -1);
                return -104;
            }
            case 2: {
                this.addMessage("(checkIfUniqueSolution) Can not start solving process - the board is not ready!", -1);
                return -104;
            }
            case 3: {
                this.addMessage("(checkIfUniqueSolution) Starting solving process!", 1);
                if (this.randomizeEmptyCells) {
                    this.addMessage("(checkIfUniqueSolution) >>> Will randomize empty cells if number of still free digits is the same.", 1);
                }
                if (this.randomizeFreeDigits) {
                    this.addMessage("(checkIfUniqueSolution) >>> Will randomize still free digits for a given empty cell.", 1);
                }
                this.solutionNumber = 0;
                this.backupCurrentBoard();
                long solvingStartTime = DateTimeX.currentTimeMillis();
                this.totalPathsCounter = 0;
                this.checkIfUniqueSolution(0);
                long solvingEndTime = DateTimeX.currentTimeMillis();
                this.computingTime = (double)(solvingEndTime - solvingStartTime) / 1000.0;
                this.restoreBoardFromBackup();
                if (this.solutionNumber == 1) {
                    return 1;
                }
                if (this.solutionNumber == 2) {
                    return 2;
                }
                return -1;
            }
        }
        this.addMessage("(checkIfUniqueSolution) Can not start solving process - do not know why :-(", -1);
        return -104;
    }

    private void checkIfUniqueSolution(int level) {
        if (this.solutionNumber > 1) {
            return;
        }
        if (level == this.emptyCellsNumber) {
            ++this.solutionNumber;
            return;
        }
        EmptyCell emptyCell = this.emptyCells[level];
        int digitsStillFreeNumber = emptyCell.digitsStillFreeNumber;
        if (digitsStillFreeNumber > 0) {
            int digitNum = 0;
            int digitIndex = 1;
            while (digitIndex <= 9) {
                int digit = digitIndex;
                if (this.randomizeFreeDigits) {
                    digit = emptyCell.digitsRandomSeed[digitIndex].digit;
                }
                if (emptyCell.digitsStillFree[digit] == 1) {
                    ++digitNum;
                    this.sudokuBoard[emptyCell.rowIndex][emptyCell.colIndex] = digit;
                    if (level + 1 < this.emptyCellsNumber - 1) {
                        this.sortEmptyCells(level + 1, this.emptyCellsNumber - 1);
                    }
                    this.updateDigitsStillFree(emptyCell);
                    this.checkIfUniqueSolution(level + 1);
                    if (digitNum == digitsStillFreeNumber) {
                        this.sudokuBoard[emptyCell.rowIndex][emptyCell.colIndex] = 0;
                        this.updateDigitsStillFree(emptyCell);
                        if (level < this.emptyCellsNumber - 1) {
                            this.sortEmptyCells(level, this.emptyCellsNumber - 1);
                        }
                        ++this.totalPathsCounter;
                    }
                }
                ++digitIndex;
            }
        } else {
            this.sudokuBoard[emptyCell.rowIndex][emptyCell.colIndex] = 0;
            this.updateDigitsStillFree(emptyCell);
        }
    }

    private void backupCurrentBoard() {
        this.boardBackup = this.getBoardCopy();
    }

    private void restoreBoardFromBackup() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.sudokuBoard[i][j] = this.boardBackup[i][j];
                ++j;
            }
            ++i;
        }
        this.findEmptyCells();
    }

    public void clearPuzzels() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                this.sudokuBoard[i][j] = 0;
                this.emptyCellsPointer[i][j] = null;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 81) {
            this.emptyCells[i] = new EmptyCell();
            ++i;
        }
        this.emptyCellsNumber = 0;
        this.solvingState = 1;
        this.boardState = 1;
        this.solvedBoard = null;
        this.solutionPath = null;
        this.computingTime = 0.0;
        this.closedPathsCounter = 0;
        this.addMessage("(clearPuzzels) Clearing sudoku board - board is empty.", 1);
    }

    private void clearEmptyCells() {
        int i = 0;
        while (i < 81) {
            this.emptyCells[i].rowIndex = -1;
            this.emptyCells[i].colIndex = -1;
            this.emptyCells[i].digitsStillFreeNumber = -1;
            ++i;
        }
    }

    private int findEmptyCells() {
        this.clearEmptyCells();
        int emptyCellIndex = 0;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                if (this.sudokuBoard[i][j] == 0) {
                    this.emptyCells[emptyCellIndex].rowIndex = i;
                    this.emptyCells[emptyCellIndex].colIndex = j;
                    this.emptyCellsPointer[i][j] = this.emptyCells[emptyCellIndex];
                    this.findDigitsStillFree(this.emptyCells[emptyCellIndex]);
                    if (this.emptyCells[emptyCellIndex].digitsStillFreeNumber == 0) {
                        this.addMessage("Cell empty, but no still free digit to fill in - cell: " + i + ", " + j, -1);
                        return -110;
                    }
                    ++emptyCellIndex;
                }
                ++j;
            }
            ++i;
        }
        this.emptyCellsNumber = emptyCellIndex;
        this.addMessage("(findEmptyCells) Empty cells evaluated - number of cells to solve: " + this.emptyCellsNumber, 1);
        if (this.boardState == 1) {
            this.addMessage("(findEmptyCells) Empty board - please fill some values.", 1);
        } else if (this.emptyCellsNumber > 0) {
            this.sortEmptyCells(0, this.emptyCellsNumber - 1);
            this.boardState = 3;
        } else if (SudokuStore.checkSolvedBoard(this.sudokuBoard)) {
            this.addMessage("(findEmptyCells) Puzzle already solved. Marking as solved, but no path leading to the solution.", 1);
            this.boardState = 3;
            this.solvingState = 3;
            this.solvedBoard = SudokuStore.boardCopy(this.sudokuBoard);
        } else {
            this.addMessage("(findEmptyCells) No cells to solve + board error.", -1);
            this.boardState = -110;
            return -110;
        }
        if (!SudokuStore.checkPuzzle(this.sudokuBoard)) {
            this.addMessage("(findEmptyCells) Board contains an abvious error - duplicated digits.", -1);
            this.boardState = -110;
            return -110;
        }
        return 3;
    }

    private void findDigitsStillFree(EmptyCell emptyCell) {
        int boardDigit;
        emptyCell.setAllDigitsStillFree();
        int j = 0;
        while (j < 9) {
            boardDigit = this.sudokuBoard[emptyCell.rowIndex][j];
            if (boardDigit != 0) {
                emptyCell.digitsStillFree[boardDigit] = 2;
            }
            ++j;
        }
        int i = 0;
        while (i < 9) {
            boardDigit = this.sudokuBoard[i][emptyCell.colIndex];
            if (boardDigit != 0) {
                emptyCell.digitsStillFree[boardDigit] = 2;
            }
            ++i;
        }
        SubSquare sub = SubSquare.getSubSqare(emptyCell);
        int i2 = sub.rowMin;
        while (i2 < sub.rowMax) {
            int j2 = sub.colMin;
            while (j2 < sub.colMax) {
                int boardDigit2 = this.sudokuBoard[i2][j2];
                if (boardDigit2 != 0) {
                    emptyCell.digitsStillFree[boardDigit2] = 2;
                }
                ++j2;
            }
            ++i2;
        }
        emptyCell.digitsStillFreeNumber = 0;
        int digit = 1;
        while (digit < 10) {
            if (emptyCell.digitsStillFree[digit] == 1) {
                ++emptyCell.digitsStillFreeNumber;
            }
            ++digit;
        }
    }

    private void updateDigitsStillFree(EmptyCell emptyCell) {
        int j;
        int j2 = 0;
        while (j2 < 9) {
            if (this.sudokuBoard[emptyCell.rowIndex][j2] == 0) {
                this.findDigitsStillFree(this.emptyCellsPointer[emptyCell.rowIndex][j2]);
            }
            ++j2;
        }
        int i = 0;
        while (i < 9) {
            if (this.sudokuBoard[i][emptyCell.colIndex] == 0) {
                this.findDigitsStillFree(this.emptyCellsPointer[i][emptyCell.colIndex]);
            }
            ++i;
        }
        SubSquare sub = SubSquare.getSubSqare(emptyCell);
        int i2 = sub.rowMin;
        while (i2 < sub.rowMax) {
            j = sub.colMin;
            while (j < sub.colMax) {
                if (this.sudokuBoard[i2][j] == 0) {
                    this.findDigitsStillFree(this.emptyCellsPointer[i2][j]);
                }
                ++j;
            }
            ++i2;
        }
        i2 = sub.rowMin;
        while (i2 < sub.rowMax) {
            j = sub.colMin;
            while (j < sub.colMax) {
                int boardDigit = this.sudokuBoard[i2][j];
                if (boardDigit != 0) {
                    emptyCell.digitsStillFree[boardDigit] = 2;
                }
                ++j;
            }
            ++i2;
        }
        emptyCell.digitsStillFreeNumber = 0;
        int digit = 1;
        while (digit < 10) {
            if (emptyCell.digitsStillFree[digit] == 1) {
                ++emptyCell.digitsStillFreeNumber;
            }
            ++digit;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sortEmptyCells(int l, int r) {
        i = l;
        j = r;
        x = this.emptyCells[(l + r) / 2];
        do {
            block7: {
                if (!this.randomizeEmptyCells) ** GOTO lbl14
                while (this.emptyCells[i].orderPlusRndSeed() < x.orderPlusRndSeed()) {
                    ++i;
                }
                while (this.emptyCells[j].orderPlusRndSeed() > x.orderPlusRndSeed()) {
                    --j;
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    ++i;
lbl14:
                    // 2 sources

                    ** while (this.emptyCells[i].order() < x.order())
                }
lbl15:
                // 2 sources

                while (this.emptyCells[j].order() > x.order()) {
                    --j;
                }
            }
            if (i > j) continue;
            w = this.emptyCells[i];
            this.emptyCells[i] = this.emptyCells[j];
            this.emptyCells[j] = w;
            ++i;
            --j;
        } while (i <= j);
        if (l < j) {
            this.sortEmptyCells(l, j);
        }
        if (i < r) {
            this.sortEmptyCells(i, r);
        }
    }

    private void addMessage(String msg, int msgType) {
        String vdt = "[Janet-Sudoku-v.1.1.1][" + DateTimeX.getCurrDateTimeStr() + "]";
        String mt = "(msg)";
        if (msgType == -1) {
            mt = "(error)";
            this.lastErrorMessage = msg;
        }
        this.messages = String.valueOf(this.messages) + SudokuStore.NEW_LINE_SEPARATOR + vdt + mt + " " + msg;
        this.lastMessage = msg;
    }

    public String getMessages() {
        return this.messages;
    }

    public void clearMessages() {
        this.messages = "";
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public int getBoardState() {
        return this.boardState;
    }

    public int[][] getBoardCopy() {
        return SudokuStore.boardCopy(this.sudokuBoard);
    }

    public int getSolvingState() {
        return this.solvingState;
    }

    public int[][] getBoard() {
        return this.sudokuBoard;
    }

    public int[][] getSolvedBoard() {
        return this.solvedBoard;
    }

    public ArrayList<SudokuBoard> getAllSolutionsList() {
        return this.solutionsList;
    }

    public int[][] getEmptyCells() {
        int[][] emptyCells = new int[9][9];
        if (this.boardState == 1) {
            int i = 0;
            while (i < 9) {
                int j = 0;
                while (i < 9) {
                    emptyCells[i][j] = 9;
                    ++i;
                }
                ++i;
            }
            return emptyCells;
        }
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (i < 9) {
                emptyCells[i][j] = this.sudokuBoard[i][j] == 0 ? this.emptyCellsPointer[i][j].digitsStillFreeNumber : 0;
                ++i;
            }
            ++i;
        }
        return emptyCells;
    }

    public BoardCell[] getAllBoardCells() {
        BoardCell[] boardCells = new BoardCell[81];
        int cellIndex = 0;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                boardCells[cellIndex] = new BoardCell(i, j, this.sudokuBoard[i][j]);
                ++cellIndex;
                ++j;
            }
            ++i;
        }
        return boardCells;
    }

    public BoardCell[] getSolutionBoardCells() {
        if (this.solutionPath == null) {
            return null;
        }
        if (this.solutionPath.size() == 0) {
            return null;
        }
        return ArrayX.toArray(BoardCell.class, this.solutionPath);
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public int getClosedRoutesNumber() {
        return this.closedPathsCounter;
    }

    public void enableRndSeedOnEmptyCells() {
        this.randomizeEmptyCells = true;
    }

    public void disableRndSeedOnEmptyCells() {
        this.randomizeEmptyCells = false;
    }

    public void enableRndSeedOnFreeDigits() {
        this.randomizeFreeDigits = true;
    }

    public void disableRndSeedOnFreeDigits() {
        this.randomizeFreeDigits = false;
    }

    private String boardStateToString() {
        String boardStateStr = "Board: ";
        switch (this.boardState) {
            case 1: {
                boardStateStr = String.valueOf(boardStateStr) + "empty";
                break;
            }
            case -110: {
                boardStateStr = String.valueOf(boardStateStr) + "error";
                break;
            }
            case 2: {
                boardStateStr = String.valueOf(boardStateStr) + "loaded";
                break;
            }
            case 3: {
                boardStateStr = String.valueOf(boardStateStr) + "ready";
            }
        }
        boardStateStr = String.valueOf(boardStateStr) + SudokuStore.NEW_LINE_SEPARATOR + "Initial empty cells: " + this.emptyCellsNumber;
        boardStateStr = String.valueOf(boardStateStr) + SudokuStore.NEW_LINE_SEPARATOR + "Solving : ";
        switch (this.solvingState) {
            case 1: {
                boardStateStr = String.valueOf(boardStateStr) + "not started";
                break;
            }
            case 2: {
                boardStateStr = String.valueOf(boardStateStr) + "started";
                break;
            }
            case 3: {
                boardStateStr = String.valueOf(boardStateStr) + "solved";
                break;
            }
            case -102: {
                boardStateStr = String.valueOf(boardStateStr) + "failed";
            }
        }
        return boardStateStr;
    }

    public String boardAndEmptyCellsToString() {
        return String.valueOf(SudokuStore.boardAndEmptyCellsToString(this.sudokuBoard, this.getEmptyCells())) + this.boardStateToString() + SudokuStore.NEW_LINE_SEPARATOR;
    }

    public String boardToString() {
        return String.valueOf(SudokuStore.boardToString(this.sudokuBoard)) + this.boardStateToString() + SudokuStore.NEW_LINE_SEPARATOR;
    }

    public String emptyCellsToString() {
        return String.valueOf(SudokuStore.emptyCellsToString(this.getEmptyCells())) + this.boardStateToString() + SudokuStore.NEW_LINE_SEPARATOR;
    }

    public String solutionPathToString() {
        return SudokuStore.solutionPathToString(this.getSolutionBoardCells());
    }
}

