/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku;

import java.util.ArrayList;
import org.mariuszgromada.math.janetsudoku.BoardCell;
import org.mariuszgromada.math.janetsudoku.SudokuPuzzles;
import org.mariuszgromada.math.janetsudoku.SudokuSolver;
import org.mariuszgromada.math.janetsudoku.utils.ArrayX;
import org.mariuszgromada.math.janetsudoku.utils.DateTimeX;
import org.mariuszgromada.math.janetsudoku.utils.FileX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SudokuStore {
    public static final String JANET_SUDOKU_VERSION = "1.1.1";
    public static final String JANET_SUDOKU_NAME = "Janet-Sudoku";
    public static final int NUMBER_OF_PUZZLE_EXAMPLES = 161;
    private static final int BOARD_SIZE = 9;
    private static final int BOARD_SUB_SQURE_SIZE = 3;
    private static final int BOARD_SEGMENTS_NUMBER = 3;
    public static final int AVAILABLE_RND_BOARD_TRANSF = 17;
    public static final int DEFAULT_RND_TRANSF_SEQ_LENGTH = 1000;
    public static final String NEW_LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int THREADS_NUMBER = Runtime.getRuntime().availableProcessors();
    private static final int RATING_DEF_NUM_OF_ITERATIONS = 1000;

    public static final int[][] getPuzzleExample(int exampleNumber) {
        return SudokuPuzzles.getPuzzleExample(exampleNumber);
    }

    public static final int[][] getPuzzleExample() {
        return SudokuPuzzles.getPuzzleExample(SudokuStore.randomIndex(161));
    }

    public static final double getPuzzleExampleRating(int exampleNumber) {
        return SudokuPuzzles.getPuzzleExampleRating(exampleNumber);
    }

    public static final int calculatePuzzleRating(int[][] sudokuPuzzle) {
        if (!SudokuStore.checkPuzzle(sudokuPuzzle)) {
            return -111;
        }
        SudokuSolver s = new SudokuSolver(sudokuPuzzle);
        int solType = s.checkIfUniqueSolution();
        if (solType == -1) {
            return -112;
        }
        if (solType == 2) {
            return -113;
        }
        int threadIterNum = 1000 / THREADS_NUMBER;
        int[][] results = new int[THREADS_NUMBER][threadIterNum];
        class Runner
        implements Runnable {
            int threadId;
            int iterNum;
            private final /* synthetic */ int[][] val$results;
            private final /* synthetic */ int[][] val$sudokuPuzzle;

            Runner(int threadId, int iterNum, int[][] nArray, int[][] nArray2) {
                this.val$results = nArray;
                this.val$sudokuPuzzle = nArray2;
                this.threadId = threadId;
                this.iterNum = iterNum;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setTestResult(int i, int result) {
                int[][] nArray = this.val$results;
                synchronized (this.val$results) {
                    this.val$results[this.threadId][i] = result;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }

            public void run() {
                int i = 0;
                while (i < this.iterNum) {
                    SudokuSolver s = new SudokuSolver(this.val$sudokuPuzzle);
                    s.solve();
                    this.setTestResult(i, s.getClosedRoutesNumber());
                    ++i;
                }
            }
        }
        Runner[] runners = new Runner[THREADS_NUMBER];
        Thread[] threads = new Thread[THREADS_NUMBER];
        int t = 0;
        while (t < THREADS_NUMBER) {
            runners[t] = new Runner(t, threadIterNum, results, sudokuPuzzle);
            threads[t] = new Thread(runners[t]);
            ++t;
        }
        t = 0;
        while (t < THREADS_NUMBER) {
            threads[t].start();
            ++t;
        }
        t = 0;
        while (t < THREADS_NUMBER) {
            try {
                threads[t].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return -114;
            }
            ++t;
        }
        int sum = 0;
        int t2 = 0;
        while (t2 < THREADS_NUMBER) {
            int i = 0;
            while (i < threadIterNum) {
                sum += results[t2][i];
                ++i;
            }
            ++t2;
        }
        return sum / (THREADS_NUMBER * threadIterNum);
    }

    public static final int[][] loadBoard(String filePath) {
        ArrayList<String> fileLines = FileX.readFileLines2ArraList(filePath);
        return SudokuStore.loadBoard(fileLines);
    }

    public static final int[][] loadBoard(ArrayList<String> boardDefinition) {
        return SudokuStore.loadBoard(ArrayX.toArray(String.class, boardDefinition));
    }

    public static final int[][] loadBoard(String[] boardDefinition) {
        ArrayList<String> sudokuRows = new ArrayList<String>();
        if (boardDefinition == null) {
            return null;
        }
        if (boardDefinition.length < 9) {
            return null;
        }
        String[] stringArray = boardDefinition;
        int n = boardDefinition.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() > 0 && line.charAt(0) != '#') {
                String sudokuRow = "";
                int j = 0;
                while (j < line.length()) {
                    char c = line.charAt(j);
                    if (c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '0' || c == '.') {
                        sudokuRow = String.valueOf(sudokuRow) + c;
                    }
                    ++j;
                }
                if (sudokuRow.length() >= 9) {
                    sudokuRows.add(sudokuRow.substring(0, 9));
                }
            }
            ++n2;
        }
        if (sudokuRows.size() < 9) {
            return null;
        }
        int[][] sudokuBoard = new int[9][9];
        int i = 0;
        while (i < 9) {
            String sudokuRow = (String)sudokuRows.get(i);
            int j = 0;
            while (j < 9) {
                char c = sudokuRow.charAt(j);
                int d = 0;
                if (c == '1') {
                    d = 1;
                } else if (c == '2') {
                    d = 2;
                } else if (c == '3') {
                    d = 3;
                } else if (c == '4') {
                    d = 4;
                } else if (c == '5') {
                    d = 5;
                } else if (c == '6') {
                    d = 6;
                } else if (c == '7') {
                    d = 7;
                } else if (c == '8') {
                    d = 8;
                } else if (c == '9') {
                    d = 9;
                }
                sudokuBoard[i][j] = d;
                ++j;
            }
            ++i;
        }
        return sudokuBoard;
    }

    public static final int[][] loadBoardFromStringLine(String boardDefinition) {
        if (boardDefinition == null) {
            return null;
        }
        if (boardDefinition.length() < 81) {
            return null;
        }
        int[][] board = SudokuStore.boardCopy(SudokuPuzzles.PUZZLE_EMPTY);
        int cellNum = 0;
        int i = 0;
        int j = -1;
        char[] line = boardDefinition.toCharArray();
        int k = 0;
        while (k < line.length) {
            char c = line[k];
            int d = -1;
            if (c == '1') {
                d = 1;
            } else if (c == '2') {
                d = 2;
            } else if (c == '3') {
                d = 3;
            } else if (c == '4') {
                d = 4;
            } else if (c == '5') {
                d = 5;
            } else if (c == '6') {
                d = 6;
            } else if (c == '7') {
                d = 7;
            } else if (c == '8') {
                d = 8;
            } else if (c == '9') {
                d = 9;
            } else if (c == '0') {
                d = 0;
            } else if (c == '.') {
                d = 0;
            }
            if (d >= 0 && cellNum < 81) {
                ++cellNum;
                board[i][++j] = d;
                if (j == 8) {
                    ++i;
                    j = -1;
                }
            }
            ++k;
        }
        if (cellNum == 81) {
            return board;
        }
        return null;
    }

    public static final int[][] loadBoardFromStrings(String ... boardDefinition) {
        return SudokuStore.loadBoard(boardDefinition);
    }

    public static final boolean saveBoard(int[][] sudokuBoard, String filePath) {
        String boardString = SudokuStore.boardToString(sudokuBoard);
        return FileX.writeFile(filePath, boardString);
    }

    public static final boolean saveBoard(int[][] sudokuBoard, String filePath, String headComment) {
        String boardString = SudokuStore.boardToString(sudokuBoard, headComment);
        return FileX.writeFile(filePath, boardString);
    }

    public static final boolean saveBoard(int[][] sudokuBoard, String filePath, String headComment, String tailComment) {
        String boardString = SudokuStore.boardToString(sudokuBoard, headComment, tailComment);
        return FileX.writeFile(filePath, boardString);
    }

    private static final void clearDigits(int[] digits) {
        int i = 1;
        while (i < 10) {
            digits[i] = 0;
            ++i;
        }
    }

    private static final int sumDigits(int[] digits) {
        int s = 0;
        int i = 1;
        while (i < 10) {
            s += digits[i];
            ++i;
        }
        return s;
    }

    private static final int maxDigitCount(int[] digits) {
        int max = 0;
        int i = 1;
        while (i < 10) {
            if (digits[i] > max) {
                max = digits[i];
            }
            ++i;
        }
        return max;
    }

    public static boolean checkSolvedBoard(int[][] solvedBoard) {
        int d;
        if (solvedBoard == null) {
            return false;
        }
        if (solvedBoard.length != 9) {
            return false;
        }
        if (solvedBoard[0].length != 9) {
            return false;
        }
        int[] digits = new int[10];
        int i = 0;
        while (i < 9) {
            SudokuStore.clearDigits(digits);
            int j = 0;
            while (j < 9) {
                d = solvedBoard[i][j];
                if (d < 1 || d > 9) {
                    return false;
                }
                digits[d] = 1;
                ++j;
            }
            if (SudokuStore.sumDigits(digits) != 9) {
                return false;
            }
            ++i;
        }
        int j = 0;
        while (j < 9) {
            SudokuStore.clearDigits(digits);
            int i2 = 0;
            while (i2 < 9) {
                d = solvedBoard[i2][j];
                digits[d] = 1;
                ++i2;
            }
            if (SudokuStore.sumDigits(digits) != 9) {
                return false;
            }
            ++j;
        }
        int rowSeg = 0;
        while (rowSeg < 3) {
            int iSeg = SudokuStore.boardSegmentStartIndex(rowSeg);
            int colSeg = 0;
            while (colSeg < 3) {
                int jSeg = SudokuStore.boardSegmentStartIndex(colSeg);
                SudokuStore.clearDigits(digits);
                int i3 = 0;
                while (i3 < 3) {
                    int j2 = 0;
                    while (j2 < 3) {
                        int d2 = solvedBoard[iSeg + i3][jSeg + j2];
                        digits[d2] = 1;
                        ++j2;
                    }
                    ++i3;
                }
                if (SudokuStore.sumDigits(digits) != 9) {
                    return false;
                }
                ++colSeg;
            }
            ++rowSeg;
        }
        return true;
    }

    public static boolean checkPuzzle(int[][] sudokuBoard) {
        int d;
        if (sudokuBoard == null) {
            return false;
        }
        if (sudokuBoard.length != 9) {
            return false;
        }
        if (sudokuBoard[0].length != 9) {
            return false;
        }
        int[] digits = new int[10];
        int i = 0;
        while (i < 9) {
            SudokuStore.clearDigits(digits);
            int j = 0;
            while (j < 9) {
                d = sudokuBoard[i][j];
                if (d < 0 || d > 9) {
                    return false;
                }
                int n = d;
                digits[n] = digits[n] + 1;
                ++j;
            }
            if (SudokuStore.maxDigitCount(digits) > 1) {
                return false;
            }
            ++i;
        }
        int j = 0;
        while (j < 9) {
            SudokuStore.clearDigits(digits);
            int i2 = 0;
            while (i2 < 9) {
                int n = d = sudokuBoard[i2][j];
                digits[n] = digits[n] + 1;
                ++i2;
            }
            if (SudokuStore.maxDigitCount(digits) > 1) {
                return false;
            }
            ++j;
        }
        int rowSeg = 0;
        while (rowSeg < 3) {
            int iSeg = SudokuStore.boardSegmentStartIndex(rowSeg);
            int colSeg = 0;
            while (colSeg < 3) {
                int jSeg = SudokuStore.boardSegmentStartIndex(colSeg);
                SudokuStore.clearDigits(digits);
                int i3 = 0;
                while (i3 < 3) {
                    int j2 = 0;
                    while (j2 < 3) {
                        int d2;
                        int n = d2 = sudokuBoard[iSeg + i3][jSeg + j2];
                        digits[n] = digits[n] + 1;
                        ++j2;
                    }
                    ++i3;
                }
                if (SudokuStore.maxDigitCount(digits) > 1) {
                    return false;
                }
                ++colSeg;
            }
            ++rowSeg;
        }
        return true;
    }

    public static final int[][] rotateClockWise(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] rotatedBoard = new int[9][9];
        int i = 0;
        while (i < 9) {
            int newColIndex = 9 - i - 1;
            int j = 0;
            while (j < 9) {
                rotatedBoard[j][newColIndex] = sudokuBoard[i][j];
                ++j;
            }
            ++i;
        }
        return rotatedBoard;
    }

    public static final int[][] rotateCounterclockWise(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] rotatedBoard = new int[9][9];
        int j = 0;
        while (j < 9) {
            int newRowIndex = 9 - j - 1;
            int i = 0;
            while (i < 9) {
                rotatedBoard[newRowIndex][i] = sudokuBoard[i][j];
                ++i;
            }
            ++j;
        }
        return rotatedBoard;
    }

    public static final int[][] reflectHorizontally(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] reflectedBoard = new int[9][9];
        int i = 0;
        while (i < 9) {
            int newRowIndex = 9 - i - 1;
            int j = 0;
            while (j < 9) {
                reflectedBoard[newRowIndex][j] = sudokuBoard[i][j];
                ++j;
            }
            ++i;
        }
        return reflectedBoard;
    }

    public static final int[][] reflectVertically(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] reflectedBoard = new int[9][9];
        int j = 0;
        while (j < 9) {
            int newColIndex = 9 - j - 1;
            int i = 0;
            while (i < 9) {
                reflectedBoard[i][newColIndex] = sudokuBoard[i][j];
                ++i;
            }
            ++j;
        }
        return reflectedBoard;
    }

    public static final int[][] transposeTlBr(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] reflectedBoard = new int[9][9];
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                reflectedBoard[j][i] = sudokuBoard[i][j];
                ++j;
            }
            ++i;
        }
        return reflectedBoard;
    }

    public static final int[][] transposeTrBl(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] reflectedBoard = new int[9][9];
        int i = 0;
        while (i < 9) {
            int newColIndex = 9 - i - 1;
            int j = 0;
            while (j < 9) {
                int newRowIndex = 9 - j - 1;
                reflectedBoard[newRowIndex][newColIndex] = sudokuBoard[i][j];
                ++j;
            }
            ++i;
        }
        return reflectedBoard;
    }

    public static final int[][] swapRowSegments(int[][] sudokuBoard, int rowSeg1, int rowSeg2) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] newBoard = SudokuStore.boardCopy(sudokuBoard);
        if (rowSeg1 == rowSeg2) {
            return newBoard;
        }
        if (rowSeg1 < 0 || rowSeg1 > 2) {
            return newBoard;
        }
        if (rowSeg2 < 0 || rowSeg2 > 2) {
            return newBoard;
        }
        int startRowSeg1 = SudokuStore.boardSegmentStartIndex(rowSeg1);
        int startRowSeg2 = SudokuStore.boardSegmentStartIndex(rowSeg2);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 9) {
                newBoard[startRowSeg1 + i][j] = sudokuBoard[startRowSeg2 + i][j];
                newBoard[startRowSeg2 + i][j] = sudokuBoard[startRowSeg1 + i][j];
                ++j;
            }
            ++i;
        }
        return newBoard;
    }

    public static final int[][] swapRowSegmentsRandomly(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int seg1 = SudokuStore.randomIndex(3);
        int seg2 = SudokuStore.randomIndex(3);
        return SudokuStore.swapRowSegments(sudokuBoard, seg1, seg2);
    }

    public static final int[][] swapColSegments(int[][] sudokuBoard, int colSeg1, int colSeg2) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] newBoard = SudokuStore.boardCopy(sudokuBoard);
        if (colSeg1 == colSeg2) {
            return newBoard;
        }
        if (colSeg1 < 0 || colSeg1 > 2) {
            return newBoard;
        }
        if (colSeg2 < 0 || colSeg2 > 2) {
            return newBoard;
        }
        int startColSeg1 = SudokuStore.boardSegmentStartIndex(colSeg1);
        int startColSeg2 = SudokuStore.boardSegmentStartIndex(colSeg2);
        int j = 0;
        while (j < 3) {
            int i = 0;
            while (i < 9) {
                newBoard[i][startColSeg1 + j] = sudokuBoard[i][startColSeg2 + j];
                newBoard[i][startColSeg2 + j] = sudokuBoard[i][startColSeg1 + j];
                ++i;
            }
            ++j;
        }
        return newBoard;
    }

    public static final int[][] swapColSegmentsRandomly(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int seg1 = SudokuStore.randomIndex(3);
        int seg2 = SudokuStore.randomIndex(3);
        return SudokuStore.swapColSegments(sudokuBoard, seg1, seg2);
    }

    public static final int[][] swapRowsInSegment(int[][] sudokuBoard, int rowSeg, int row1, int row2) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] newBoard = SudokuStore.boardCopy(sudokuBoard);
        if (rowSeg < 0 || rowSeg > 2) {
            return newBoard;
        }
        if (row1 < 0 || row1 > 2) {
            return newBoard;
        }
        if (row2 < 0 || row2 > 2) {
            return newBoard;
        }
        if (row1 == row2) {
            return newBoard;
        }
        int segStart = SudokuStore.boardSegmentStartIndex(rowSeg);
        int j = 0;
        while (j < 9) {
            newBoard[segStart + row1][j] = sudokuBoard[segStart + row2][j];
            newBoard[segStart + row2][j] = sudokuBoard[segStart + row1][j];
            ++j;
        }
        return newBoard;
    }

    public static final int[][] swapRowsInSegmentRandomly(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int rowSeg = SudokuStore.randomIndex(3);
        int row1 = SudokuStore.randomIndex(3);
        int row2 = SudokuStore.randomIndex(3);
        return SudokuStore.swapRowsInSegment(sudokuBoard, rowSeg, row1, row2);
    }

    public static final int[][] swapColsInSegment(int[][] sudokuBoard, int colSeg, int col1, int col2) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] newBoard = SudokuStore.boardCopy(sudokuBoard);
        if (colSeg < 0 || colSeg > 2) {
            return newBoard;
        }
        if (col1 < 0 || col1 > 2) {
            return newBoard;
        }
        if (col2 < 0 || col2 > 2) {
            return newBoard;
        }
        if (col1 == col2) {
            return newBoard;
        }
        int segStart = SudokuStore.boardSegmentStartIndex(colSeg);
        int i = 0;
        while (i < 9) {
            newBoard[i][segStart + col1] = sudokuBoard[i][segStart + col2];
            newBoard[i][segStart + col2] = sudokuBoard[i][segStart + col1];
            ++i;
        }
        return newBoard;
    }

    public static final int[][] swapColsInSegmentRandomly(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int colSeg = SudokuStore.randomIndex(3);
        int col1 = SudokuStore.randomIndex(3);
        int col2 = SudokuStore.randomIndex(3);
        return SudokuStore.swapColsInSegment(sudokuBoard, colSeg, col1, col2);
    }

    public static final int[][] permuteBoard(int[][] sudokuBoard, int[] permutation) {
        if (sudokuBoard == null) {
            return null;
        }
        if (!SudokuStore.isValidPermutation(permutation, 9)) {
            return SudokuStore.boardCopy(sudokuBoard);
        }
        int[][] permutatedBoard = new int[9][9];
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                int digit = sudokuBoard[i][j];
                permutatedBoard[i][j] = digit == 0 ? 0 : permutation[digit - 1] + 1;
                ++j;
            }
            ++i;
        }
        return permutatedBoard;
    }

    public static final int[][] permuteBoard(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        return SudokuStore.permuteBoard(sudokuBoard, SudokuStore.generatePermutation(9));
    }

    public static final int[][] permuteRowSegments(int[][] sudokuBoard, int[] permutation) {
        if (sudokuBoard == null) {
            return null;
        }
        if (!SudokuStore.isValidPermutation(permutation, 3)) {
            return SudokuStore.boardCopy(sudokuBoard);
        }
        int[][] permutatedBoard = new int[9][9];
        int[] segmentStart = new int[3];
        int seg = 0;
        while (seg < 3) {
            segmentStart[seg] = SudokuStore.boardSegmentStartIndex(seg);
            ++seg;
        }
        seg = 0;
        while (seg < 3) {
            int i = 0;
            while (i < 3) {
                int curRowIndex = segmentStart[permutation[seg]] + i;
                int newRowIndex = segmentStart[seg] + i;
                int j = 0;
                while (j < 9) {
                    permutatedBoard[newRowIndex][j] = sudokuBoard[curRowIndex][j];
                    ++j;
                }
                ++i;
            }
            ++seg;
        }
        return permutatedBoard;
    }

    public static final int[][] permuteRowSegments(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        return SudokuStore.permuteRowSegments(sudokuBoard, SudokuStore.generatePermutation(3));
    }

    public static final int[][] permuteColSegments(int[][] sudokuBoard, int[] permutation) {
        if (sudokuBoard == null) {
            return null;
        }
        if (!SudokuStore.isValidPermutation(permutation, 3)) {
            return SudokuStore.boardCopy(sudokuBoard);
        }
        int[][] permutatedBoard = new int[9][9];
        int[] segmentStart = new int[3];
        int seg = 0;
        while (seg < 3) {
            segmentStart[seg] = SudokuStore.boardSegmentStartIndex(seg);
            ++seg;
        }
        seg = 0;
        while (seg < 3) {
            int j = 0;
            while (j < 3) {
                int curColIndex = segmentStart[permutation[seg]] + j;
                int newColIndex = segmentStart[seg] + j;
                int i = 0;
                while (i < 9) {
                    permutatedBoard[i][newColIndex] = sudokuBoard[i][curColIndex];
                    ++i;
                }
                ++j;
            }
            ++seg;
        }
        return permutatedBoard;
    }

    public static final int[][] permuteColSegments(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        return SudokuStore.permuteColSegments(sudokuBoard, SudokuStore.generatePermutation(3));
    }

    public static final int[][] permuteRowsInSegment(int[][] sudokuBoard, int rowSeg, int[] permutation) {
        if (sudokuBoard == null) {
            return null;
        }
        if (!SudokuStore.isValidPermutation(permutation, 3)) {
            return SudokuStore.boardCopy(sudokuBoard);
        }
        int[][] permutatedBoard = SudokuStore.boardCopy(sudokuBoard);
        if (rowSeg < 0 || rowSeg > 2) {
            return permutatedBoard;
        }
        int segStart = SudokuStore.boardSegmentStartIndex(rowSeg);
        int i = 0;
        while (i < 3) {
            int curRowIndex = segStart + permutation[i];
            int newRowIndex = segStart + i;
            int j = 0;
            while (j < 9) {
                permutatedBoard[newRowIndex][j] = sudokuBoard[curRowIndex][j];
                ++j;
            }
            ++i;
        }
        return permutatedBoard;
    }

    public static final int[][] permuteRowsInSegment(int[][] sudokuBoard, int rowSeg) {
        if (sudokuBoard == null) {
            return null;
        }
        return SudokuStore.permuteRowsInSegment(sudokuBoard, rowSeg, SudokuStore.generatePermutation(3));
    }

    public static final int[][] permuteRowsInSegment(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        return SudokuStore.permuteRowsInSegment(sudokuBoard, SudokuStore.randomIndex(3), SudokuStore.generatePermutation(3));
    }

    public static final int[][] permuteRowsInAllSegments(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] permutatedBoard0 = SudokuStore.permuteRowsInSegment(sudokuBoard, 0);
        int[][] permutatedBoard1 = SudokuStore.permuteRowsInSegment(permutatedBoard0, 1);
        int[][] permutatedBoard2 = SudokuStore.permuteRowsInSegment(permutatedBoard1, 2);
        return permutatedBoard2;
    }

    public static final int[][] permuteColsInSegment(int[][] sudokuBoard, int colSeg, int[] permutation) {
        if (sudokuBoard == null) {
            return null;
        }
        if (!SudokuStore.isValidPermutation(permutation, 3)) {
            return SudokuStore.boardCopy(sudokuBoard);
        }
        int[][] permutatedBoard = SudokuStore.boardCopy(sudokuBoard);
        if (colSeg < 0 || colSeg > 2) {
            return permutatedBoard;
        }
        int segStart = SudokuStore.boardSegmentStartIndex(colSeg);
        int j = 0;
        while (j < 3) {
            int curColIndex = segStart + permutation[j];
            int newColIndex = segStart + j;
            int i = 0;
            while (i < 9) {
                permutatedBoard[i][newColIndex] = sudokuBoard[i][curColIndex];
                ++i;
            }
            ++j;
        }
        return permutatedBoard;
    }

    public static final int[][] permuteColsInSegment(int[][] sudokuBoard, int colSeg) {
        if (sudokuBoard == null) {
            return null;
        }
        return SudokuStore.permuteColsInSegment(sudokuBoard, colSeg, SudokuStore.generatePermutation(3));
    }

    public static final int[][] permuteColsInSegment(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        return SudokuStore.permuteColsInSegment(sudokuBoard, SudokuStore.randomIndex(3), SudokuStore.generatePermutation(3));
    }

    public static final int[][] permuteColsInAllSegments(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] permutatedBoard0 = SudokuStore.permuteColsInSegment(sudokuBoard, 0);
        int[][] permutatedBoard1 = SudokuStore.permuteColsInSegment(permutatedBoard0, 1);
        int[][] permutatedBoard2 = SudokuStore.permuteColsInSegment(permutatedBoard1, 2);
        return permutatedBoard2;
    }

    public static final int[][] randomBoardTransf(int[][] sudokuBoard, int transfId) {
        if (sudokuBoard == null) {
            return null;
        }
        int rndTransf = SudokuStore.randomIndex(17);
        switch (rndTransf) {
            case 0: {
                return SudokuStore.rotateClockWise(sudokuBoard);
            }
            case 1: {
                return SudokuStore.rotateCounterclockWise(sudokuBoard);
            }
            case 2: {
                return SudokuStore.reflectHorizontally(sudokuBoard);
            }
            case 3: {
                return SudokuStore.reflectVertically(sudokuBoard);
            }
            case 4: {
                return SudokuStore.transposeTlBr(sudokuBoard);
            }
            case 5: {
                return SudokuStore.transposeTrBl(sudokuBoard);
            }
            case 6: {
                return SudokuStore.swapRowSegmentsRandomly(sudokuBoard);
            }
            case 7: {
                return SudokuStore.swapColSegmentsRandomly(sudokuBoard);
            }
            case 8: {
                return SudokuStore.swapRowsInSegmentRandomly(sudokuBoard);
            }
            case 9: {
                return SudokuStore.swapColsInSegmentRandomly(sudokuBoard);
            }
            case 10: {
                return SudokuStore.permuteBoard(sudokuBoard);
            }
            case 11: {
                return SudokuStore.permuteRowSegments(sudokuBoard);
            }
            case 12: {
                return SudokuStore.permuteColSegments(sudokuBoard);
            }
            case 13: {
                return SudokuStore.permuteRowsInSegment(sudokuBoard);
            }
            case 14: {
                return SudokuStore.permuteRowsInAllSegments(sudokuBoard);
            }
            case 15: {
                return SudokuStore.permuteColsInSegment(sudokuBoard);
            }
            case 16: {
                return SudokuStore.permuteColsInAllSegments(sudokuBoard);
            }
        }
        return sudokuBoard;
    }

    public static final int[][] randomBoardTransf(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        return SudokuStore.randomBoardTransf(sudokuBoard, SudokuStore.randomIndex(17));
    }

    public static final int[][] seqOfRandomBoardTransf(int[][] sudokuBoard, int seqLength) {
        if (sudokuBoard == null) {
            return null;
        }
        if (seqLength < 1) {
            return SudokuStore.boardCopy(sudokuBoard);
        }
        int[][] newBoard = SudokuStore.boardCopy(sudokuBoard);
        int i = 0;
        while (i < seqLength) {
            newBoard = SudokuStore.randomBoardTransf(newBoard);
            ++i;
        }
        return newBoard;
    }

    public static final int[][] seqOfRandomBoardTransf(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        return SudokuStore.seqOfRandomBoardTransf(sudokuBoard, 1000);
    }

    public static final int randomIndex(int n) {
        if (n < 0) {
            return -108;
        }
        return (int)Math.floor(Math.random() * (double)n);
    }

    public static final int randomNumber(int n) {
        if (n < 1) {
            return -109;
        }
        return (int)Math.floor(Math.random() * (double)n) + 1;
    }

    public static final int boardSegmentStartIndex(int segId) {
        if (segId == 0) {
            return 0;
        }
        if (segId == 1) {
            return 3;
        }
        if (segId == 2) {
            return 6;
        }
        return -107;
    }

    public static final int[] generatePermutation(int n) {
        if (n <= 0) {
            return null;
        }
        int[] permutation = new int[n];
        if (n == 0) {
            permutation[0] = 0;
            return permutation;
        }
        int i = 0;
        while (i < n) {
            permutation[i] = i;
            ++i;
        }
        int notPermuted = n;
        while (notPermuted > 0) {
            int lastNotPermutedIndex = notPermuted - 1;
            int newIndex = SudokuStore.randomIndex(notPermuted);
            if (newIndex < lastNotPermutedIndex) {
                int b = permutation[lastNotPermutedIndex];
                permutation[lastNotPermutedIndex] = permutation[newIndex];
                permutation[newIndex] = b;
            }
            --notPermuted;
        }
        return permutation;
    }

    public static final boolean isValidPermutation(int[] permutation) {
        if (permutation == null) {
            return false;
        }
        int n = permutation.length;
        if (n == 0) {
            return false;
        }
        int[] seq = new int[n];
        int i = 0;
        while (i < n) {
            seq[i] = 0;
            if (permutation[i] < 0 || permutation[i] > n - 1) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            seq[permutation[i]] = 1;
            ++i;
        }
        int nPerm = 0;
        int i2 = 0;
        while (i2 < n) {
            nPerm += seq[i2];
            ++i2;
        }
        return nPerm == n;
    }

    public static final boolean isValidPermutation(int[] permutation, int n) {
        if (permutation == null) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        if (permutation.length != n) {
            return false;
        }
        return SudokuStore.isValidPermutation(permutation);
    }

    public static final int[][] boardCopy(int[][] sudokuBoard) {
        if (sudokuBoard == null) {
            return null;
        }
        int[][] newBoard = new int[9][9];
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                newBoard[i][j] = sudokuBoard[i][j];
                ++j;
            }
            ++i;
        }
        return newBoard;
    }

    public static final boolean boardsAreEqual(int[][] board1, int[][] board2) {
        if (board1 == null) {
            return false;
        }
        if (board2 == null) {
            return false;
        }
        if (board1.length != board2.length) {
            return false;
        }
        if (board1[0].length != board2[0].length) {
            return false;
        }
        int rdim = board1.length;
        int cdim = board1[0].length;
        int i = 0;
        while (i < rdim) {
            int j = 0;
            while (j < cdim) {
                if (board1[i][j] != board2[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static final String convBoardToString(int[][] sudokuBoard, String headComment, String tailComment) {
        String boardStr = "";
        String oneLineDefDot = "";
        String oneLineDefZero = "";
        if (headComment != null && headComment.length() > 0) {
            boardStr = String.valueOf(boardStr) + "# " + headComment + NEW_LINE_SEPARATOR + NEW_LINE_SEPARATOR;
        }
        if (sudokuBoard == null) {
            return "NULL sudoku board.";
        }
        boardStr = String.valueOf(boardStr) + "+-------+-------+-------+" + NEW_LINE_SEPARATOR;
        int i = 0;
        while (i < 9) {
            if (i > 0 && i < 9 && i % 3 == 0) {
                boardStr = String.valueOf(boardStr) + "+-------+-------+-------+" + NEW_LINE_SEPARATOR;
            }
            boardStr = String.valueOf(boardStr) + "| ";
            int j = 0;
            while (j < 9) {
                if (j > 0 && j < 9 && j % 3 == 0) {
                    boardStr = String.valueOf(boardStr) + "| ";
                }
                if (sudokuBoard[i][j] != 0) {
                    boardStr = String.valueOf(boardStr) + sudokuBoard[i][j] + " ";
                    oneLineDefDot = String.valueOf(oneLineDefDot) + sudokuBoard[i][j];
                    oneLineDefZero = String.valueOf(oneLineDefZero) + sudokuBoard[i][j];
                } else {
                    boardStr = String.valueOf(boardStr) + ". ";
                    oneLineDefDot = String.valueOf(oneLineDefDot) + '.';
                    oneLineDefZero = String.valueOf(oneLineDefZero) + '0';
                }
                ++j;
            }
            boardStr = String.valueOf(boardStr) + "|" + NEW_LINE_SEPARATOR;
            ++i;
        }
        boardStr = String.valueOf(boardStr) + "+-------+-------+-------+" + NEW_LINE_SEPARATOR + NEW_LINE_SEPARATOR;
        boardStr = String.valueOf(boardStr) + "# One line definition:" + NEW_LINE_SEPARATOR;
        boardStr = String.valueOf(boardStr) + "# " + oneLineDefDot + NEW_LINE_SEPARATOR;
        boardStr = String.valueOf(boardStr) + "# " + oneLineDefZero + NEW_LINE_SEPARATOR + NEW_LINE_SEPARATOR;
        if (tailComment != null && tailComment.length() > 0) {
            boardStr = String.valueOf(NEW_LINE_SEPARATOR) + NEW_LINE_SEPARATOR + boardStr + "# " + tailComment;
        }
        return boardStr;
    }

    public static final String boardToString(int[][] sudokuBoard) {
        return SudokuStore.convBoardToString(sudokuBoard, "Sudoku puzzle", "Janet-Sudoku-v.1.1.1, " + DateTimeX.getCurrDateTimeStr());
    }

    public static final String boardToString(int[][] sudokuBoard, String headComment) {
        return SudokuStore.convBoardToString(sudokuBoard, headComment, "");
    }

    public static final String boardToString(int[][] sudokuBoard, String headComment, String tailComment) {
        return SudokuStore.convBoardToString(sudokuBoard, headComment, tailComment);
    }

    public static final String emptyCellsToString(int[][] emptyCells) {
        String boardStr = "Number of free digits" + NEW_LINE_SEPARATOR;
        boardStr = String.valueOf(boardStr) + "=====================" + NEW_LINE_SEPARATOR;
        int i = 0;
        while (i < 9) {
            if (i > 0 && i < 9 && i % 3 == 0) {
                boardStr = String.valueOf(boardStr) + "---------------------" + NEW_LINE_SEPARATOR;
            }
            int j = 0;
            while (j < 9) {
                if (j > 0 && j < 9 && j % 3 == 0) {
                    boardStr = String.valueOf(boardStr) + "| ";
                }
                boardStr = emptyCells[i][j] > 0 ? String.valueOf(boardStr) + emptyCells[i][j] + " " : String.valueOf(boardStr) + ". ";
                ++j;
            }
            boardStr = String.valueOf(boardStr) + NEW_LINE_SEPARATOR;
            ++i;
        }
        boardStr = String.valueOf(boardStr) + "=====================" + NEW_LINE_SEPARATOR;
        return boardStr;
    }

    public static final String boardAndEmptyCellsToString(int[][] sudokuBoard, int[][] emptyCells) {
        String boardStr = "    Sudoku board           Number of free digits" + NEW_LINE_SEPARATOR;
        boardStr = String.valueOf(boardStr) + "=====================      =====================" + NEW_LINE_SEPARATOR;
        int i = 0;
        while (i < 9) {
            if (i > 0 && i < 9 && i % 3 == 0) {
                boardStr = String.valueOf(boardStr) + "---------------------      ---------------------" + NEW_LINE_SEPARATOR;
            }
            int j = 0;
            while (j < 9) {
                if (j > 0 && j < 9 && j % 3 == 0) {
                    boardStr = String.valueOf(boardStr) + "| ";
                }
                boardStr = sudokuBoard[i][j] != 0 ? String.valueOf(boardStr) + sudokuBoard[i][j] + " " : String.valueOf(boardStr) + ". ";
                ++j;
            }
            boardStr = String.valueOf(boardStr) + "     ";
            j = 0;
            while (j < 9) {
                if (j > 0 && j < 9 && j % 3 == 0) {
                    boardStr = String.valueOf(boardStr) + "| ";
                }
                boardStr = emptyCells[i][j] > 0 ? String.valueOf(boardStr) + emptyCells[i][j] + " " : String.valueOf(boardStr) + ". ";
                ++j;
            }
            boardStr = String.valueOf(boardStr) + NEW_LINE_SEPARATOR;
            ++i;
        }
        boardStr = String.valueOf(boardStr) + "=====================      =====================" + NEW_LINE_SEPARATOR;
        return boardStr;
    }

    public static final String solutionPathToString(BoardCell[] solutionBoardCells) {
        String solutionPath = "";
        solutionPath = String.valueOf(solutionPath) + " --------------- " + NEW_LINE_SEPARATOR;
        solutionPath = String.valueOf(solutionPath) + "| id | i, j | d |" + NEW_LINE_SEPARATOR;
        solutionPath = String.valueOf(solutionPath) + "|----|----- |---|" + NEW_LINE_SEPARATOR;
        if (solutionBoardCells != null) {
            int i = 0;
            while (i < solutionBoardCells.length) {
                BoardCell b = solutionBoardCells[i];
                solutionPath = i + 1 < 10 ? String.valueOf(solutionPath) + "|  " : String.valueOf(solutionPath) + "| ";
                solutionPath = String.valueOf(solutionPath) + (i + 1) + " | " + (b.rowIndex + 1) + ", " + (b.colIndex + 1) + " | " + b.digit + " |" + NEW_LINE_SEPARATOR;
                ++i;
            }
        }
        solutionPath = String.valueOf(solutionPath) + " --------------- " + NEW_LINE_SEPARATOR;
        return solutionPath;
    }

    public static final void consolePrintBoard(int[][] sudokuBoard) {
        System.out.println(SudokuStore.boardToString(sudokuBoard));
    }

    public static final void consolePrintln(Object o) {
        System.out.println("[Janet-Sudoku-v.1.1.1] " + o);
    }
}

