/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku.demoapp;

import java.io.File;
import java.util.ArrayList;
import org.mariuszgromada.math.janetsudoku.ErrorCodes;
import org.mariuszgromada.math.janetsudoku.SudokuBoard;
import org.mariuszgromada.math.janetsudoku.SudokuGenerator;
import org.mariuszgromada.math.janetsudoku.SudokuPuzzles;
import org.mariuszgromada.math.janetsudoku.SudokuSolver;
import org.mariuszgromada.math.janetsudoku.SudokuStore;
import org.mariuszgromada.math.janetsudoku.demoapp.JanetConsole;
import org.mariuszgromada.math.janetsudoku.demoapp.Menu;
import org.mariuszgromada.math.janetsudoku.demoapp.MenuData;

public class JanetSudoku {
    public static final String VERSION = "1.1.1";
    SudokuSolver solver;
    SudokuGenerator generator;
    int[][] puzzle = SudokuStore.boardCopy(SudokuPuzzles.PUZZLE_EMPTY);
    int[][] puzzleUndo;
    int[][] puzzleRedo;
    private boolean rndSeedOnCells = true;
    private boolean rndSeedOnDigits = true;

    private void loopMenuMain() {
        int selItem;
        Menu menu = new Menu("Main menu", MenuData.MAIN_CONTENT, this);
        do {
            selItem = menu.getItem();
            switch (selItem) {
                case 3: {
                    this.loopMenuLoad();
                    break;
                }
                case 4: {
                    this.loopMenuGenerate();
                    break;
                }
                case 5: {
                    this.loopMenuInput();
                    break;
                }
                case 6: {
                    this.loopMenuModify();
                    break;
                }
                case 7: {
                    this.loopMenuEvaluate();
                    break;
                }
                case 8: {
                    this.loopMenuSolve();
                    break;
                }
                case 9: {
                    this.savePuzzle();
                    break;
                }
                case 10: {
                    this.loopMenuOptions();
                    break;
                }
                case 11: {
                    this.displayAboutInto();
                    break;
                }
                case 0: {
                    this.quitFromApp();
                    break;
                }
                case 1: {
                    this.performPuzzleUndo();
                    break;
                }
                case 2: {
                    this.performPuzzleRedo();
                    break;
                }
                default: {
                    this.incorrectSelection();
                }
            }
        } while (selItem != 0);
    }

    private void loopMenuLoad() {
        int selItem;
        Menu menu = new Menu("Load puzzle", MenuData.LOAD_CONTENT, this);
        do {
            selItem = menu.getItem();
            switch (selItem) {
                case 3: {
                    this.loadFromFile();
                    break;
                }
                case 4: {
                    this.loadFromExample();
                    break;
                }
                case 5: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.boardCopy(SudokuPuzzles.PUZZLE_EMPTY);
                    break;
                }
                case 6: {
                    this.listPuzzleExamples();
                    break;
                }
                case 1: {
                    this.performPuzzleUndo();
                    break;
                }
                case 2: {
                    this.performPuzzleRedo();
                    break;
                }
                default: {
                    this.incorrectSelection();
                }
            }
        } while (selItem != 0);
    }

    private void loadFromFile() {
        JanetConsole.print("File path: ");
        String filePath = JanetConsole.readLine();
        File file = new File(filePath);
        if (!file.exists()) {
            JanetConsole.println(">>> !!! Error - file does not exist !!! <<<");
            return;
        }
        if (!file.isFile()) {
            JanetConsole.println(">>> !!! Error - not a file !!! <<<");
            return;
        }
        int[][] puzzleLoaded = SudokuStore.loadBoard(filePath);
        if (puzzleLoaded == null) {
            JanetConsole.println(">>> !!! Error - incorrect file content !!! <<<");
            return;
        }
        this.trackPuzzleUndo();
        this.puzzle = puzzleLoaded;
    }

    private void loadFromExample() {
        JanetConsole.println();
        JanetConsole.print("Please provide example number (between 0 and 160): ");
        int example = JanetConsole.readInt();
        if (example >= 0 && example < 161) {
            JanetConsole.println("Loading example: " + example);
            this.trackPuzzleUndo();
            this.puzzle = SudokuStore.boardCopy(SudokuStore.getPuzzleExample(example));
        } else {
            JanetConsole.println(">>> !!! Incorrect example number !!! <<<");
        }
    }

    private void listPuzzleExamples() {
        JanetConsole.println("");
        int i = 0;
        while (i < 161) {
            JanetConsole.println(">>> Example nr: " + i + ", rating = " + (int)SudokuPuzzles.getPuzzleExampleRating(i));
            ++i;
        }
        JanetConsole.println("");
    }

    private void loopMenuGenerate() {
        int selItem;
        Menu menu = new Menu("Generate puzzle", MenuData.GENERATE_CONTENT, this);
        do {
            selItem = menu.getItem();
            switch (selItem) {
                case 3: {
                    this.generateRandomPuzzle();
                    break;
                }
                case 4: {
                    this.generateAndRateRandomPuzzle();
                    break;
                }
                case 5: {
                    this.generateFromExample();
                    break;
                }
                case 6: {
                    this.generateFromCurrentPuzzle();
                    break;
                }
                case 1: {
                    this.performPuzzleUndo();
                    break;
                }
                case 2: {
                    this.performPuzzleRedo();
                    break;
                }
                default: {
                    this.incorrectSelection();
                }
            }
        } while (selItem != 0);
    }

    private void generateRandomPuzzle() {
        this.generator = new SudokuGenerator('1');
        this.setGeneratorOptions();
        int[][] generated = this.generator.generate();
        if (this.generator.getGeneratorState() == 4) {
            this.trackPuzzleUndo();
            this.puzzle = generated;
        } else {
            JanetConsole.println(">>> !!! Error while generating random puzzle !!! <<<");
            JanetConsole.println(this.generator.getMessages());
        }
    }

    private void generateAndRateRandomPuzzle() {
        this.generator = new SudokuGenerator('1');
        this.setGeneratorOptions();
        int[][] generated = this.generator.generate();
        if (this.generator.getGeneratorState() == 4) {
            this.trackPuzzleUndo();
            this.puzzle = generated;
            this.ratePuzzleDifficulty();
        } else {
            JanetConsole.println(">>> !!! Error while generating random puzzle !!! <<<");
            JanetConsole.println(this.generator.getMessages());
        }
    }

    private void generateFromExample() {
        this.loadFromExample();
        this.generateFromCurrentPuzzle();
    }

    private void generateFromCurrentPuzzle() {
        this.generator = new SudokuGenerator(this.puzzle, '3');
        this.setGeneratorOptions();
        int[][] generated = this.generator.generate();
        if (this.generator.getGeneratorState() == 4) {
            this.trackPuzzleUndo();
            this.puzzle = generated;
        } else {
            JanetConsole.println(">>> !!! Error while generating puzzle !!! <<<");
            JanetConsole.println(this.generator.getMessages());
        }
    }

    private void loopMenuInput() {
        int selItem;
        Menu menu = new Menu("Input puzzle", MenuData.INPUT_CONTENT, this);
        do {
            selItem = menu.getItem();
            switch (selItem) {
                case 3: {
                    this.inputPuzzleFromKeyboard1Line();
                    break;
                }
                case 4: {
                    this.inputPuzzleFromKeyboard9rows();
                    break;
                }
                case 5: {
                    this.inputPuzzleFromKeyboard11rows();
                    break;
                }
                case 6: {
                    this.inputPuzzleFromKeyboard13rows();
                    break;
                }
                case 1: {
                    this.performPuzzleUndo();
                    break;
                }
                case 2: {
                    this.performPuzzleRedo();
                    break;
                }
                default: {
                    this.incorrectSelection();
                }
            }
        } while (selItem != 0);
    }

    private void inputPuzzleFromKeyboard1Line() {
        JanetConsole.print("One line definition: ");
        String line = JanetConsole.readLine();
        int[][] parsedPuzzle = SudokuStore.loadBoardFromStringLine(line);
        if (parsedPuzzle != null) {
            this.trackPuzzleUndo();
            this.puzzle = parsedPuzzle;
        } else {
            JanetConsole.println(">>> !!! Error - incorrect puzzle definition !!! <<<");
        }
    }

    private void inputPuzzleFromKeyboard9rows() {
        JanetConsole.println("You will be asked for inputting 9 rows.");
        JanetConsole.print("Row 1/9: ");
        String r1 = JanetConsole.readLine();
        JanetConsole.print("Row 2/9: ");
        String r2 = JanetConsole.readLine();
        JanetConsole.print("Row 3/9: ");
        String r3 = JanetConsole.readLine();
        JanetConsole.print("Row 4/9: ");
        String r4 = JanetConsole.readLine();
        JanetConsole.print("Row 5/9: ");
        String r5 = JanetConsole.readLine();
        JanetConsole.print("Row 6/9: ");
        String r6 = JanetConsole.readLine();
        JanetConsole.print("Row 7/9: ");
        String r7 = JanetConsole.readLine();
        JanetConsole.print("Row 8/9: ");
        String r8 = JanetConsole.readLine();
        JanetConsole.print("Row 9/9: ");
        String r9 = JanetConsole.readLine();
        int[][] parsedPuzzle = SudokuStore.loadBoardFromStrings(r1, r2, r3, r4, r5, r6, r7, r8, r9);
        if (parsedPuzzle != null) {
            this.trackPuzzleUndo();
            this.puzzle = parsedPuzzle;
        } else {
            JanetConsole.println(">>> !!! Error - incorrect puzzle definition !!! <<<");
        }
    }

    private void inputPuzzleFromKeyboard11rows() {
        JanetConsole.println("You will be asked for inputting 11 rows (2 supporting).");
        JanetConsole.print("Row  1/11: ");
        String r1 = JanetConsole.readLine();
        JanetConsole.print("Row  2/11: ");
        String r2 = JanetConsole.readLine();
        JanetConsole.print("Row  3/11: ");
        String r3 = JanetConsole.readLine();
        JanetConsole.print("Row  4/11: ");
        String r4 = JanetConsole.readLine();
        JanetConsole.print("Row  5/11: ");
        String r5 = JanetConsole.readLine();
        JanetConsole.print("Row  6/11: ");
        String r6 = JanetConsole.readLine();
        JanetConsole.print("Row  7/11: ");
        String r7 = JanetConsole.readLine();
        JanetConsole.print("Row  8/11: ");
        String r8 = JanetConsole.readLine();
        JanetConsole.print("Row  9/11: ");
        String r9 = JanetConsole.readLine();
        JanetConsole.print("Row 10/11: ");
        String r10 = JanetConsole.readLine();
        JanetConsole.print("Row 11/11: ");
        String r11 = JanetConsole.readLine();
        int[][] parsedPuzzle = SudokuStore.loadBoardFromStrings(r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11);
        if (parsedPuzzle != null) {
            this.trackPuzzleUndo();
            this.puzzle = parsedPuzzle;
        } else {
            JanetConsole.println(">>> !!! Error - incorrect puzzle definition !!! <<<");
        }
    }

    private void inputPuzzleFromKeyboard13rows() {
        JanetConsole.println("You will be asked for inputting 13 rows (4 supporting).");
        JanetConsole.print("Row  1/13: ");
        String r1 = JanetConsole.readLine();
        JanetConsole.print("Row  2/13: ");
        String r2 = JanetConsole.readLine();
        JanetConsole.print("Row  3/13: ");
        String r3 = JanetConsole.readLine();
        JanetConsole.print("Row  4/13: ");
        String r4 = JanetConsole.readLine();
        JanetConsole.print("Row  5/13: ");
        String r5 = JanetConsole.readLine();
        JanetConsole.print("Row  6/13: ");
        String r6 = JanetConsole.readLine();
        JanetConsole.print("Row  7/13: ");
        String r7 = JanetConsole.readLine();
        JanetConsole.print("Row  8/13: ");
        String r8 = JanetConsole.readLine();
        JanetConsole.print("Row  9/13: ");
        String r9 = JanetConsole.readLine();
        JanetConsole.print("Row 10/13: ");
        String r10 = JanetConsole.readLine();
        JanetConsole.print("Row 11/13: ");
        String r11 = JanetConsole.readLine();
        JanetConsole.print("Row 12/13: ");
        String r12 = JanetConsole.readLine();
        JanetConsole.print("Row 13/13: ");
        String r13 = JanetConsole.readLine();
        int[][] parsedPuzzle = SudokuStore.loadBoardFromStrings(r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13);
        if (parsedPuzzle != null) {
            this.trackPuzzleUndo();
            this.puzzle = parsedPuzzle;
        } else {
            JanetConsole.println(">>> !!! Error - incorrect puzzle definition !!! <<<");
        }
    }

    private void loopMenuEvaluate() {
        int selItem;
        Menu menu = new Menu("Evaluate puzzle", MenuData.EVALUATE_CONTENT, this);
        do {
            selItem = menu.getItem();
            switch (selItem) {
                case 3: {
                    this.evaluateSolutions();
                    break;
                }
                case 4: {
                    this.ratePuzzleDifficulty();
                    break;
                }
                case 1: {
                    this.performPuzzleUndo();
                    break;
                }
                case 2: {
                    this.performPuzzleRedo();
                    break;
                }
                default: {
                    this.incorrectSelection();
                }
            }
        } while (selItem != 0);
    }

    private void evaluateSolutions() {
        this.solver = new SudokuSolver(this.puzzle);
        int solutionsInfo = this.solver.checkIfUniqueSolution();
        JanetConsole.println(">>>");
        if (solutionsInfo == 1) {
            JanetConsole.println(">>> Solution exists and is unique!");
        } else if (solutionsInfo == 2) {
            JanetConsole.println(">>> Solution exists but is non-unique!");
        } else if (solutionsInfo == -1) {
            JanetConsole.println(">>> Solution does not exists.");
        } else {
            JanetConsole.println(this.solver.getMessages());
        }
        JanetConsole.println(">>> Computing time: " + this.solver.getComputingTime() + " s.");
    }

    private void ratePuzzleDifficulty() {
        int rating = SudokuStore.calculatePuzzleRating(this.puzzle);
        if (rating >= 0) {
            JanetConsole.println(">>>");
            JanetConsole.println(">>> Puzzle rating: " + rating);
            JanetConsole.println(">>>");
        } else {
            JanetConsole.println(">>> !!! Error code: " + rating + " !!! <<<");
            JanetConsole.println(">>> " + ErrorCodes.getErrorDescription(rating));
        }
    }

    private void loopMenuSolve() {
        int selItem;
        Menu menu = new Menu("Solve puzzle", MenuData.SOLVE_CONTENT, this);
        do {
            selItem = menu.getItem();
            switch (selItem) {
                case 3: {
                    this.solveFindFirst();
                    break;
                }
                case 4: {
                    this.solveFindAll();
                    break;
                }
                case 1: {
                    this.performPuzzleUndo();
                    break;
                }
                case 2: {
                    this.performPuzzleRedo();
                    break;
                }
                default: {
                    this.incorrectSelection();
                }
            }
        } while (selItem != 0);
    }

    private void solveFindFirst() {
        this.solver = new SudokuSolver(this.puzzle);
        this.setSolverOptions();
        this.solver.solve();
        if (this.solver.getSolvingState() == 3) {
            this.trackPuzzleUndo();
            this.puzzle = this.solver.getSolvedBoard();
            JanetConsole.println("Path leading to the solution:");
            JanetConsole.println(this.solver.solutionPathToString());
            JanetConsole.println(">>>>> Computing time: " + this.solver.getComputingTime() + " s.");
            JanetConsole.println(">>>>>  Closed routes: " + this.solver.getClosedRoutesNumber());
        } else {
            JanetConsole.println(this.solver.getMessages());
        }
    }

    private void solveFindAll() {
        this.solver = new SudokuSolver(this.puzzle);
        this.setSolverOptions();
        int solutionsNumber = this.solver.findAllSolutions();
        JanetConsole.println(">>>>>>>> Solutions found: " + solutionsNumber);
        if (solutionsNumber > 0) {
            ArrayList<SudokuBoard> solutions = this.solver.getAllSolutionsList();
            int i = 0;
            while (i < solutionsNumber) {
                SudokuBoard solution = solutions.get(i);
                JanetConsole.println(">>>>>    Solution nr: " + i + "/" + solutionsNumber);
                JanetConsole.println(">>>>>        Path nr: " + solution.pathNumber);
                JanetConsole.println(">>>>> Computing time: " + this.solver.getComputingTime() + " s.");
                SudokuStore.consolePrintBoard(solution.board);
                JanetConsole.println(">>>>>");
                JanetConsole.println(">>>>> Hit enter o to continue (non empty line will cancel).");
                String line = JanetConsole.readLine();
                if (line.length() <= 0) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            JanetConsole.println(this.solver.getMessages());
        }
    }

    private void savePuzzle() {
        JanetConsole.print("File path: ");
        String filePath = JanetConsole.readLine();
        File file = new File(filePath);
        if (file.exists()) {
            JanetConsole.println(">>> !!! Error - file already exists !!! <<<");
            return;
        }
        boolean puzzleSaved = SudokuStore.saveBoard(this.puzzle, filePath);
        if (!puzzleSaved) {
            JanetConsole.println(">>> !!! Error while saving !!! <<<");
        }
    }

    private void loopMenuModify() {
        int selItem;
        Menu menu = new Menu("Modify puzzle", MenuData.MODIFY_CONTENT, this);
        do {
            selItem = menu.getItem();
            switch (selItem) {
                case 3: {
                    this.trackPuzzleUndo();
                    this.setCell();
                    break;
                }
                case 4: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.rotateClockWise(this.puzzle);
                    break;
                }
                case 5: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.rotateCounterclockWise(this.puzzle);
                    break;
                }
                case 6: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.transposeTlBr(this.puzzle);
                    break;
                }
                case 7: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.transposeTrBl(this.puzzle);
                    break;
                }
                case 8: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.reflectHorizontally(this.puzzle);
                    break;
                }
                case 9: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.reflectVertically(this.puzzle);
                    break;
                }
                case 10: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.swapColSegmentsRandomly(this.puzzle);
                    break;
                }
                case 11: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.swapRowSegmentsRandomly(this.puzzle);
                    break;
                }
                case 12: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.swapColsInSegmentRandomly(this.puzzle);
                    break;
                }
                case 13: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.swapRowsInSegmentRandomly(this.puzzle);
                    break;
                }
                case 14: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.permuteBoard(this.puzzle);
                    break;
                }
                case 15: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.randomBoardTransf(this.puzzle);
                    break;
                }
                case 16: {
                    this.trackPuzzleUndo();
                    this.puzzle = SudokuStore.seqOfRandomBoardTransf(this.puzzle);
                    break;
                }
                case 1: {
                    this.performPuzzleUndo();
                    break;
                }
                case 2: {
                    this.performPuzzleRedo();
                    break;
                }
                default: {
                    this.incorrectSelection();
                }
            }
        } while (selItem != 0);
    }

    private void setCell() {
        JanetConsole.print("   Row number (between 1 and 9): ");
        int row = JanetConsole.readInt();
        if (row < 1 || row > 9) {
            JanetConsole.println(">>> !!! Error - incorrect row number !!! <<<");
            return;
        }
        JanetConsole.print("Column number (between 1 and 9): ");
        int col = JanetConsole.readInt();
        if (col < 1 || col > 9) {
            JanetConsole.println(">>> !!! Error - incorrect column number !!! <<<");
            return;
        }
        JanetConsole.print("        Digit (between 0 and 9): ");
        int digit = JanetConsole.readInt();
        if (digit < 0 || digit > 9) {
            JanetConsole.println(">>> !!! Error - incorrect digit !!! <<<");
            return;
        }
        this.trackPuzzleUndo();
        this.puzzle[row - 1][col - 1] = digit;
    }

    private void loopMenuOptions() {
        int selItem;
        Menu menu = new Menu("Options", MenuData.OPTIONS_CONTENT, this);
        do {
            selItem = menu.getItem();
            switch (selItem) {
                case 3: {
                    this.rndSeedOnCells = !this.rndSeedOnCells;
                    break;
                }
                case 4: {
                    this.rndSeedOnDigits = !this.rndSeedOnDigits;
                    break;
                }
                case 1: {
                    this.performPuzzleUndo();
                    break;
                }
                case 2: {
                    this.performPuzzleRedo();
                    break;
                }
                default: {
                    this.incorrectSelection();
                }
            }
        } while (selItem != 0);
    }

    private void setSolverOptions() {
        if (this.solver != null) {
            if (this.rndSeedOnCells) {
                this.solver.enableRndSeedOnEmptyCells();
            } else {
                this.solver.disableRndSeedOnEmptyCells();
            }
            if (this.rndSeedOnDigits) {
                this.solver.enableRndSeedOnFreeDigits();
            } else {
                this.solver.disableRndSeedOnFreeDigits();
            }
        }
    }

    private void setGeneratorOptions() {
        if (this.generator != null) {
            if (this.rndSeedOnCells) {
                this.generator.enableRndSeedOnFilledCells();
            } else {
                this.generator.disableRndSeedOnFilledCells();
            }
        }
    }

    private void performPuzzleUndo() {
        if (this.puzzleUndo != null) {
            this.trackPuzzleRedo();
            this.puzzle = this.puzzleUndo;
            this.puzzleUndo = null;
        }
    }

    private void performPuzzleRedo() {
        if (this.puzzleRedo != null) {
            this.trackPuzzleUndo();
            this.puzzle = this.puzzleRedo;
            this.puzzleRedo = null;
        }
    }

    private void trackPuzzleUndo() {
        this.puzzleUndo = SudokuStore.boardCopy(this.puzzle);
    }

    private void trackPuzzleRedo() {
        this.puzzleRedo = SudokuStore.boardCopy(this.puzzle);
    }

    private void displayAboutInto() {
        JanetConsole.println(">>>");
        JanetConsole.println(">>> Janet-Sudoku Demo App based on the Janet-Sudoku Library.");
        JanetConsole.println(">>>");
        JanetConsole.println(">>>                                  Author: Mariusz Gromada");
        JanetConsole.println(">>>                             mariuszgromada.org@gmail.com");
        JanetConsole.println(">>>                    http://janetsudoku.mariuszgromada.org");
        JanetConsole.println(">>>");
        JanetConsole.println(">>>                                Demo App version: v.1.1.1");
        JanetConsole.println(">>>                            Janet-Sudoku version: v.1.1.1");
        JanetConsole.println(">>>");
    }

    private void quitFromApp() {
        JanetConsole.println(">>>");
        JanetConsole.println(">>>                        Thank you for using Janet-Sudoku!");
        JanetConsole.println(">>>");
        JanetConsole.println(">>>                                            Please visit:");
        JanetConsole.println(">>>                    http://janetsudoku.mariuszgromada.org");
        JanetConsole.println(">>>                                    http://mathparser.org");
        JanetConsole.println(">>>                                      http://mathspace.pl");
        JanetConsole.println(">>>");
        JanetConsole.println(">>>                                          Mariusz Gromada");
        JanetConsole.println(">>>                             mariuszgromada.org@gmail.com");
    }

    private void incorrectSelection() {
        JanetConsole.println("Error - unrecognized menu item.");
    }

    public void startApp() {
        this.loopMenuMain();
    }

    public static void start() {
        JanetSudoku js = new JanetSudoku();
        js.startApp();
    }

    public static void main(String[] args) {
        JanetSudoku js = new JanetSudoku();
        js.startApp();
    }

    void consolePrintPuzzle() {
        JanetConsole.println();
        JanetConsole.print(">>> Random seed option - empty cells = " + this.rndSeedOnCells + ", free digits = " + this.rndSeedOnDigits);
        SudokuStore.consolePrintBoard(this.puzzle);
    }
}

