/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku.regtests;

import java.util.ArrayList;
import org.mariuszgromada.math.janetsudoku.BoardCell;
import org.mariuszgromada.math.janetsudoku.SudokuBoard;
import org.mariuszgromada.math.janetsudoku.SudokuGenerator;
import org.mariuszgromada.math.janetsudoku.SudokuPuzzles;
import org.mariuszgromada.math.janetsudoku.SudokuSolver;
import org.mariuszgromada.math.janetsudoku.SudokuStore;
import org.mariuszgromada.math.janetsudoku.utils.FileX;

class ApiTests {
    private static int THREADS_NUMBER;
    private TestRunner[] runners;
    private Thread[] threads;
    boolean[] testsResults;
    static final int NUMBER_OF_TESTS = 8;

    ApiTests(int threadsNumber) {
        THREADS_NUMBER = threadsNumber;
        this.threads = new Thread[THREADS_NUMBER];
        this.runners = new TestRunner[THREADS_NUMBER];
        this.testsResults = new boolean[8];
        int[] testsIds = new int[8];
        int i = 0;
        while (i < 8) {
            testsIds[i] = i;
            ++i;
        }
        i = 0;
        while (i < 8) {
            int lastIndex = 8 - i - 1;
            int j = SudokuStore.randomIndex(8 - i);
            if (j != lastIndex) {
                int l = testsIds[lastIndex];
                testsIds[lastIndex] = testsIds[j];
                testsIds[j] = l;
            }
            ++i;
        }
        int defThreadSize = 8 / THREADS_NUMBER;
        int remaining = 8 - defThreadSize * THREADS_NUMBER;
        int t = 0;
        int i2 = 0;
        while (i2 < THREADS_NUMBER) {
            int threadSize = defThreadSize;
            if (i2 < remaining) {
                ++threadSize;
            }
            int[] assigments = new int[threadSize];
            int j = 0;
            while (j < threadSize) {
                assigments[j] = testsIds[t];
                ++t;
                ++j;
            }
            this.runners[i2] = new TestRunner(i2, assigments);
            this.threads[i2] = new Thread(this.runners[i2]);
            ++i2;
        }
    }

    public void start() {
        int i = 0;
        while (i < THREADS_NUMBER) {
            this.threads[i].start();
            ++i;
        }
        i = 0;
        while (i < THREADS_NUMBER) {
            try {
                this.threads[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    static boolean runTest(int testId, int threadId) {
        boolean testResult = true;
        String testDesc = "";
        String resultDesc = "";
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[9];
        nArray[3] = 8;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[9];
        nArray2[0] = 4;
        nArray2[4] = 1;
        nArray2[5] = 5;
        nArray2[7] = 3;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[9];
        nArray3[1] = 2;
        nArray3[2] = 9;
        nArray3[4] = 4;
        nArray3[6] = 5;
        nArray3[7] = 1;
        nArray3[8] = 8;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[9];
        nArray4[1] = 4;
        nArray4[6] = 1;
        nArray4[7] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[9];
        nArray5[3] = 6;
        nArray5[5] = 2;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[9];
        nArray6[1] = 3;
        nArray6[2] = 2;
        nArray6[7] = 9;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[9];
        nArray7[0] = 6;
        nArray7[1] = 9;
        nArray7[2] = 3;
        nArray7[4] = 5;
        nArray7[6] = 8;
        nArray7[7] = 7;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[9];
        nArray8[1] = 5;
        nArray8[3] = 4;
        nArray8[4] = 8;
        nArray8[8] = 1;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[9];
        nArray9[5] = 3;
        nArrayArray[8] = nArray9;
        int[][] a = nArrayArray;
        switch (testId) {
            case 0: {
                testDesc = "SudokuSolver.setCell(int, int, int)";
                SudokuSolver s = new SudokuSolver();
                s.setCell(0, 0, 0);
                s.setCell(1, 0, 4);
                s.setCell(2, 0, 0);
                s.setCell(3, 0, 0);
                s.setCell(4, 0, 0);
                s.setCell(5, 0, 0);
                s.setCell(6, 0, 6);
                s.setCell(7, 0, 0);
                s.setCell(8, 0, 0);
                s.setCell(0, 1, 0);
                s.setCell(1, 1, 0);
                s.setCell(2, 1, 2);
                s.setCell(3, 1, 4);
                s.setCell(4, 1, 0);
                s.setCell(5, 1, 3);
                s.setCell(6, 1, 9);
                s.setCell(7, 1, 5);
                s.setCell(8, 1, 0);
                s.setCell(0, 2, 0);
                s.setCell(1, 2, 0);
                s.setCell(2, 2, 9);
                s.setCell(3, 2, 0);
                s.setCell(4, 2, 0);
                s.setCell(5, 2, 2);
                s.setCell(6, 2, 3);
                s.setCell(7, 2, 0);
                s.setCell(8, 2, 0);
                s.setCell(0, 3, 8);
                s.setCell(1, 3, 0);
                s.setCell(2, 3, 0);
                s.setCell(3, 3, 0);
                s.setCell(4, 3, 6);
                s.setCell(5, 3, 0);
                s.setCell(6, 3, 0);
                s.setCell(7, 3, 4);
                s.setCell(8, 3, 0);
                s.setCell(0, 4, 0);
                s.setCell(1, 4, 1);
                s.setCell(2, 4, 4);
                s.setCell(3, 4, 0);
                s.setCell(4, 4, 0);
                s.setCell(5, 4, 0);
                s.setCell(6, 4, 5);
                s.setCell(7, 4, 8);
                s.setCell(8, 4, 0);
                s.setCell(0, 5, 0);
                s.setCell(1, 5, 5);
                s.setCell(2, 5, 0);
                s.setCell(3, 5, 0);
                s.setCell(4, 5, 2);
                s.setCell(5, 5, 0);
                s.setCell(6, 5, 0);
                s.setCell(7, 5, 0);
                s.setCell(8, 5, 3);
                s.setCell(0, 6, 0);
                s.setCell(1, 6, 0);
                s.setCell(2, 6, 5);
                s.setCell(3, 6, 1);
                s.setCell(4, 6, 0);
                s.setCell(5, 6, 0);
                s.setCell(6, 6, 8);
                s.setCell(7, 6, 0);
                s.setCell(8, 6, 0);
                s.setCell(0, 7, 0);
                s.setCell(1, 7, 3);
                s.setCell(2, 7, 1);
                s.setCell(3, 7, 2);
                s.setCell(4, 7, 0);
                s.setCell(5, 7, 9);
                s.setCell(6, 7, 7);
                s.setCell(7, 7, 0);
                s.setCell(8, 7, 0);
                s.setCell(0, 8, 0);
                s.setCell(1, 8, 0);
                s.setCell(2, 8, 8);
                s.setCell(3, 8, 0);
                s.setCell(4, 8, 0);
                s.setCell(5, 8, 0);
                s.setCell(6, 8, 0);
                s.setCell(7, 8, 1);
                s.setCell(8, 8, 0);
                int[][] b = s.getBoard();
                if (SudokuStore.boardsAreEqual(a, b)) {
                    resultDesc = "Expecting equal - are equal.";
                    break;
                }
                resultDesc = "Expecting equal - are not equal.";
                testResult = false;
                SudokuStore.consolePrintln(s.getMessages());
                break;
            }
            case 1: {
                testDesc = "SudokuSolver.getCellDigit(int, int)";
                SudokuSolver s1 = new SudokuSolver(a);
                SudokuSolver s2 = new SudokuSolver();
                int i = 0;
                while (i < 9) {
                    int j = 0;
                    while (j < 9) {
                        int d = s1.getCellDigit(i, j);
                        s2.setCell(i, j, d);
                        ++j;
                    }
                    ++i;
                }
                int[][] b = s2.getBoard();
                if (SudokuStore.boardsAreEqual(a, b)) {
                    resultDesc = "Expecting equal - are equal.";
                    break;
                }
                resultDesc = "Expecting equal - are not equal.";
                testResult = false;
                break;
            }
            case 2: {
                testDesc = "SudokuSolver.getBoardCopy()";
                SudokuSolver s = new SudokuSolver(a);
                int[][] b = s.getBoard();
                int[][] c = s.getBoardCopy();
                if (SudokuStore.boardsAreEqual(b, c)) {
                    resultDesc = "Expecting equal - are equal.";
                    break;
                }
                resultDesc = "Expecting equal - are not equal.";
                testResult = false;
                break;
            }
            case 3: {
                BoardCell[] sol;
                testDesc = "SudokuSolver.getSolutionBoardCells()";
                SudokuSolver s = new SudokuSolver(a);
                s.solve();
                int[][] b = s.getSolvedBoard();
                int[][] c = SudokuStore.boardCopy(a);
                BoardCell[] boardCellArray = sol = s.getSolutionBoardCells();
                int n = sol.length;
                int n2 = 0;
                while (n2 < n) {
                    BoardCell bc = boardCellArray[n2];
                    c[bc.rowIndex][bc.colIndex] = bc.digit;
                    ++n2;
                }
                if (SudokuStore.boardsAreEqual(b, c)) {
                    resultDesc = "Expecting equal - are equal.";
                    break;
                }
                resultDesc = "Expecting equal - are not equal.";
                testResult = false;
                break;
            }
            case 4: {
                BoardCell[] bc;
                testDesc = "SudokuSolver.getAllBoardCells()";
                SudokuSolver s = new SudokuSolver(a);
                int[][] b = s.getBoardCopy();
                int[][] c = new int[9][9];
                BoardCell[] boardCellArray = bc = s.getAllBoardCells();
                int n = bc.length;
                int n3 = 0;
                while (n3 < n) {
                    BoardCell cell = boardCellArray[n3];
                    c[cell.rowIndex][cell.colIndex] = cell.digit;
                    ++n3;
                }
                if (SudokuStore.boardsAreEqual(b, c)) {
                    resultDesc = "Expecting equal - are equal.";
                    break;
                }
                resultDesc = "Expecting equal - are not equal.";
                testResult = false;
                break;
            }
            case 5: {
                testDesc = "SudokuSolver.getAllSolutionsList()";
                SudokuSolver s = new SudokuSolver(SudokuPuzzles.PUZZLE_NON_UNIQUE_SOLUTION);
                s.findAllSolutions();
                ArrayList<SudokuBoard> solList = s.getAllSolutionsList();
                for (SudokuBoard sb : solList) {
                    if (SudokuStore.checkSolvedBoard(sb.board)) continue;
                    testResult = false;
                    break;
                }
                if (testResult) {
                    resultDesc = "Expecting each solution valid - each is valid.";
                    break;
                }
                resultDesc = "Expecting each solution valid - found not valid.";
                break;
            }
            case 6: {
                testDesc = "SudokuGenerator -> generate -> save -> load -> compare";
                String filePath = String.valueOf(FileX.getTmpDir()) + FileX.genRndFileName(20, "txt");
                SudokuGenerator g = new SudokuGenerator('1');
                int[][] generated = g.generate();
                g.saveBoard(filePath, "generated", "saved");
                int[][] loaded = SudokuStore.loadBoard(filePath);
                FileX.removeFile(filePath);
                if (!SudokuStore.boardsAreEqual(generated, loaded)) {
                    testResult = false;
                }
                if (testResult) {
                    resultDesc = "Expecting equal - are equal.";
                    break;
                }
                resultDesc = "Expecting equal - are not equal.";
                break;
            }
            case 7: {
                testDesc = "SudokuSolver -> solve -> save -> load -> compare";
                String filePath = String.valueOf(FileX.getTmpDir()) + FileX.genRndFileName(20, "txt");
                SudokuSolver s = new SudokuSolver(SudokuStore.getPuzzleExample());
                s.solve();
                int[][] solved = s.getSolvedBoard();
                s.saveSolvedBoard(filePath, "solved", "saved");
                int[][] loaded = SudokuStore.loadBoard(filePath);
                FileX.removeFile(filePath);
                if (!SudokuStore.boardsAreEqual(solved, loaded)) {
                    testResult = false;
                }
                resultDesc = testResult ? "Expecting equal - are equal." : "Expecting equal - are not equal.";
            }
        }
        if (testResult) {
            SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + " " + testDesc + " " + resultDesc + " >>> ApiTests, result: OK");
        } else {
            SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + " " + testDesc + " " + resultDesc + " >>> ApiTests, result: ERROR");
        }
        return testResult;
    }

    class TestRunner
    implements Runnable {
        int threadId;
        int[] assigments;

        TestRunner(int threadId, int[] assigments) {
            this.assigments = assigments;
            this.threadId = threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTestResult(int t, boolean result) {
            boolean[] blArray = ApiTests.this.testsResults;
            synchronized (ApiTests.this.testsResults) {
                ApiTests.this.testsResults[t] = result;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public void run() {
            int[] nArray = this.assigments;
            int n = this.assigments.length;
            int n2 = 0;
            while (n2 < n) {
                int t = nArray[n2];
                this.setTestResult(t, ApiTests.runTest(t, this.threadId));
                ++n2;
            }
        }
    }
}

