/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.janetsudoku.regtests;

import org.mariuszgromada.math.janetsudoku.ErrorCodes;
import org.mariuszgromada.math.janetsudoku.SudokuGenerator;
import org.mariuszgromada.math.janetsudoku.SudokuPuzzles;
import org.mariuszgromada.math.janetsudoku.SudokuSolver;
import org.mariuszgromada.math.janetsudoku.SudokuStore;

class GeneratorTests {
    private static int THREADS_NUMBER;
    private TestRunner[] runners;
    private Thread[] threads;
    boolean[] testsResults;
    static final int NUMBER_OF_TESTS = 10;

    GeneratorTests(int threadsNumber) {
        THREADS_NUMBER = threadsNumber;
        this.threads = new Thread[THREADS_NUMBER];
        this.runners = new TestRunner[THREADS_NUMBER];
        this.testsResults = new boolean[10];
        int[] testsIds = new int[10];
        int i = 0;
        while (i < 10) {
            testsIds[i] = i;
            ++i;
        }
        i = 0;
        while (i < 10) {
            int lastIndex = 10 - i - 1;
            int j = SudokuStore.randomIndex(10 - i);
            if (j != lastIndex) {
                int l = testsIds[lastIndex];
                testsIds[lastIndex] = testsIds[j];
                testsIds[j] = l;
            }
            ++i;
        }
        int defThreadSize = 10 / THREADS_NUMBER;
        int remaining = 10 - defThreadSize * THREADS_NUMBER;
        int t = 0;
        int i2 = 0;
        while (i2 < THREADS_NUMBER) {
            int threadSize = defThreadSize;
            if (i2 < remaining) {
                ++threadSize;
            }
            int[] assigments = new int[threadSize];
            int j = 0;
            while (j < threadSize) {
                assigments[j] = testsIds[t];
                ++t;
                ++j;
            }
            this.runners[i2] = new TestRunner(i2, assigments);
            this.threads[i2] = new Thread(this.runners[i2]);
            ++i2;
        }
    }

    public void start() {
        int i = 0;
        while (i < THREADS_NUMBER) {
            this.threads[i].start();
            ++i;
        }
        i = 0;
        while (i < THREADS_NUMBER) {
            try {
                this.threads[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    static boolean runTest(int testId, int threadId) {
        boolean testResult = true;
        switch (testId) {
            case 0: {
                int example = 0;
                while (example < 161) {
                    SudokuGenerator g = new SudokuGenerator(example, '3');
                    int[][] genPuzzle = g.generate();
                    SudokuSolver solverGen = new SudokuSolver(genPuzzle);
                    ErrorCodes.consolePrintlnIfError(solverGen.solve());
                    SudokuSolver solverInit = new SudokuSolver(example);
                    ErrorCodes.consolePrintlnIfError(solverInit.solve());
                    int solUnq = solverGen.checkIfUniqueSolution();
                    ErrorCodes.consolePrintlnIfError(solUnq);
                    int[][] solvedGen = solverGen.getSolvedBoard();
                    int[][] solvedInit = solverInit.getSolvedBoard();
                    if (solUnq != 1 || !SudokuStore.boardsAreEqual(solvedGen, solvedInit)) {
                        testResult = false;
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by example number, example: " + example + ", solution unique and correct: NO, time (g, s1, s2): " + g.getComputingTime() + " s., " + solverGen.getComputingTime() + " s., " + solverInit.getComputingTime() + " s.");
                        System.out.println("Initial board");
                        SudokuStore.consolePrintBoard(SudokuStore.getPuzzleExample(example));
                        System.out.println("Generated puzzle");
                        SudokuStore.consolePrintBoard(genPuzzle);
                        System.out.println("Solved initial board");
                        SudokuStore.consolePrintBoard(solvedInit);
                        System.out.println("Solved generated puzzle");
                        SudokuStore.consolePrintBoard(solvedGen);
                    }
                    ++example;
                }
                break;
            }
            case 1: {
                int example = 0;
                while (example < 161) {
                    int[][] initBoard = SudokuStore.getPuzzleExample(example);
                    SudokuGenerator g = new SudokuGenerator(initBoard, '3', '2');
                    int[][] genPuzzle = g.generate();
                    SudokuSolver solverGen = new SudokuSolver(genPuzzle);
                    ErrorCodes.consolePrintlnIfError(solverGen.solve());
                    SudokuSolver solverInit = new SudokuSolver(initBoard);
                    ErrorCodes.consolePrintlnIfError(solverInit.solve());
                    int solUnq = solverGen.checkIfUniqueSolution();
                    ErrorCodes.consolePrintlnIfError(solUnq);
                    int[][] solvedGen = solverGen.getSolvedBoard();
                    int[][] solvedInit = solverInit.getSolvedBoard();
                    if (solUnq != 1 || !SudokuStore.boardsAreEqual(solvedGen, solvedInit)) {
                        testResult = false;
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by example board, example: " + example + ", solution unique and correct: NO, time (g, s1, s2): " + g.getComputingTime() + " s., " + solverGen.getComputingTime() + " s., " + solverInit.getComputingTime() + " s.");
                        System.out.println("Initial board");
                        SudokuStore.consolePrintBoard(initBoard);
                        System.out.println("Generated puzzle");
                        SudokuStore.consolePrintBoard(genPuzzle);
                        System.out.println("Solved initial board");
                        SudokuStore.consolePrintBoard(solvedInit);
                        System.out.println("Solved generated puzzle");
                        SudokuStore.consolePrintBoard(solvedGen);
                    }
                    ++example;
                }
                break;
            }
            case 2: {
                int example = 0;
                while (example < 161) {
                    SudokuGenerator g = new SudokuGenerator(example, new char[0]);
                    int[][] genPuzzle = g.generate();
                    SudokuSolver solverGen = new SudokuSolver(genPuzzle);
                    ErrorCodes.consolePrintlnIfError(solverGen.solve());
                    int solUnq = solverGen.checkIfUniqueSolution();
                    ErrorCodes.consolePrintlnIfError(solUnq);
                    int[][] solvedGen = solverGen.getSolvedBoard();
                    if (solUnq != 1 || !SudokuStore.checkPuzzle(genPuzzle)) {
                        testResult = false;
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by example number, example: " + example + ", solution unique and correct: NO, time (g, s): " + g.getComputingTime() + " s., " + solverGen.getComputingTime() + " s., ");
                        System.out.println("Generated puzzle");
                        SudokuStore.consolePrintBoard(genPuzzle);
                        System.out.println("Solved generated puzzle");
                        SudokuStore.consolePrintBoard(solvedGen);
                    }
                    ++example;
                }
                break;
            }
            case 3: {
                int example = 0;
                while (example < 161) {
                    int[][] initBoard = SudokuStore.getPuzzleExample(example);
                    SudokuGenerator g = new SudokuGenerator(initBoard, '2');
                    int[][] genPuzzle = g.generate();
                    SudokuSolver solverGen = new SudokuSolver(genPuzzle);
                    ErrorCodes.consolePrintlnIfError(solverGen.solve());
                    int solUnq = solverGen.checkIfUniqueSolution();
                    ErrorCodes.consolePrintlnIfError(solUnq);
                    int[][] solvedGen = solverGen.getSolvedBoard();
                    if (solUnq != 1 || !SudokuStore.checkPuzzle(genPuzzle)) {
                        testResult = false;
                        SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by example board, example: " + example + ", solution unique and correct: NO, time (g, s): " + g.getComputingTime() + " s., " + solverGen.getComputingTime() + " s., ");
                        System.out.println("Generated puzzle");
                        SudokuStore.consolePrintBoard(genPuzzle);
                        System.out.println("Solved initial board");
                        SudokuStore.consolePrintBoard(solvedGen);
                    }
                    ++example;
                }
                break;
            }
            case 5: {
                int[][] initBoard = SudokuPuzzles.PUZZLE_EMPTY;
                SudokuGenerator g = new SudokuGenerator(initBoard, new char[0]);
                int[][] genPuzzle = g.generate();
                SudokuSolver solverGen = new SudokuSolver(genPuzzle);
                ErrorCodes.consolePrintlnIfError(solverGen.solve());
                int solUnq = solverGen.checkIfUniqueSolution();
                ErrorCodes.consolePrintlnIfError(solUnq);
                int[][] solvedGen = solverGen.getSolvedBoard();
                if (solUnq == 1 && SudokuStore.checkPuzzle(genPuzzle)) break;
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by empty board, solution unique and correct: NO, time (g, s): " + g.getComputingTime() + " s., " + solverGen.getComputingTime() + " s., ");
                System.out.println("Generated puzzle");
                SudokuStore.consolePrintBoard(genPuzzle);
                System.out.println("Solved initial board");
                SudokuStore.consolePrintBoard(solvedGen);
                break;
            }
            case 6: {
                int[][] initBoard = SudokuPuzzles.PUZZLE_EMPTY;
                SudokuGenerator g = new SudokuGenerator(initBoard, '2');
                if (g.getGeneratorState() == -1) {
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by empty board, solution unique and correct: YES, time (g, s): ");
                    break;
                }
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by empty board, solution unique and correct: NO, time (g, s): ");
                SudokuStore.consolePrintln("Generator state: " + g.getGeneratorState());
                System.out.println(g.getMessages());
                break;
            }
            case 7: {
                int[][] initBoard = SudokuPuzzles.PUZZLE_ERROR;
                SudokuGenerator g = new SudokuGenerator(initBoard, '2');
                if (g.getGeneratorState() == -1) {
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by PUZZLE_ERROR + PARAM_DO_NOT_SOLVE, init failed: YES.");
                    break;
                }
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by PUZZLE_ERROR + PARAM_DO_NOT_SOLVE, init failed: NO.");
                SudokuStore.consolePrintln("Generator state: " + g.getGeneratorState());
                System.out.println(g.getMessages());
                break;
            }
            case 8: {
                int[][] initBoard = SudokuPuzzles.PUZZLE_NON_UNIQUE_SOLUTION;
                SudokuGenerator g = new SudokuGenerator(initBoard, new char[0]);
                int[][] genPuzzle = g.generate();
                SudokuSolver solverGen = new SudokuSolver(genPuzzle);
                ErrorCodes.consolePrintlnIfError(solverGen.solve());
                int solUnq = solverGen.checkIfUniqueSolution();
                ErrorCodes.consolePrintlnIfError(solUnq);
                int[][] solvedGen = solverGen.getSolvedBoard();
                if (solUnq == 1 && SudokuStore.checkPuzzle(genPuzzle)) break;
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by empty board, solution unique and correct: NO, time (g, s): " + g.getComputingTime() + " s., " + solverGen.getComputingTime() + " s., ");
                System.out.println("Generated puzzle");
                SudokuStore.consolePrintBoard(genPuzzle);
                System.out.println("Solved initial board");
                SudokuStore.consolePrintBoard(solvedGen);
                break;
            }
            case 9: {
                int[][] initBoard = SudokuPuzzles.PUZZLE_NON_UNIQUE_SOLUTION;
                SudokuGenerator g = new SudokuGenerator(initBoard, '2');
                if (g.getGeneratorState() == -1) {
                    SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by PUZZLE_NON_UNIQUE_SOLUTION + PARAM_DO_NOT_SOLVE, init failed: YES.");
                    break;
                }
                testResult = false;
                SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + ", generate by PUZZLE_NON_UNIQUE_SOLUTION + PARAM_DO_NOT_SOLVE, init failed: NO.");
                SudokuStore.consolePrintln("Generator state: " + g.getGeneratorState());
                System.out.println(g.getMessages());
            }
        }
        if (testResult) {
            SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + " >>>>>>>>>>>>>>>>>>>>>> SudokuGenerator, result: OK");
        } else {
            SudokuStore.consolePrintln("(Thread: " + threadId + ") " + "Test: " + testId + " >>>>>>>>>>>>>>>>>>>>>> SudokuGenerator, result: ERROR");
        }
        return testResult;
    }

    class TestRunner
    implements Runnable {
        int threadId;
        int[] assigments;

        TestRunner(int threadId, int[] assigments) {
            this.assigments = assigments;
            this.threadId = threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTestResult(int t, boolean result) {
            boolean[] blArray = GeneratorTests.this.testsResults;
            synchronized (GeneratorTests.this.testsResults) {
                GeneratorTests.this.testsResults[t] = result;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public void run() {
            int[] nArray = this.assigments;
            int n = this.assigments.length;
            int n2 = 0;
            while (n2 < n) {
                int t = nArray[n2];
                this.setTestResult(t, GeneratorTests.runTest(t, this.threadId));
                ++n2;
            }
        }
    }
}

